/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnforcerHealth
extends ConfigObject {
    public static final Integer GOOD = 0;
    public static final Integer POOR = 1;
    public static final Integer CRITICAL = 2;
    private static final long serialVersionUID = 1L;
    private Integer healthStatus;
    private String healthReasons;

    public EnforcerHealth() {
        this(true);
    }

    public EnforcerHealth(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "EnforcerHealth";
    }

    public Integer getHealthStatus() {
        return this.healthStatus;
    }

    public String getHealthStatusValue() throws ValidationException {
        if (this.healthStatus == null) {
            return null;
        }
        String s = null;
        switch (this.healthStatus) {
            case 0: {
                s = "GOOD";
                break;
            }
            case 1: {
                s = "POOR";
                break;
            }
            case 2: {
                s = "CRITICAL";
                break;
            }
            default: {
                throw new ValidationException("EnforcerHealth/HealthStatus: invalid attribute value:" + this.healthStatus + "!");
            }
        }
        return s;
    }

    public void setHealthStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.healthStatus = value;
    }

    public void setHealthStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("GOOD".equals(value)) {
            this.healthStatus = GOOD;
        } else if ("POOR".equals(value)) {
            this.healthStatus = POOR;
        } else if ("CRITICAL".equals(value)) {
            this.healthStatus = CRITICAL;
        } else {
            throw new ValidationException("EnforcerHealth/HealthStatus: invalid attribute value:" + value + "!");
        }
    }

    public String getHealthReasons() {
        return this.healthReasons;
    }

    public void setHealthReasons(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.healthReasons = value;
    }

    @Override
    public int getObjectType() {
        return 577;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.healthStatus == null) {
            throw new ValidationException("EnforcerHealth/HealthStatus: attribute is required!");
        }
        if (this.healthReasons == null) {
            throw new ValidationException("EnforcerHealth/HealthReasons: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("HealthStatus");
            if (value == null) {
                throw new ValidationException("EnforcerHealth/HealthStatus: attribute is required!");
            }
            this.setHealthStatusValue(value);
            value = attris.getValue("HealthReasons");
            if (value == null) {
                throw new ValidationException("EnforcerHealth/HealthReasons: attribute is required!");
            }
            this.healthReasons = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EnforcerHealth".equals(element.getNodeName())) {
            throw new ValidationException("EnforcerHealth: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "HealthStatus");
        if (value == null) {
            throw new ValidationException("EnforcerHealth/HealthStatus: attribute is required!");
        }
        this.setHealthStatusValue(value);
        value = XMLHelper.getAttribute(element, "HealthReasons");
        if (value == null) {
            throw new ValidationException("EnforcerHealth/HealthReasons: attribute is required!");
        }
        this.healthReasons = value;
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EnforcerHealth/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EnforcerHealth/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EnforcerHealth");
        if (this.healthStatus != null) {
            element.setAttribute("HealthStatus", this.getHealthStatusValue());
        }
        if (this.healthReasons != null) {
            element.setAttribute("HealthReasons", this.healthReasons);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EnforcerHealth ");
            if (this.healthStatus != null) {
                strAttrs.append("HealthStatus=\"").append(this.getHealthStatusValue()).append("\" ");
            }
            if (this.healthReasons != null) {
                strAttrs.append("HealthReasons=\"").append(AbstractSchema.checkXMLContent(this.healthReasons)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EnforcerHealth>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

