/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.EnforcerGroupPrivilege;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnforcerGroupPrivilegeSet
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public EnforcerGroupPrivilegeSet() {
        this(true);
    }

    public EnforcerGroupPrivilegeSet(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(127, new ChildGroup(0, 1));
        this.children.put(134, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "EnforcerGroupPrivilegeSet";
    }

    public PrivilegeValue getOptPrivilegeValue() {
        ChildGroup childGroup = (ChildGroup)this.children.get(127);
        if (childGroup.size() > 0) {
            return (PrivilegeValue)childGroup.get(0);
        }
        return null;
    }

    public void setOptPrivilegeValue(PrivilegeValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PrivilegeValue obj = this.getOptPrivilegeValue();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addEnforcerGroupPrivilege(EnforcerGroupPrivilege value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addEnforcerGroupPrivilege(int index, EnforcerGroupPrivilege value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<EnforcerGroupPrivilege> getEnforcerGroupPrivilege() {
        Vector<EnforcerGroupPrivilege> v = new Vector<EnforcerGroupPrivilege>();
        for (Transportable child : (ChildGroup)this.children.get(134)) {
            v.add((EnforcerGroupPrivilege)child);
        }
        return v;
    }

    public int getEnforcerGroupPrivilegeCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(134);
        return childGroup.size();
    }

    public EnforcerGroupPrivilege getEnforcerGroupPrivilege(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(134);
        return (EnforcerGroupPrivilege)childGroup.get(index);
    }

    public void setEnforcerGroupPrivilege(int index, EnforcerGroupPrivilege value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeEnforcerGroupPrivilege(EnforcerGroupPrivilege value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 133;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof PrivilegeValue) {
            try {
                this.setOptPrivilegeValue((PrivilegeValue)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof EnforcerGroupPrivilege) {
            try {
                this.addEnforcerGroupPrivilege((EnforcerGroupPrivilege)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getOptPrivilegeValue() != null) {
            this.getOptPrivilegeValue().setReadonly();
        }
        int objCnt = this.getEnforcerGroupPrivilegeCount();
        for (i = 0; i < objCnt; ++i) {
            this.getEnforcerGroupPrivilege(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EnforcerGroupPrivilegeSet".equals(element.getNodeName())) {
            throw new ValidationException("EnforcerGroupPrivilegeSet: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "PrivilegeValue");
        if (v.size() > 0) {
            PrivilegeValue privilegeValueObj = new PrivilegeValue();
            privilegeValueObj.importFromElement(v.get(0));
            this.setOptPrivilegeValue(privilegeValueObj);
        }
        v = XMLHelper.getChildElementByName(element, "EnforcerGroupPrivilege");
        for (int i = 0; i < v.size(); ++i) {
            EnforcerGroupPrivilege enforcerGroupPrivilegeObj = new EnforcerGroupPrivilege();
            enforcerGroupPrivilegeObj.importFromElement(v.get(i));
            this.addEnforcerGroupPrivilege(enforcerGroupPrivilegeObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EnforcerGroupPrivilegeSet/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EnforcerGroupPrivilegeSet/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EnforcerGroupPrivilegeSet");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EnforcerGroupPrivilegeSet ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EnforcerGroupPrivilegeSet>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

