/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnabledClientFeatures
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String minVersion;
    private Boolean editable;
    private Boolean primary;

    public EnabledClientFeatures() {
        this(true);
    }

    public EnabledClientFeatures(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(777, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "EnabledClientFeatures";
    }

    public String getDefMinVersion() {
        return "14.3.5000.0";
    }

    public String getOptMinVersion() {
        return this.minVersion;
    }

    public void setOptMinVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.minVersion = value;
    }

    public Boolean getDefEditable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEditable() {
        return this.editable;
    }

    public void setOptEditable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.editable = value;
    }

    public Boolean getDefPrimary() {
        return Boolean.FALSE;
    }

    public Boolean getOptPrimary() {
        return this.primary;
    }

    public void setOptPrimary(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.primary = value;
    }

    public void addClientFeature(ClientFeature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addClientFeature(int index, ClientFeature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ClientFeature> getClientFeature() {
        Vector<ClientFeature> v = new Vector<ClientFeature>();
        for (Transportable child : (ChildGroup)this.children.get(777)) {
            v.add((ClientFeature)child);
        }
        return v;
    }

    public int getClientFeatureCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(777);
        return childGroup.size();
    }

    public ClientFeature getClientFeature(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(777);
        return (ClientFeature)childGroup.get(index);
    }

    public void setClientFeature(int index, ClientFeature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeClientFeature(ClientFeature value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 776;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ClientFeature) {
            try {
                this.addClientFeature((ClientFeature)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("MinVersion");
            if (value != null) {
                this.minVersion = value;
            }
            if ((value = attris.getValue("Editable")) != null) {
                this.editable = "1".equals(value);
            }
            if ((value = attris.getValue("Primary")) != null) {
                this.primary = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getClientFeatureCount();
        for (i = 0; i < objCnt; ++i) {
            this.getClientFeature(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EnabledClientFeatures".equals(element.getNodeName())) {
            throw new ValidationException("EnabledClientFeatures: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "MinVersion");
        if (value != null) {
            this.minVersion = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Editable")) != null) {
            this.editable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Primary")) != null) {
            this.primary = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ClientFeature");
        for (int i = 0; i < v.size(); ++i) {
            ClientFeature clientFeatureObj = new ClientFeature();
            clientFeatureObj.importFromElement(v.get(i));
            this.addClientFeature(clientFeatureObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EnabledClientFeatures/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EnabledClientFeatures/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EnabledClientFeatures");
        if (this.minVersion != null) {
            element.setAttribute("MinVersion", this.minVersion);
        }
        if (this.editable != null) {
            element.setAttribute("Editable", this.editable != false ? "1" : "0");
        }
        if (this.primary != null) {
            element.setAttribute("Primary", this.primary != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EnabledClientFeatures ");
            if (this.minVersion != null) {
                strAttrs.append("MinVersion=\"").append(AbstractSchema.checkXMLContent(this.minVersion)).append("\" ");
            }
            if (this.editable != null) {
                strAttrs.append("Editable=").append(this.editable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.primary != null) {
                strAttrs.append("Primary=").append(this.primary != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EnabledClientFeatures>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

