/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EmailServerConfig
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String smtpServerAddress;
    private Integer smtpServerPort;
    private Boolean requireAuthentication;
    private String authenticationServerAddress;
    private String userName;
    private String userPassword;
    private String reversePath;
    private String senderAddress;
    private Boolean sSLConnection;
    private Boolean tLSConnection;
    private Boolean disableCertValidation;

    public EmailServerConfig() {
        this(true);
    }

    public EmailServerConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "EmailServerConfig";
    }

    public String getSmtpServerAddress() {
        return this.smtpServerAddress;
    }

    public void setSmtpServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smtpServerAddress = value;
    }

    public Integer getDefSmtpServerPort() {
        return 25;
    }

    public Integer getOptSmtpServerPort() {
        return this.smtpServerPort;
    }

    public void setOptSmtpServerPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smtpServerPort = value;
    }

    public Boolean getRequireAuthentication() {
        return this.requireAuthentication;
    }

    public void setRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.requireAuthentication = value;
    }

    public String getOptAuthenticationServerAddress() {
        return this.authenticationServerAddress;
    }

    public void setOptAuthenticationServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authenticationServerAddress = value;
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userName = value;
    }

    public String getOptUserPassword() {
        try {
            return Utility.decrypt(this.userPassword);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptUserPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.userPassword = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOptReversePath() {
        return this.reversePath;
    }

    public void setOptReversePath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.reversePath = value;
    }

    public String getOptSenderAddress() {
        return this.senderAddress;
    }

    public void setOptSenderAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.senderAddress = value;
    }

    public Boolean getDefSSLConnection() {
        return Boolean.FALSE;
    }

    public Boolean getOptSSLConnection() {
        return this.sSLConnection;
    }

    public void setOptSSLConnection(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sSLConnection = value;
    }

    public Boolean getDefTLSConnection() {
        return Boolean.FALSE;
    }

    public Boolean getOptTLSConnection() {
        return this.tLSConnection;
    }

    public void setOptTLSConnection(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.tLSConnection = value;
    }

    public Boolean getDefDisableCertValidation() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableCertValidation() {
        return this.disableCertValidation;
    }

    public void setOptDisableCertValidation(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableCertValidation = value;
    }

    @Override
    public int getObjectType() {
        return 57;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.smtpServerAddress == null) {
            throw new ValidationException("EmailServerConfig/SmtpServerAddress: attribute is required!");
        }
        if (this.requireAuthentication == null) {
            throw new ValidationException("EmailServerConfig/RequireAuthentication: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SmtpServerAddress");
            if (value == null) {
                throw new ValidationException("EmailServerConfig/SmtpServerAddress: attribute is required!");
            }
            this.smtpServerAddress = value;
            value = attris.getValue("SmtpServerPort");
            if (value != null) {
                try {
                    this.smtpServerPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("EmailServerConfig/SmtpServerPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("EmailServerConfig/SmtpServerPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RequireAuthentication")) == null) {
                throw new ValidationException("EmailServerConfig/RequireAuthentication: attribute is required!");
            }
            this.requireAuthentication = "1".equals(value);
            value = attris.getValue("AuthenticationServerAddress");
            if (value != null) {
                this.authenticationServerAddress = value;
            }
            if ((value = attris.getValue("UserName")) != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("UserPassword")) != null) {
                this.userPassword = value;
            }
            if ((value = attris.getValue("ReversePath")) != null) {
                this.reversePath = value;
            }
            if ((value = attris.getValue("SenderAddress")) != null) {
                this.senderAddress = value;
            }
            if ((value = attris.getValue("SSLConnection")) != null) {
                this.sSLConnection = "1".equals(value);
            }
            if ((value = attris.getValue("TLSConnection")) != null) {
                this.tLSConnection = "1".equals(value);
            }
            if ((value = attris.getValue("DisableCertValidation")) != null) {
                this.disableCertValidation = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EmailServerConfig".equals(element.getNodeName())) {
            throw new ValidationException("EmailServerConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SmtpServerAddress");
        if (value == null) {
            throw new ValidationException("EmailServerConfig/SmtpServerAddress: attribute is required!");
        }
        this.smtpServerAddress = value;
        value = XMLHelper.getAttribute(element, "SmtpServerPort");
        if (value != null) {
            try {
                this.smtpServerPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("EmailServerConfig/SmtpServerPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RequireAuthentication")) == null) {
            throw new ValidationException("EmailServerConfig/RequireAuthentication: attribute is required!");
        }
        this.requireAuthentication = "1".equals(value);
        value = XMLHelper.getAttribute(element, "AuthenticationServerAddress");
        if (value != null) {
            this.authenticationServerAddress = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UserName")) != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UserPassword")) != null) {
            this.userPassword = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReversePath")) != null) {
            this.reversePath = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SenderAddress")) != null) {
            this.senderAddress = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SSLConnection")) != null) {
            this.sSLConnection = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TLSConnection")) != null) {
            this.tLSConnection = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableCertValidation")) != null) {
            this.disableCertValidation = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EmailServerConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EmailServerConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EmailServerConfig");
        if (this.smtpServerAddress != null) {
            element.setAttribute("SmtpServerAddress", this.smtpServerAddress);
        }
        if (this.smtpServerPort != null) {
            element.setAttribute("SmtpServerPort", this.smtpServerPort.toString());
        }
        if (this.requireAuthentication != null) {
            element.setAttribute("RequireAuthentication", this.requireAuthentication != false ? "1" : "0");
        }
        if (this.authenticationServerAddress != null) {
            element.setAttribute("AuthenticationServerAddress", this.authenticationServerAddress);
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.userPassword != null) {
            element.setAttribute("UserPassword", this.userPassword);
        }
        if (this.reversePath != null) {
            element.setAttribute("ReversePath", this.reversePath);
        }
        if (this.senderAddress != null) {
            element.setAttribute("SenderAddress", this.senderAddress);
        }
        if (this.sSLConnection != null) {
            element.setAttribute("SSLConnection", this.sSLConnection != false ? "1" : "0");
        }
        if (this.tLSConnection != null) {
            element.setAttribute("TLSConnection", this.tLSConnection != false ? "1" : "0");
        }
        if (this.disableCertValidation != null) {
            element.setAttribute("DisableCertValidation", this.disableCertValidation != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EmailServerConfig ");
            if (this.smtpServerAddress != null) {
                strAttrs.append("SmtpServerAddress=\"").append(AbstractSchema.checkXMLContent(this.smtpServerAddress)).append("\" ");
            }
            if (this.smtpServerPort != null) {
                strAttrs.append("SmtpServerPort=\"").append(this.smtpServerPort.toString()).append("\" ");
            }
            if (this.requireAuthentication != null) {
                strAttrs.append("RequireAuthentication=").append(this.requireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.authenticationServerAddress != null) {
                strAttrs.append("AuthenticationServerAddress=\"").append(AbstractSchema.checkXMLContent(this.authenticationServerAddress)).append("\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.userPassword != null) {
                strAttrs.append("UserPassword=\"").append(AbstractSchema.checkXMLContent(this.userPassword)).append("\" ");
            }
            if (this.reversePath != null) {
                strAttrs.append("ReversePath=\"").append(AbstractSchema.checkXMLContent(this.reversePath)).append("\" ");
            }
            if (this.senderAddress != null) {
                strAttrs.append("SenderAddress=\"").append(AbstractSchema.checkXMLContent(this.senderAddress)).append("\" ");
            }
            if (this.sSLConnection != null) {
                strAttrs.append("SSLConnection=").append(this.sSLConnection != false ? "\"1\" " : "\"0\" ");
            }
            if (this.tLSConnection != null) {
                strAttrs.append("TLSConnection=").append(this.tLSConnection != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableCertValidation != null) {
                strAttrs.append("DisableCertValidation=").append(this.disableCertValidation != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EmailServerConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

