/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ReplicationDirectoryServer;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DirectoryServer
extends ConfigObject
implements NamedObject {
    public static final Integer ADDC = 0;
    public static final Integer LDAP = 1;
    private static final long serialVersionUID = 1L;
    private String guid;
    private String name;
    private Integer type;
    private String description;
    private String refId;
    private String serverAddress;
    private Boolean useSSL;
    private Boolean disableCertValidate;
    private Long port;
    private String username;
    private String password;
    private String baseDN;

    public DirectoryServer() {
        this(true);
    }

    public DirectoryServer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(61, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "DirectoryServer";
    }

    public String getOptGuid() {
        return this.guid;
    }

    public void setOptGuid(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.guid = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "ADDC";
                break;
            }
            case 1: {
                s = "LDAP";
                break;
            }
            default: {
                throw new ValidationException("DirectoryServer/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    public void setTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ADDC".equals(value)) {
            this.type = ADDC;
        } else if ("LDAP".equals(value)) {
            this.type = LDAP;
        } else {
            throw new ValidationException("DirectoryServer/Type: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverAddress = value;
    }

    public Boolean getDefUseSSL() {
        return Boolean.TRUE;
    }

    public Boolean getOptUseSSL() {
        return this.useSSL;
    }

    public void setOptUseSSL(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useSSL = value;
    }

    public Boolean getDefDisableCertValidate() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableCertValidate() {
        return this.disableCertValidate;
    }

    public void setOptDisableCertValidate(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableCertValidate = value;
    }

    public Long getOptPort() {
        return this.port;
    }

    public void setOptPort(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public String getOptUsername() {
        return this.username;
    }

    public void setOptUsername(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.username = value;
    }

    public String getOptPassword() {
        try {
            return Utility.decrypt(this.password);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.password = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOptBaseDN() {
        return this.baseDN;
    }

    public void setOptBaseDN(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.baseDN = value;
    }

    public ReplicationDirectoryServer getOptReplicationDirectoryServer() {
        ChildGroup childGroup = (ChildGroup)this.children.get(61);
        if (childGroup.size() > 0) {
            return (ReplicationDirectoryServer)childGroup.get(0);
        }
        return null;
    }

    public void setOptReplicationDirectoryServer(ReplicationDirectoryServer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ReplicationDirectoryServer obj = this.getOptReplicationDirectoryServer();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 60;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("DirectoryServer/Name: attribute is required!");
        }
        if (this.type == null) {
            throw new ValidationException("DirectoryServer/Type: attribute is required!");
        }
        if (this.serverAddress == null) {
            throw new ValidationException("DirectoryServer/ServerAddress: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ReplicationDirectoryServer) {
            try {
                this.setOptReplicationDirectoryServer((ReplicationDirectoryServer)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Guid");
            if (value != null) {
                this.guid = value;
            }
            if ((value = attris.getValue("Name")) == null) {
                throw new ValidationException("DirectoryServer/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Type");
            if (value == null) {
                throw new ValidationException("DirectoryServer/Type: attribute is required!");
            }
            this.setTypeValue(value);
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("ServerAddress")) == null) {
                throw new ValidationException("DirectoryServer/ServerAddress: attribute is required!");
            }
            this.serverAddress = value;
            value = attris.getValue("UseSSL");
            if (value != null) {
                this.useSSL = "1".equals(value);
            }
            if ((value = attris.getValue("DisableCertValidate")) != null) {
                this.disableCertValidate = "1".equals(value);
            }
            if ((value = attris.getValue("Port")) != null) {
                try {
                    this.port = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DirectoryServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DirectoryServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Username")) != null) {
                this.username = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("BaseDN")) != null) {
                this.baseDN = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptReplicationDirectoryServer() != null) {
            this.getOptReplicationDirectoryServer().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"DirectoryServer".equals(element.getNodeName())) {
            throw new ValidationException("DirectoryServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Guid");
        if (value != null) {
            this.guid = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) == null) {
            throw new ValidationException("DirectoryServer/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Type");
        if (value == null) {
            throw new ValidationException("DirectoryServer/Type: attribute is required!");
        }
        this.setTypeValue(value);
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ServerAddress")) == null) {
            throw new ValidationException("DirectoryServer/ServerAddress: attribute is required!");
        }
        this.serverAddress = value;
        value = XMLHelper.getAttribute(element, "UseSSL");
        if (value != null) {
            this.useSSL = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableCertValidate")) != null) {
            this.disableCertValidate = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            try {
                this.port = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DirectoryServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Username")) != null) {
            this.username = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "BaseDN")) != null) {
            this.baseDN = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "ReplicationDirectoryServer")).size() > 0) {
            ReplicationDirectoryServer replicationDirectoryServerObj = new ReplicationDirectoryServer();
            replicationDirectoryServerObj.importFromElement(v.get(0));
            this.setOptReplicationDirectoryServer(replicationDirectoryServerObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DirectoryServer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DirectoryServer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DirectoryServer");
        if (this.guid != null) {
            element.setAttribute("Guid", this.guid);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.getTypeValue());
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.serverAddress != null) {
            element.setAttribute("ServerAddress", this.serverAddress);
        }
        if (this.useSSL != null) {
            element.setAttribute("UseSSL", this.useSSL != false ? "1" : "0");
        }
        if (this.disableCertValidate != null) {
            element.setAttribute("DisableCertValidate", this.disableCertValidate != false ? "1" : "0");
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.username != null) {
            element.setAttribute("Username", this.username);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.baseDN != null) {
            element.setAttribute("BaseDN", this.baseDN);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DirectoryServer ");
            if (this.guid != null) {
                strAttrs.append("Guid=\"").append(AbstractSchema.checkXMLContent(this.guid)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getTypeValue()).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.serverAddress != null) {
                strAttrs.append("ServerAddress=\"").append(AbstractSchema.checkXMLContent(this.serverAddress)).append("\" ");
            }
            if (this.useSSL != null) {
                strAttrs.append("UseSSL=").append(this.useSSL != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableCertValidate != null) {
                strAttrs.append("DisableCertValidate=").append(this.disableCertValidate != false ? "\"1\" " : "\"0\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.username != null) {
                strAttrs.append("Username=\"").append(AbstractSchema.checkXMLContent(this.username)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.baseDN != null) {
                strAttrs.append("BaseDN=\"").append(AbstractSchema.checkXMLContent(this.baseDN)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DirectoryServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

