/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.Extension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DirectoryOverride
extends ConfigObject {
    public static final Integer GEPT_RISK = 0;
    public static final Integer GEPT_HPP = 1;
    public static final Integer ALL = 2;
    public static final Integer GEPT_ADC = 3;
    private static final long serialVersionUID = 1L;
    private String prefixVariable;
    private String directoryPath;
    private Boolean excludeSubDirectories;
    private String oSType;
    private Integer scanType;

    public DirectoryOverride() {
        this(true);
    }

    public DirectoryOverride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(607, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "DirectoryOverride";
    }

    public String getPrefixVariable() {
        return this.prefixVariable;
    }

    public void setPrefixVariable(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.prefixVariable = value;
    }

    public String getOptDirectoryPath() {
        return this.directoryPath;
    }

    public void setOptDirectoryPath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.directoryPath = value;
    }

    public Boolean getDefExcludeSubDirectories() {
        return Boolean.TRUE;
    }

    public Boolean getOptExcludeSubDirectories() {
        return this.excludeSubDirectories;
    }

    public void setOptExcludeSubDirectories(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.excludeSubDirectories = value;
    }

    public String getDefOSType() {
        return "Windows";
    }

    public String getOptOSType() {
        return this.oSType;
    }

    public void setOptOSType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.oSType = value;
    }

    public Integer getDefScanType() {
        return GEPT_RISK;
    }

    public Integer getOptScanType() {
        return this.scanType;
    }

    public String getOptScanTypeValue() throws ValidationException {
        if (this.scanType == null) {
            return null;
        }
        String s = null;
        switch (this.scanType) {
            case 0: {
                s = "GEPT_RISK";
                break;
            }
            case 1: {
                s = "GEPT_HPP";
                break;
            }
            case 2: {
                s = "ALL";
                break;
            }
            case 3: {
                s = "GEPT_ADC";
                break;
            }
            default: {
                throw new ValidationException("DirectoryOverride/ScanType: invalid attribute value:" + this.scanType + "!");
            }
        }
        return s;
    }

    public void setOptScanType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanType = value;
    }

    public void setOptScanTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanType = null;
            return;
        }
        if ("GEPT_RISK".equals(value)) {
            this.scanType = GEPT_RISK;
        } else if ("GEPT_HPP".equals(value)) {
            this.scanType = GEPT_HPP;
        } else if ("ALL".equals(value)) {
            this.scanType = ALL;
        } else if ("GEPT_ADC".equals(value)) {
            this.scanType = GEPT_ADC;
        } else {
            throw new ValidationException("DirectoryOverride/ScanType: invalid attribute value:" + value + "!");
        }
    }

    public void addExtension(Extension value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addExtension(int index, Extension value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Extension> getExtension() {
        Vector<Extension> v = new Vector<Extension>();
        for (Transportable child : (ChildGroup)this.children.get(607)) {
            v.add((Extension)child);
        }
        return v;
    }

    public int getExtensionCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(607);
        return childGroup.size();
    }

    public Extension getExtension(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(607);
        return (Extension)childGroup.get(index);
    }

    public void setExtension(int index, Extension value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeExtension(Extension value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 687;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.prefixVariable == null) {
            throw new ValidationException("DirectoryOverride/PrefixVariable: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof Extension) {
            try {
                this.addExtension((Extension)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("PrefixVariable");
            if (value == null) {
                throw new ValidationException("DirectoryOverride/PrefixVariable: attribute is required!");
            }
            this.prefixVariable = value;
            value = attris.getValue("DirectoryPath");
            if (value != null) {
                this.directoryPath = value;
            }
            if ((value = attris.getValue("ExcludeSubDirectories")) != null) {
                this.excludeSubDirectories = "1".equals(value);
            }
            if ((value = attris.getValue("OSType")) != null) {
                this.oSType = value;
            }
            if ((value = attris.getValue("ScanType")) != null) {
                this.setOptScanTypeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getExtensionCount();
        for (i = 0; i < objCnt; ++i) {
            this.getExtension(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DirectoryOverride".equals(element.getNodeName())) {
            throw new ValidationException("DirectoryOverride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "PrefixVariable");
        if (value == null) {
            throw new ValidationException("DirectoryOverride/PrefixVariable: attribute is required!");
        }
        this.prefixVariable = value;
        value = XMLHelper.getAttribute(element, "DirectoryPath");
        if (value != null) {
            this.directoryPath = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ExcludeSubDirectories")) != null) {
            this.excludeSubDirectories = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "OSType")) != null) {
            this.oSType = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ScanType")) != null) {
            this.setOptScanTypeValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "Extension");
        for (int i = 0; i < v.size(); ++i) {
            Extension extensionObj = new Extension();
            extensionObj.importFromElement(v.get(i));
            this.addExtension(extensionObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DirectoryOverride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DirectoryOverride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DirectoryOverride");
        if (this.prefixVariable != null) {
            element.setAttribute("PrefixVariable", this.prefixVariable);
        }
        if (this.directoryPath != null) {
            element.setAttribute("DirectoryPath", this.directoryPath);
        }
        if (this.excludeSubDirectories != null) {
            element.setAttribute("ExcludeSubDirectories", this.excludeSubDirectories != false ? "1" : "0");
        }
        if (this.oSType != null) {
            element.setAttribute("OSType", this.oSType);
        }
        if (this.scanType != null) {
            element.setAttribute("ScanType", this.getOptScanTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DirectoryOverride ");
            if (this.prefixVariable != null) {
                strAttrs.append("PrefixVariable=\"").append(AbstractSchema.checkXMLContent(this.prefixVariable)).append("\" ");
            }
            if (this.directoryPath != null) {
                strAttrs.append("DirectoryPath=\"").append(AbstractSchema.checkXMLContent(this.directoryPath)).append("\" ");
            }
            if (this.excludeSubDirectories != null) {
                strAttrs.append("ExcludeSubDirectories=").append(this.excludeSubDirectories != false ? "\"1\" " : "\"0\" ");
            }
            if (this.oSType != null) {
                strAttrs.append("OSType=\"").append(AbstractSchema.checkXMLContent(this.oSType)).append("\" ");
            }
            if (this.scanType != null) {
                strAttrs.append("ScanType=\"").append(this.getOptScanTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DirectoryOverride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

