/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DhcpAuthParameter
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer authPort;
    private Integer authPacket;
    private Integer packetInterval;
    private Integer authenticationTimeout;
    private Integer dhcpMessageTimeout;

    public DhcpAuthParameter() {
        this(true);
    }

    public DhcpAuthParameter(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "DhcpAuthParameter";
    }

    public Integer getDefAuthPort() {
        return 39999;
    }

    public Integer getOptAuthPort() {
        return this.authPort;
    }

    public void setOptAuthPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authPort = value;
    }

    public Integer getDefAuthPacket() {
        return 15;
    }

    public Integer getOptAuthPacket() {
        return this.authPacket;
    }

    public void setOptAuthPacket(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authPacket = value;
    }

    public Integer getDefPacketInterval() {
        return 4;
    }

    public Integer getOptPacketInterval() {
        return this.packetInterval;
    }

    public void setOptPacketInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packetInterval = value;
    }

    public Integer getDefAuthenticationTimeout() {
        return 3;
    }

    public Integer getOptAuthenticationTimeout() {
        return this.authenticationTimeout;
    }

    public void setOptAuthenticationTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authenticationTimeout = value;
    }

    public Integer getDefDhcpMessageTimeout() {
        return 10;
    }

    public Integer getOptDhcpMessageTimeout() {
        return this.dhcpMessageTimeout;
    }

    public void setOptDhcpMessageTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dhcpMessageTimeout = value;
    }

    @Override
    public int getObjectType() {
        return 555;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AuthPort");
            if (value != null) {
                try {
                    this.authPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DhcpAuthParameter/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DhcpAuthParameter/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("AuthPacket")) != null) {
                try {
                    this.authPacket = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DhcpAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DhcpAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("PacketInterval")) != null) {
                try {
                    this.packetInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DhcpAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DhcpAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("AuthenticationTimeout")) != null) {
                try {
                    this.authenticationTimeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DhcpAuthParameter/AuthenticationTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DhcpAuthParameter/AuthenticationTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DhcpMessageTimeout")) != null) {
                try {
                    this.dhcpMessageTimeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DhcpAuthParameter/DhcpMessageTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DhcpAuthParameter/DhcpMessageTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DhcpAuthParameter".equals(element.getNodeName())) {
            throw new ValidationException("DhcpAuthParameter: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AuthPort");
        if (value != null) {
            try {
                this.authPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DhcpAuthParameter/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AuthPacket")) != null) {
            try {
                this.authPacket = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DhcpAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PacketInterval")) != null) {
            try {
                this.packetInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DhcpAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AuthenticationTimeout")) != null) {
            try {
                this.authenticationTimeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DhcpAuthParameter/AuthenticationTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DhcpMessageTimeout")) != null) {
            try {
                this.dhcpMessageTimeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DhcpAuthParameter/DhcpMessageTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DhcpAuthParameter/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DhcpAuthParameter/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DhcpAuthParameter");
        if (this.authPort != null) {
            element.setAttribute("AuthPort", this.authPort.toString());
        }
        if (this.authPacket != null) {
            element.setAttribute("AuthPacket", this.authPacket.toString());
        }
        if (this.packetInterval != null) {
            element.setAttribute("PacketInterval", this.packetInterval.toString());
        }
        if (this.authenticationTimeout != null) {
            element.setAttribute("AuthenticationTimeout", this.authenticationTimeout.toString());
        }
        if (this.dhcpMessageTimeout != null) {
            element.setAttribute("DhcpMessageTimeout", this.dhcpMessageTimeout.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DhcpAuthParameter ");
            if (this.authPort != null) {
                strAttrs.append("AuthPort=\"").append(this.authPort.toString()).append("\" ");
            }
            if (this.authPacket != null) {
                strAttrs.append("AuthPacket=\"").append(this.authPacket.toString()).append("\" ");
            }
            if (this.packetInterval != null) {
                strAttrs.append("PacketInterval=\"").append(this.packetInterval.toString()).append("\" ");
            }
            if (this.authenticationTimeout != null) {
                strAttrs.append("AuthenticationTimeout=\"").append(this.authenticationTimeout.toString()).append("\" ");
            }
            if (this.dhcpMessageTimeout != null) {
                strAttrs.append("DhcpMessageTimeout=\"").append(this.dhcpMessageTimeout.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DhcpAuthParameter>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

