/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DetectedProcesses
extends ConfigObject {
    public static final Integer WINDOWS = 0;
    public static final Integer MAC = 1;
    public static final Integer LINUX = 2;
    private static final long serialVersionUID = 1L;
    private String checksum;
    private String altChecksum;
    private String processName;
    private String path;
    private String company;
    private Long fileSize;
    private Integer oS;

    public DetectedProcesses() {
        this(true);
    }

    public DetectedProcesses(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "DetectedProcesses";
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checksum = value;
    }

    public String getOptAltChecksum() {
        return this.altChecksum;
    }

    public void setOptAltChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.altChecksum = value;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.processName = value;
    }

    public String getOptPath() {
        return this.path;
    }

    public void setOptPath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.path = value;
    }

    public String getOptCompany() {
        return this.company;
    }

    public void setOptCompany(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.company = value;
    }

    public Long getOptFileSize() {
        return this.fileSize;
    }

    public void setOptFileSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileSize = value;
    }

    public Integer getDefOS() {
        return WINDOWS;
    }

    public Integer getOptOS() {
        return this.oS;
    }

    public String getOptOSValue() throws ValidationException {
        if (this.oS == null) {
            return null;
        }
        String s = null;
        switch (this.oS) {
            case 0: {
                s = "WINDOWS";
                break;
            }
            case 1: {
                s = "MAC";
                break;
            }
            case 2: {
                s = "LINUX";
                break;
            }
            default: {
                throw new ValidationException("DetectedProcesses/OS: invalid attribute value:" + this.oS + "!");
            }
        }
        return s;
    }

    public void setOptOS(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.oS = value;
    }

    public void setOptOSValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.oS = null;
            return;
        }
        if ("WINDOWS".equals(value)) {
            this.oS = WINDOWS;
        } else if ("MAC".equals(value)) {
            this.oS = MAC;
        } else if ("LINUX".equals(value)) {
            this.oS = LINUX;
        } else {
            throw new ValidationException("DetectedProcesses/OS: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 689;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.checksum == null) {
            throw new ValidationException("DetectedProcesses/Checksum: attribute is required!");
        }
        if (this.processName == null) {
            throw new ValidationException("DetectedProcesses/ProcessName: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Checksum");
            if (value == null) {
                throw new ValidationException("DetectedProcesses/Checksum: attribute is required!");
            }
            this.checksum = value;
            value = attris.getValue("AltChecksum");
            if (value != null) {
                this.altChecksum = value;
            }
            if ((value = attris.getValue("ProcessName")) == null) {
                throw new ValidationException("DetectedProcesses/ProcessName: attribute is required!");
            }
            this.processName = value;
            value = attris.getValue("Path");
            if (value != null) {
                this.path = value;
            }
            if ((value = attris.getValue("Company")) != null) {
                this.company = value;
            }
            if ((value = attris.getValue("FileSize")) != null) {
                try {
                    this.fileSize = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("DetectedProcesses/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("DetectedProcesses/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("OS")) != null) {
                this.setOptOSValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DetectedProcesses".equals(element.getNodeName())) {
            throw new ValidationException("DetectedProcesses: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Checksum");
        if (value == null) {
            throw new ValidationException("DetectedProcesses/Checksum: attribute is required!");
        }
        this.checksum = value;
        value = XMLHelper.getAttribute(element, "AltChecksum");
        if (value != null) {
            this.altChecksum = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ProcessName")) == null) {
            throw new ValidationException("DetectedProcesses/ProcessName: attribute is required!");
        }
        this.processName = value;
        value = XMLHelper.getAttribute(element, "Path");
        if (value != null) {
            this.path = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Company")) != null) {
            this.company = value;
        }
        if ((value = XMLHelper.getAttribute(element, "FileSize")) != null) {
            try {
                this.fileSize = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("DetectedProcesses/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "OS")) != null) {
            this.setOptOSValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DetectedProcesses/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DetectedProcesses/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DetectedProcesses");
        if (this.checksum != null) {
            element.setAttribute("Checksum", this.checksum);
        }
        if (this.altChecksum != null) {
            element.setAttribute("AltChecksum", this.altChecksum);
        }
        if (this.processName != null) {
            element.setAttribute("ProcessName", this.processName);
        }
        if (this.path != null) {
            element.setAttribute("Path", this.path);
        }
        if (this.company != null) {
            element.setAttribute("Company", this.company);
        }
        if (this.fileSize != null) {
            element.setAttribute("FileSize", this.fileSize.toString());
        }
        if (this.oS != null) {
            element.setAttribute("OS", this.getOptOSValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DetectedProcesses ");
            if (this.checksum != null) {
                strAttrs.append("Checksum=\"").append(AbstractSchema.checkXMLContent(this.checksum)).append("\" ");
            }
            if (this.altChecksum != null) {
                strAttrs.append("AltChecksum=\"").append(AbstractSchema.checkXMLContent(this.altChecksum)).append("\" ");
            }
            if (this.processName != null) {
                strAttrs.append("ProcessName=\"").append(AbstractSchema.checkXMLContent(this.processName)).append("\" ");
            }
            if (this.path != null) {
                strAttrs.append("Path=\"").append(AbstractSchema.checkXMLContent(this.path)).append("\" ");
            }
            if (this.company != null) {
                strAttrs.append("Company=\"").append(AbstractSchema.checkXMLContent(this.company)).append("\" ");
            }
            if (this.fileSize != null) {
                strAttrs.append("FileSize=\"").append(this.fileSize.toString()).append("\" ");
            }
            if (this.oS != null) {
                strAttrs.append("OS=\"").append(this.getOptOSValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DetectedProcesses>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

