/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CompressParams;
import com.sygate.scm.common.configobject.schema.DecompressParams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeltaParams
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String type;

    public DeltaParams() {
        this(true);
    }

    public DeltaParams(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(765, new ChildGroup(1, 1));
        this.children.put(766, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "DeltaParams";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    public CompressParams getCompressParams() {
        ChildGroup childGroup = (ChildGroup)this.children.get(765);
        if (childGroup.size() > 0) {
            return (CompressParams)childGroup.get(0);
        }
        return null;
    }

    public void setCompressParams(CompressParams value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CompressParams obj = this.getCompressParams();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DecompressParams getDecompressParams() {
        ChildGroup childGroup = (ChildGroup)this.children.get(766);
        if (childGroup.size() > 0) {
            return (DecompressParams)childGroup.get(0);
        }
        return null;
    }

    public void setDecompressParams(DecompressParams value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DecompressParams obj = this.getDecompressParams();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 764;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.type == null) {
            throw new ValidationException("DeltaParams/Type: attribute is required!");
        }
        if (this.getCompressParams() == null) {
            throw new ValidationException("DeltaParams/CompressParams: attribute is required!");
        }
        if (this.getDecompressParams() == null) {
            throw new ValidationException("DeltaParams/DecompressParams: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof CompressParams) {
            try {
                this.setCompressParams((CompressParams)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DecompressParams) {
            try {
                this.setDecompressParams((DecompressParams)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Type");
            if (value == null) {
                throw new ValidationException("DeltaParams/Type: attribute is required!");
            }
            this.type = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getCompressParams() != null) {
            this.getCompressParams().setReadonly();
        }
        if (this.getDecompressParams() != null) {
            this.getDecompressParams().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(765)).size();
        }
        catch (Throwable t) {
            throw new SAXException("DeltaParams: can't import element == CompressParams!");
        }
        try {
            ((ChildGroup)this.children.get(766)).size();
        }
        catch (Throwable t) {
            throw new SAXException("DeltaParams: can't import element == DecompressParams!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DeltaParams".equals(element.getNodeName())) {
            throw new ValidationException("DeltaParams: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Type");
        if (value == null) {
            throw new ValidationException("DeltaParams/Type: attribute is required!");
        }
        this.type = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "CompressParams");
        if (v.size() != 1) {
            throw new ValidationException("DeltaParams/CompressParams: element is require!");
        }
        CompressParams compressParamsObj = new CompressParams();
        compressParamsObj.importFromElement(v.get(0));
        this.setCompressParams(compressParamsObj);
        v = XMLHelper.getChildElementByName(element, "DecompressParams");
        if (v.size() != 1) {
            throw new ValidationException("DeltaParams/DecompressParams: element is require!");
        }
        DecompressParams decompressParamsObj = new DecompressParams();
        decompressParamsObj.importFromElement(v.get(0));
        this.setDecompressParams(decompressParamsObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DeltaParams/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DeltaParams/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DeltaParams");
        if (this.type != null) {
            element.setAttribute("Type", this.type);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DeltaParams ");
            if (this.type != null) {
                strAttrs.append("Type=\"").append(AbstractSchema.checkXMLContent(this.type)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DeltaParams>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

