/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.IpAddress;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DatabaseState
extends TopLevelObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String ownerId;
    private String databaseProductName;
    private String databaseProductVersion;

    public DatabaseState() {
        this(true);
    }

    public DatabaseState(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(52, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "DatabaseState";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.ownerId = value;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseProductName = value;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseProductVersion = value;
    }

    public void addIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IpAddress> getIpAddress() {
        Vector<IpAddress> v = new Vector<IpAddress>();
        for (Transportable child : (ChildGroup)this.children.get(52)) {
            v.add((IpAddress)child);
        }
        return v;
    }

    public int getIpAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return childGroup.size();
    }

    public IpAddress getIpAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return (IpAddress)childGroup.get(index);
    }

    public void setIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpAddress(IpAddress value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 200;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("DatabaseState/Id: attribute is required!");
        }
        if (this.ownerId == null) {
            throw new ValidationException("DatabaseState/OwnerId: attribute is required!");
        }
        if (this.databaseProductName == null) {
            throw new ValidationException("DatabaseState/DatabaseProductName: attribute is required!");
        }
        if (this.databaseProductVersion == null) {
            throw new ValidationException("DatabaseState/DatabaseProductVersion: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.addIpAddress((IpAddress)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("DatabaseState/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("OwnerId");
            if (value == null) {
                throw new ValidationException("DatabaseState/OwnerId: attribute is required!");
            }
            this.ownerId = value;
            value = attris.getValue("DatabaseProductName");
            if (value == null) {
                throw new ValidationException("DatabaseState/DatabaseProductName: attribute is required!");
            }
            this.databaseProductName = value;
            value = attris.getValue("DatabaseProductVersion");
            if (value == null) {
                throw new ValidationException("DatabaseState/DatabaseProductVersion: attribute is required!");
            }
            this.databaseProductVersion = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getIpAddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpAddress(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DatabaseState".equals(element.getNodeName())) {
            throw new ValidationException("DatabaseState: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("DatabaseState/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "OwnerId");
        if (value == null) {
            throw new ValidationException("DatabaseState/OwnerId: attribute is required!");
        }
        this.ownerId = value;
        value = XMLHelper.getAttribute(element, "DatabaseProductName");
        if (value == null) {
            throw new ValidationException("DatabaseState/DatabaseProductName: attribute is required!");
        }
        this.databaseProductName = value;
        value = XMLHelper.getAttribute(element, "DatabaseProductVersion");
        if (value == null) {
            throw new ValidationException("DatabaseState/DatabaseProductVersion: attribute is required!");
        }
        this.databaseProductVersion = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IpAddress");
        for (int i = 0; i < v.size(); ++i) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(i));
            this.addIpAddress(ipAddressObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("DatabaseState/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("DatabaseState/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("DatabaseState");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.ownerId != null) {
            element.setAttribute("OwnerId", this.ownerId);
        }
        if (this.databaseProductName != null) {
            element.setAttribute("DatabaseProductName", this.databaseProductName);
        }
        if (this.databaseProductVersion != null) {
            element.setAttribute("DatabaseProductVersion", this.databaseProductVersion);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DatabaseState ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.ownerId != null) {
                strAttrs.append("OwnerId=\"").append(AbstractSchema.checkXMLContent(this.ownerId)).append("\" ");
            }
            if (this.databaseProductName != null) {
                strAttrs.append("DatabaseProductName=\"").append(AbstractSchema.checkXMLContent(this.databaseProductName)).append("\" ");
            }
            if (this.databaseProductVersion != null) {
                strAttrs.append("DatabaseProductVersion=\"").append(AbstractSchema.checkXMLContent(this.databaseProductVersion)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DatabaseState>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

