/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Database
extends ConfigObject
implements NamedObject {
    public static final Integer DATABASE_AUTHENTICATION = 0;
    public static final Integer WINDOWS_AUTHENTICATION = 1;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private String serverAddress;
    private String databaseProductName;
    private String databaseProductVersion;
    private String databaseInstanceId;
    private String dBOperatorUserName;
    private String dBOperatorPassword = "";
    private Integer databaseInstancePort;
    private Boolean databaseInstanceEmbedded;
    private Integer dBAuthenticationType;
    private Long creationTime;

    public Database() {
        this(true);
    }

    public Database(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "Database";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverAddress = value;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseProductName = value;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseProductVersion = value;
    }

    public String getDatabaseInstanceId() {
        return this.databaseInstanceId;
    }

    public void setDatabaseInstanceId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseInstanceId = value;
    }

    public String getDBOperatorUserName() {
        return this.dBOperatorUserName;
    }

    public void setDBOperatorUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dBOperatorUserName = value;
    }

    public String getDBOperatorPassword() {
        try {
            return Utility.decrypt("");
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setDBOperatorPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.dBOperatorPassword = Utility.encrypt("");
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Integer getOptDatabaseInstancePort() {
        return this.databaseInstancePort;
    }

    public void setOptDatabaseInstancePort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseInstancePort = value;
    }

    public Boolean getOptDatabaseInstanceEmbedded() {
        return this.databaseInstanceEmbedded;
    }

    public void setOptDatabaseInstanceEmbedded(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseInstanceEmbedded = value;
    }

    public Integer getDefDBAuthenticationType() {
        return DATABASE_AUTHENTICATION;
    }

    public Integer getOptDBAuthenticationType() {
        return this.dBAuthenticationType;
    }

    public String getOptDBAuthenticationTypeValue() throws ValidationException {
        if (this.dBAuthenticationType == null) {
            return null;
        }
        String s = null;
        switch (this.dBAuthenticationType) {
            case 0: {
                s = "DATABASE_AUTHENTICATION";
                break;
            }
            case 1: {
                s = "WINDOWS_AUTHENTICATION";
                break;
            }
            default: {
                throw new ValidationException("Database/DBAuthenticationType: invalid attribute value:" + this.dBAuthenticationType + "!");
            }
        }
        return s;
    }

    public void setOptDBAuthenticationType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dBAuthenticationType = value;
    }

    public void setOptDBAuthenticationTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.dBAuthenticationType = null;
            return;
        }
        if ("DATABASE_AUTHENTICATION".equals(value)) {
            this.dBAuthenticationType = DATABASE_AUTHENTICATION;
        } else if ("WINDOWS_AUTHENTICATION".equals(value)) {
            this.dBAuthenticationType = WINDOWS_AUTHENTICATION;
        } else {
            throw new ValidationException("Database/DBAuthenticationType: invalid attribute value:" + value + "!");
        }
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    @Override
    public int getObjectType() {
        return 66;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("Database/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("Database/Name: attribute is required!");
        }
        if (this.serverAddress == null) {
            throw new ValidationException("Database/ServerAddress: attribute is required!");
        }
        if (this.databaseProductName == null) {
            throw new ValidationException("Database/DatabaseProductName: attribute is required!");
        }
        if (this.databaseProductVersion == null) {
            throw new ValidationException("Database/DatabaseProductVersion: attribute is required!");
        }
        if (this.databaseInstanceId == null) {
            throw new ValidationException("Database/DatabaseInstanceId: attribute is required!");
        }
        if (this.dBOperatorUserName == null) {
            throw new ValidationException("Database/DBOperatorUserName: attribute is required!");
        }
        if (this.dBOperatorPassword == null) {
            throw new ValidationException("Database/DBOperatorPassword: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("Database/CreationTime: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("Database/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("Database/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("ServerAddress")) == null) {
                throw new ValidationException("Database/ServerAddress: attribute is required!");
            }
            this.serverAddress = value;
            value = attris.getValue("DatabaseProductName");
            if (value == null) {
                throw new ValidationException("Database/DatabaseProductName: attribute is required!");
            }
            this.databaseProductName = value;
            value = attris.getValue("DatabaseProductVersion");
            if (value == null) {
                throw new ValidationException("Database/DatabaseProductVersion: attribute is required!");
            }
            this.databaseProductVersion = value;
            value = attris.getValue("DatabaseInstanceId");
            if (value == null) {
                throw new ValidationException("Database/DatabaseInstanceId: attribute is required!");
            }
            this.databaseInstanceId = value;
            value = attris.getValue("DBOperatorUserName");
            if (value == null) {
                throw new ValidationException("Database/DBOperatorUserName: attribute is required!");
            }
            this.dBOperatorUserName = value;
            this.dBOperatorPassword = value = "";
            value = attris.getValue("DatabaseInstancePort");
            if (value != null) {
                try {
                    this.databaseInstancePort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Database/DatabaseInstancePort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Database/DatabaseInstancePort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DatabaseInstanceEmbedded")) != null) {
                this.databaseInstanceEmbedded = "1".equals(value);
            }
            if ((value = attris.getValue("DBAuthenticationType")) != null) {
                this.setOptDBAuthenticationTypeValue(value);
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("Database/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("Database/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("Database/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Database".equals(element.getNodeName())) {
            throw new ValidationException("Database: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("Database/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("Database/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ServerAddress")) == null) {
            throw new ValidationException("Database/ServerAddress: attribute is required!");
        }
        this.serverAddress = value;
        value = XMLHelper.getAttribute(element, "DatabaseProductName");
        if (value == null) {
            throw new ValidationException("Database/DatabaseProductName: attribute is required!");
        }
        this.databaseProductName = value;
        value = XMLHelper.getAttribute(element, "DatabaseProductVersion");
        if (value == null) {
            throw new ValidationException("Database/DatabaseProductVersion: attribute is required!");
        }
        this.databaseProductVersion = value;
        value = XMLHelper.getAttribute(element, "DatabaseInstanceId");
        if (value == null) {
            throw new ValidationException("Database/DatabaseInstanceId: attribute is required!");
        }
        this.databaseInstanceId = value;
        value = XMLHelper.getAttribute(element, "DBOperatorUserName");
        if (value == null) {
            throw new ValidationException("Database/DBOperatorUserName: attribute is required!");
        }
        this.dBOperatorUserName = value;
        this.dBOperatorPassword = value = "";
        value = XMLHelper.getAttribute(element, "DatabaseInstancePort");
        if (value != null) {
            try {
                this.databaseInstancePort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Database/DatabaseInstancePort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DatabaseInstanceEmbedded")) != null) {
            this.databaseInstanceEmbedded = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DBAuthenticationType")) != null) {
            this.setOptDBAuthenticationTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("Database/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Database/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("Database/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Database/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Database/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Database");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.serverAddress != null) {
            element.setAttribute("ServerAddress", this.serverAddress);
        }
        if (this.databaseProductName != null) {
            element.setAttribute("DatabaseProductName", this.databaseProductName);
        }
        if (this.databaseProductVersion != null) {
            element.setAttribute("DatabaseProductVersion", this.databaseProductVersion);
        }
        if (this.databaseInstanceId != null) {
            element.setAttribute("DatabaseInstanceId", this.databaseInstanceId);
        }
        if (this.dBOperatorUserName != null) {
            element.setAttribute("DBOperatorUserName", this.dBOperatorUserName);
        }
        if (this.dBOperatorPassword != null) {
            element.setAttribute("DBOperatorPassword", "");
        }
        if (this.databaseInstancePort != null) {
            element.setAttribute("DatabaseInstancePort", this.databaseInstancePort.toString());
        }
        if (this.databaseInstanceEmbedded != null) {
            element.setAttribute("DatabaseInstanceEmbedded", this.databaseInstanceEmbedded != false ? "1" : "0");
        }
        if (this.dBAuthenticationType != null) {
            element.setAttribute("DBAuthenticationType", this.getOptDBAuthenticationTypeValue());
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Database ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.serverAddress != null) {
                strAttrs.append("ServerAddress=\"").append(AbstractSchema.checkXMLContent(this.serverAddress)).append("\" ");
            }
            if (this.databaseProductName != null) {
                strAttrs.append("DatabaseProductName=\"").append(AbstractSchema.checkXMLContent(this.databaseProductName)).append("\" ");
            }
            if (this.databaseProductVersion != null) {
                strAttrs.append("DatabaseProductVersion=\"").append(AbstractSchema.checkXMLContent(this.databaseProductVersion)).append("\" ");
            }
            if (this.databaseInstanceId != null) {
                strAttrs.append("DatabaseInstanceId=\"").append(AbstractSchema.checkXMLContent(this.databaseInstanceId)).append("\" ");
            }
            if (this.dBOperatorUserName != null) {
                strAttrs.append("DBOperatorUserName=\"").append(AbstractSchema.checkXMLContent(this.dBOperatorUserName)).append("\" ");
            }
            if (this.dBOperatorPassword != null) {
                strAttrs.append("DBOperatorPassword=\"").append(AbstractSchema.checkXMLContent("")).append("\" ");
            }
            if (this.databaseInstancePort != null) {
                strAttrs.append("DatabaseInstancePort=\"").append(this.databaseInstancePort.toString()).append("\" ");
            }
            if (this.databaseInstanceEmbedded != null) {
                strAttrs.append("DatabaseInstanceEmbedded=").append(this.databaseInstanceEmbedded != false ? "\"1\" " : "\"0\" ");
            }
            if (this.dBAuthenticationType != null) {
                strAttrs.append("DBAuthenticationType=\"").append(this.getOptDBAuthenticationTypeValue()).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Database>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

