/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContentAnalysisServer
extends ConfigObject {
    public static final Integer HTTP = 0;
    public static final Integer HTTPS = 1;
    private static final long serialVersionUID = 1L;
    private String username;
    private String password;
    private Boolean enable;
    private String address;
    private Integer port;
    private String token;
    private String expiration;
    private String key;
    private Boolean httpsVerifyCA;
    private Integer protocol;

    public ContentAnalysisServer() {
        this(true);
    }

    public ContentAnalysisServer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ContentAnalysisServer";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.username = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.password = value;
    }

    public Boolean getDefEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.address = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public String getOptToken() {
        return this.token;
    }

    public void setOptToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.token = value;
    }

    public String getOptExpiration() {
        return this.expiration;
    }

    public void setOptExpiration(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.expiration = value;
    }

    public String getOptKey() {
        return this.key;
    }

    public void setOptKey(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.key = value;
    }

    public Boolean getDefHttpsVerifyCA() {
        return Boolean.FALSE;
    }

    public Boolean getOptHttpsVerifyCA() {
        return this.httpsVerifyCA;
    }

    public void setOptHttpsVerifyCA(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.httpsVerifyCA = value;
    }

    public Integer getDefProtocol() {
        return HTTP;
    }

    public Integer getOptProtocol() {
        return this.protocol;
    }

    public String getOptProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "HTTP";
                break;
            }
            case 1: {
                s = "HTTPS";
                break;
            }
            default: {
                throw new ValidationException("ContentAnalysisServer/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setOptProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.protocol = value;
    }

    public void setOptProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protocol = null;
            return;
        }
        if ("HTTP".equals(value)) {
            this.protocol = HTTP;
        } else if ("HTTPS".equals(value)) {
            this.protocol = HTTPS;
        } else {
            throw new ValidationException("ContentAnalysisServer/Protocol: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 809;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.username == null) {
            throw new ValidationException("ContentAnalysisServer/Username: attribute is required!");
        }
        if (this.password == null) {
            throw new ValidationException("ContentAnalysisServer/Password: attribute is required!");
        }
        if (this.address == null) {
            throw new ValidationException("ContentAnalysisServer/Address: attribute is required!");
        }
        if (this.port == null) {
            throw new ValidationException("ContentAnalysisServer/Port: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Username");
            if (value == null) {
                throw new ValidationException("ContentAnalysisServer/Username: attribute is required!");
            }
            this.username = value;
            value = attris.getValue("Password");
            if (value == null) {
                throw new ValidationException("ContentAnalysisServer/Password: attribute is required!");
            }
            this.password = value;
            value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Address")) == null) {
                throw new ValidationException("ContentAnalysisServer/Address: attribute is required!");
            }
            this.address = value;
            value = attris.getValue("Port");
            if (value == null) {
                throw new ValidationException("ContentAnalysisServer/Port: attribute is required!");
            }
            try {
                this.port = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("ContentAnalysisServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("ContentAnalysisServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Token");
            if (value != null) {
                this.token = value;
            }
            if ((value = attris.getValue("Expiration")) != null) {
                this.expiration = value;
            }
            if ((value = attris.getValue("Key")) != null) {
                this.key = value;
            }
            if ((value = attris.getValue("HttpsVerifyCA")) != null) {
                this.httpsVerifyCA = "1".equals(value);
            }
            if ((value = attris.getValue("Protocol")) != null) {
                this.setOptProtocolValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ContentAnalysisServer".equals(element.getNodeName())) {
            throw new ValidationException("ContentAnalysisServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Username");
        if (value == null) {
            throw new ValidationException("ContentAnalysisServer/Username: attribute is required!");
        }
        this.username = value;
        value = XMLHelper.getAttribute(element, "Password");
        if (value == null) {
            throw new ValidationException("ContentAnalysisServer/Password: attribute is required!");
        }
        this.password = value;
        value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Address")) == null) {
            throw new ValidationException("ContentAnalysisServer/Address: attribute is required!");
        }
        this.address = value;
        value = XMLHelper.getAttribute(element, "Port");
        if (value == null) {
            throw new ValidationException("ContentAnalysisServer/Port: attribute is required!");
        }
        try {
            this.port = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("ContentAnalysisServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("ContentAnalysisServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Token");
        if (value != null) {
            this.token = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Expiration")) != null) {
            this.expiration = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Key")) != null) {
            this.key = value;
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsVerifyCA")) != null) {
            this.httpsVerifyCA = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Protocol")) != null) {
            this.setOptProtocolValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ContentAnalysisServer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ContentAnalysisServer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ContentAnalysisServer");
        if (this.username != null) {
            element.setAttribute("Username", this.username);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.address != null) {
            element.setAttribute("Address", this.address);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.token != null) {
            element.setAttribute("Token", this.token);
        }
        if (this.expiration != null) {
            element.setAttribute("Expiration", this.expiration);
        }
        if (this.key != null) {
            element.setAttribute("Key", this.key);
        }
        if (this.httpsVerifyCA != null) {
            element.setAttribute("HttpsVerifyCA", this.httpsVerifyCA != false ? "1" : "0");
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getOptProtocolValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ContentAnalysisServer ");
            if (this.username != null) {
                strAttrs.append("Username=\"").append(AbstractSchema.checkXMLContent(this.username)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.address != null) {
                strAttrs.append("Address=\"").append(AbstractSchema.checkXMLContent(this.address)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.token != null) {
                strAttrs.append("Token=\"").append(AbstractSchema.checkXMLContent(this.token)).append("\" ");
            }
            if (this.expiration != null) {
                strAttrs.append("Expiration=\"").append(AbstractSchema.checkXMLContent(this.expiration)).append("\" ");
            }
            if (this.key != null) {
                strAttrs.append("Key=\"").append(AbstractSchema.checkXMLContent(this.key)).append("\" ");
            }
            if (this.httpsVerifyCA != null) {
                strAttrs.append("HttpsVerifyCA=").append(this.httpsVerifyCA != false ? "\"1\" " : "\"0\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getOptProtocolValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ContentAnalysisServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

