/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ComputerLockdownNotification;
import com.sygate.scm.common.configobject.schema.LockdownSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ComputerLockdownProtection
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer TEST = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer mode;
    private Boolean blacklistEnabled;
    private Long testItemsLastModifiedTime;

    public ComputerLockdownProtection() {
        this(true);
    }

    public ComputerLockdownProtection(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(291, new ChildGroup(0, 1));
        this.children.put(292, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ComputerLockdownProtection";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefMode() {
        return TEST;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "TEST";
                break;
            }
            default: {
                throw new ValidationException("ComputerLockdownProtection/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.mode = NORMAL;
        } else if ("TEST".equals(value)) {
            this.mode = TEST;
        } else {
            throw new ValidationException("ComputerLockdownProtection/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefBlacklistEnabled() {
        return Boolean.FALSE;
    }

    public Boolean getOptBlacklistEnabled() {
        return this.blacklistEnabled;
    }

    public void setOptBlacklistEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.blacklistEnabled = value;
    }

    public Long getOptTestItemsLastModifiedTime() {
        return this.testItemsLastModifiedTime;
    }

    public void setOptTestItemsLastModifiedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.testItemsLastModifiedTime = value;
    }

    public ComputerLockdownNotification getOptComputerLockdownNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(291);
        if (childGroup.size() > 0) {
            return (ComputerLockdownNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptComputerLockdownNotification(ComputerLockdownNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ComputerLockdownNotification obj = this.getOptComputerLockdownNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LockdownSet getOptLockdownSet() {
        ChildGroup childGroup = (ChildGroup)this.children.get(292);
        if (childGroup.size() > 0) {
            return (LockdownSet)childGroup.get(0);
        }
        return null;
    }

    public void setOptLockdownSet(LockdownSet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LockdownSet obj = this.getOptLockdownSet();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 290;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ComputerLockdownNotification) {
            try {
                this.setOptComputerLockdownNotification((ComputerLockdownNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LockdownSet) {
            try {
                this.setOptLockdownSet((LockdownSet)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Mode")) != null) {
                this.setOptModeValue(value);
            }
            if ((value = attris.getValue("BlacklistEnabled")) != null) {
                this.blacklistEnabled = "1".equals(value);
            }
            if ((value = attris.getValue("TestItemsLastModifiedTime")) != null) {
                try {
                    this.testItemsLastModifiedTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ComputerLockdownProtection/TestItemsLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ComputerLockdownProtection/TestItemsLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptComputerLockdownNotification() != null) {
            this.getOptComputerLockdownNotification().setReadonly();
        }
        if (this.getOptLockdownSet() != null) {
            this.getOptLockdownSet().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ComputerLockdownProtection".equals(element.getNodeName())) {
            throw new ValidationException("ComputerLockdownProtection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) != null) {
            this.setOptModeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "BlacklistEnabled")) != null) {
            this.blacklistEnabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TestItemsLastModifiedTime")) != null) {
            try {
                this.testItemsLastModifiedTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ComputerLockdownProtection/TestItemsLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((v = XMLHelper.getChildElementByName(element, "ComputerLockdownNotification")).size() > 0) {
            ComputerLockdownNotification computerLockdownNotificationObj = new ComputerLockdownNotification();
            computerLockdownNotificationObj.importFromElement(v.get(0));
            this.setOptComputerLockdownNotification(computerLockdownNotificationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LockdownSet")).size() > 0) {
            LockdownSet lockdownSetObj = new LockdownSet();
            lockdownSetObj.importFromElement(v.get(0));
            this.setOptLockdownSet(lockdownSetObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ComputerLockdownProtection/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ComputerLockdownProtection/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ComputerLockdownProtection");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        if (this.blacklistEnabled != null) {
            element.setAttribute("BlacklistEnabled", this.blacklistEnabled != false ? "1" : "0");
        }
        if (this.testItemsLastModifiedTime != null) {
            element.setAttribute("TestItemsLastModifiedTime", this.testItemsLastModifiedTime.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ComputerLockdownProtection ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.blacklistEnabled != null) {
                strAttrs.append("BlacklistEnabled=").append(this.blacklistEnabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.testItemsLastModifiedTime != null) {
                strAttrs.append("TestItemsLastModifiedTime=\"").append(this.testItemsLastModifiedTime.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ComputerLockdownProtection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

