/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AppUpload;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Communication
extends ConfigObject {
    public static final Integer PULL = 0;
    public static final Integer PUSH = 1;
    public static final Integer MINUTES = 0;
    public static final Integer HOURS = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer mode;
    private Long pollModeHeartbeatFreq;
    private Long pushModeKeepAliveHeartbeatFreq;
    private Long pushModeMaxConnectionTime;
    private Long uploadLogHeartbeatFreq;
    private Long uploadOpStateHeartbeatFreq;
    private Long uploadCmdStateHeartbeatFreq;
    private Boolean downloadProfile;
    private Integer randomizationFrequency;
    private Integer randomizationRange;
    private Boolean randomizationEnabled;
    private Boolean rememberCurrentGroup;
    private Boolean rememberCurrentPolicyMode;
    private Boolean allowClientUploadCriticalEventImmediately;

    public Communication() {
        this(true);
    }

    public Communication(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(299, new ChildGroup(0, 1));
        this.children.put(3, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "Communication";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "PULL";
                break;
            }
            case 1: {
                s = "PUSH";
                break;
            }
            default: {
                throw new ValidationException("Communication/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("PULL".equals(value)) {
            this.mode = PULL;
        } else if ("PUSH".equals(value)) {
            this.mode = PUSH;
        } else {
            throw new ValidationException("Communication/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Long getOptPollModeHeartbeatFreq() {
        return this.pollModeHeartbeatFreq;
    }

    public void setOptPollModeHeartbeatFreq(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pollModeHeartbeatFreq = value;
    }

    public Long getOptPushModeKeepAliveHeartbeatFreq() {
        return this.pushModeKeepAliveHeartbeatFreq;
    }

    public void setOptPushModeKeepAliveHeartbeatFreq(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pushModeKeepAliveHeartbeatFreq = value;
    }

    public Long getOptPushModeMaxConnectionTime() {
        return this.pushModeMaxConnectionTime;
    }

    public void setOptPushModeMaxConnectionTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pushModeMaxConnectionTime = value;
    }

    public Long getOptUploadLogHeartbeatFreq() {
        return this.uploadLogHeartbeatFreq;
    }

    public void setOptUploadLogHeartbeatFreq(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.uploadLogHeartbeatFreq = value;
    }

    public Long getOptUploadOpStateHeartbeatFreq() {
        return this.uploadOpStateHeartbeatFreq;
    }

    public void setOptUploadOpStateHeartbeatFreq(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.uploadOpStateHeartbeatFreq = value;
    }

    public Long getOptUploadCmdStateHeartbeatFreq() {
        return this.uploadCmdStateHeartbeatFreq;
    }

    public void setOptUploadCmdStateHeartbeatFreq(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.uploadCmdStateHeartbeatFreq = value;
    }

    public Boolean getDefDownloadProfile() {
        return Boolean.TRUE;
    }

    public Boolean getOptDownloadProfile() {
        return this.downloadProfile;
    }

    public void setOptDownloadProfile(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.downloadProfile = value;
    }

    public Integer getDefRandomizationFrequency() {
        return MINUTES;
    }

    public Integer getOptRandomizationFrequency() {
        return this.randomizationFrequency;
    }

    public String getOptRandomizationFrequencyValue() throws ValidationException {
        if (this.randomizationFrequency == null) {
            return null;
        }
        String s = null;
        switch (this.randomizationFrequency) {
            case 0: {
                s = "MINUTES";
                break;
            }
            case 1: {
                s = "HOURS";
                break;
            }
            default: {
                throw new ValidationException("Communication/RandomizationFrequency: invalid attribute value:" + this.randomizationFrequency + "!");
            }
        }
        return s;
    }

    public void setOptRandomizationFrequency(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomizationFrequency = value;
    }

    public void setOptRandomizationFrequencyValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.randomizationFrequency = null;
            return;
        }
        if ("MINUTES".equals(value)) {
            this.randomizationFrequency = MINUTES;
        } else if ("HOURS".equals(value)) {
            this.randomizationFrequency = HOURS;
        } else {
            throw new ValidationException("Communication/RandomizationFrequency: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRandomizationRange() {
        return 300;
    }

    public Integer getOptRandomizationRange() {
        return this.randomizationRange;
    }

    public void setOptRandomizationRange(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomizationRange = value;
    }

    public Boolean getDefRandomizationEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptRandomizationEnabled() {
        return this.randomizationEnabled;
    }

    public void setOptRandomizationEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomizationEnabled = value;
    }

    public Boolean getDefRememberCurrentGroup() {
        return Boolean.TRUE;
    }

    public Boolean getOptRememberCurrentGroup() {
        return this.rememberCurrentGroup;
    }

    public void setOptRememberCurrentGroup(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rememberCurrentGroup = value;
    }

    public Boolean getDefRememberCurrentPolicyMode() {
        return Boolean.TRUE;
    }

    public Boolean getOptRememberCurrentPolicyMode() {
        return this.rememberCurrentPolicyMode;
    }

    public void setOptRememberCurrentPolicyMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rememberCurrentPolicyMode = value;
    }

    public Boolean getDefAllowClientUploadCriticalEventImmediately() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowClientUploadCriticalEventImmediately() {
        return this.allowClientUploadCriticalEventImmediately;
    }

    public void setOptAllowClientUploadCriticalEventImmediately(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowClientUploadCriticalEventImmediately = value;
    }

    public AppUpload getOptAppUpload() {
        ChildGroup childGroup = (ChildGroup)this.children.get(299);
        if (childGroup.size() > 0) {
            return (AppUpload)childGroup.get(0);
        }
        return null;
    }

    public void setOptAppUpload(AppUpload value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AppUpload obj = this.getOptAppUpload();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 287;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.mode == null) {
            throw new ValidationException("Communication/Mode: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("Communication/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AppUpload) {
            try {
                this.setOptAppUpload((AppUpload)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Mode")) == null) {
                throw new ValidationException("Communication/Mode: attribute is required!");
            }
            this.setModeValue(value);
            value = attris.getValue("PollModeHeartbeatFreq");
            if (value != null) {
                try {
                    this.pollModeHeartbeatFreq = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/PollModeHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/PollModeHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("PushModeKeepAliveHeartbeatFreq")) != null) {
                try {
                    this.pushModeKeepAliveHeartbeatFreq = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/PushModeKeepAliveHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/PushModeKeepAliveHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("PushModeMaxConnectionTime")) != null) {
                try {
                    this.pushModeMaxConnectionTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/PushModeMaxConnectionTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/PushModeMaxConnectionTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("UploadLogHeartbeatFreq")) != null) {
                try {
                    this.uploadLogHeartbeatFreq = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/UploadLogHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/UploadLogHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("UploadOpStateHeartbeatFreq")) != null) {
                try {
                    this.uploadOpStateHeartbeatFreq = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/UploadOpStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/UploadOpStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("UploadCmdStateHeartbeatFreq")) != null) {
                try {
                    this.uploadCmdStateHeartbeatFreq = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/UploadCmdStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/UploadCmdStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DownloadProfile")) != null) {
                this.downloadProfile = "1".equals(value);
            }
            if ((value = attris.getValue("RandomizationFrequency")) != null) {
                this.setOptRandomizationFrequencyValue(value);
            }
            if ((value = attris.getValue("RandomizationRange")) != null) {
                try {
                    this.randomizationRange = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Communication/RandomizationRange: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Communication/RandomizationRange: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RandomizationEnabled")) != null) {
                this.randomizationEnabled = "1".equals(value);
            }
            if ((value = attris.getValue("RememberCurrentGroup")) != null) {
                this.rememberCurrentGroup = "1".equals(value);
            }
            if ((value = attris.getValue("RememberCurrentPolicyMode")) != null) {
                this.rememberCurrentPolicyMode = "1".equals(value);
            }
            if ((value = attris.getValue("AllowClientUploadCriticalEventImmediately")) != null) {
                this.allowClientUploadCriticalEventImmediately = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptAppUpload() != null) {
            this.getOptAppUpload().setReadonly();
        }
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("Communication: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"Communication".equals(element.getNodeName())) {
            throw new ValidationException("Communication: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) == null) {
            throw new ValidationException("Communication/Mode: attribute is required!");
        }
        this.setModeValue(value);
        value = XMLHelper.getAttribute(element, "PollModeHeartbeatFreq");
        if (value != null) {
            try {
                this.pollModeHeartbeatFreq = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/PollModeHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PushModeKeepAliveHeartbeatFreq")) != null) {
            try {
                this.pushModeKeepAliveHeartbeatFreq = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/PushModeKeepAliveHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PushModeMaxConnectionTime")) != null) {
            try {
                this.pushModeMaxConnectionTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/PushModeMaxConnectionTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "UploadLogHeartbeatFreq")) != null) {
            try {
                this.uploadLogHeartbeatFreq = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/UploadLogHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "UploadOpStateHeartbeatFreq")) != null) {
            try {
                this.uploadOpStateHeartbeatFreq = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/UploadOpStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "UploadCmdStateHeartbeatFreq")) != null) {
            try {
                this.uploadCmdStateHeartbeatFreq = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/UploadCmdStateHeartbeatFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DownloadProfile")) != null) {
            this.downloadProfile = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RandomizationFrequency")) != null) {
            this.setOptRandomizationFrequencyValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RandomizationRange")) != null) {
            try {
                this.randomizationRange = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Communication/RandomizationRange: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RandomizationEnabled")) != null) {
            this.randomizationEnabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RememberCurrentGroup")) != null) {
            this.rememberCurrentGroup = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RememberCurrentPolicyMode")) != null) {
            this.rememberCurrentPolicyMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowClientUploadCriticalEventImmediately")) != null) {
            this.allowClientUploadCriticalEventImmediately = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AppUpload")).size() > 0) {
            AppUpload appUploadObj = new AppUpload();
            appUploadObj.importFromElement(v.get(0));
            this.setOptAppUpload(appUploadObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("Communication/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Communication/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Communication/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Communication");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.getModeValue());
        }
        if (this.pollModeHeartbeatFreq != null) {
            element.setAttribute("PollModeHeartbeatFreq", this.pollModeHeartbeatFreq.toString());
        }
        if (this.pushModeKeepAliveHeartbeatFreq != null) {
            element.setAttribute("PushModeKeepAliveHeartbeatFreq", this.pushModeKeepAliveHeartbeatFreq.toString());
        }
        if (this.pushModeMaxConnectionTime != null) {
            element.setAttribute("PushModeMaxConnectionTime", this.pushModeMaxConnectionTime.toString());
        }
        if (this.uploadLogHeartbeatFreq != null) {
            element.setAttribute("UploadLogHeartbeatFreq", this.uploadLogHeartbeatFreq.toString());
        }
        if (this.uploadOpStateHeartbeatFreq != null) {
            element.setAttribute("UploadOpStateHeartbeatFreq", this.uploadOpStateHeartbeatFreq.toString());
        }
        if (this.uploadCmdStateHeartbeatFreq != null) {
            element.setAttribute("UploadCmdStateHeartbeatFreq", this.uploadCmdStateHeartbeatFreq.toString());
        }
        if (this.downloadProfile != null) {
            element.setAttribute("DownloadProfile", this.downloadProfile != false ? "1" : "0");
        }
        if (this.randomizationFrequency != null) {
            element.setAttribute("RandomizationFrequency", this.getOptRandomizationFrequencyValue());
        }
        if (this.randomizationRange != null) {
            element.setAttribute("RandomizationRange", this.randomizationRange.toString());
        }
        if (this.randomizationEnabled != null) {
            element.setAttribute("RandomizationEnabled", this.randomizationEnabled != false ? "1" : "0");
        }
        if (this.rememberCurrentGroup != null) {
            element.setAttribute("RememberCurrentGroup", this.rememberCurrentGroup != false ? "1" : "0");
        }
        if (this.rememberCurrentPolicyMode != null) {
            element.setAttribute("RememberCurrentPolicyMode", this.rememberCurrentPolicyMode != false ? "1" : "0");
        }
        if (this.allowClientUploadCriticalEventImmediately != null) {
            element.setAttribute("AllowClientUploadCriticalEventImmediately", this.allowClientUploadCriticalEventImmediately != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Communication ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getModeValue()).append("\" ");
            }
            if (this.pollModeHeartbeatFreq != null) {
                strAttrs.append("PollModeHeartbeatFreq=\"").append(this.pollModeHeartbeatFreq.toString()).append("\" ");
            }
            if (this.pushModeKeepAliveHeartbeatFreq != null) {
                strAttrs.append("PushModeKeepAliveHeartbeatFreq=\"").append(this.pushModeKeepAliveHeartbeatFreq.toString()).append("\" ");
            }
            if (this.pushModeMaxConnectionTime != null) {
                strAttrs.append("PushModeMaxConnectionTime=\"").append(this.pushModeMaxConnectionTime.toString()).append("\" ");
            }
            if (this.uploadLogHeartbeatFreq != null) {
                strAttrs.append("UploadLogHeartbeatFreq=\"").append(this.uploadLogHeartbeatFreq.toString()).append("\" ");
            }
            if (this.uploadOpStateHeartbeatFreq != null) {
                strAttrs.append("UploadOpStateHeartbeatFreq=\"").append(this.uploadOpStateHeartbeatFreq.toString()).append("\" ");
            }
            if (this.uploadCmdStateHeartbeatFreq != null) {
                strAttrs.append("UploadCmdStateHeartbeatFreq=\"").append(this.uploadCmdStateHeartbeatFreq.toString()).append("\" ");
            }
            if (this.downloadProfile != null) {
                strAttrs.append("DownloadProfile=").append(this.downloadProfile != false ? "\"1\" " : "\"0\" ");
            }
            if (this.randomizationFrequency != null) {
                strAttrs.append("RandomizationFrequency=\"").append(this.getOptRandomizationFrequencyValue()).append("\" ");
            }
            if (this.randomizationRange != null) {
                strAttrs.append("RandomizationRange=\"").append(this.randomizationRange.toString()).append("\" ");
            }
            if (this.randomizationEnabled != null) {
                strAttrs.append("RandomizationEnabled=").append(this.randomizationEnabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.rememberCurrentGroup != null) {
                strAttrs.append("RememberCurrentGroup=").append(this.rememberCurrentGroup != false ? "\"1\" " : "\"0\" ");
            }
            if (this.rememberCurrentPolicyMode != null) {
                strAttrs.append("RememberCurrentPolicyMode=").append(this.rememberCurrentPolicyMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowClientUploadCriticalEventImmediately != null) {
                strAttrs.append("AllowClientUploadCriticalEventImmediately=").append(this.allowClientUploadCriticalEventImmediately != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Communication>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

