/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CommandParameter
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private byte[] content;

    public CommandParameter() {
        this(true);
    }

    public CommandParameter(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "CommandParameter";
    }

    public byte[] getContent() {
        return this.content == null ? null : (byte[])this.content.clone();
    }

    public void setConent(byte[] content) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.content = content == null ? null : (byte[])content.clone();
    }

    @Override
    public int getObjectType() {
        return 2;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.content == null) {
            throw new ValidationException("CommandParameter: content is required!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"CommandParameter".equals(element.getNodeName())) {
            throw new ValidationException("CommandParameter: can't import element(" + element.getNodeName() + ")!");
        }
        Element child = XMLHelper.getFirstChildElement(element);
        if (child == null) {
            throw new ValidationException("CommandParameter: child element is required!");
        }
        try {
            Document doc = XMLHelper.newDocument();
            doc.appendChild(XMLHelper.cloneElement(doc, child));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLHelper.serialize(doc, bos, true);
            bos.close();
            this.content = bos.toByteArray();
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("CommandParameter/ObsoleteItem/DeletedI: attribute is require!");
            }
            this.addObsoleteItem(new ObsoleteItem(deletedI));
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("CommandParameter");
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.content);
            Document newDoc = XMLHelper.parse(bis);
            bis.close();
            Element root = newDoc.getDocumentElement();
            element.appendChild(XMLHelper.cloneElement(doc, root));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        catch (SAXException e) {
            throw new ValidationException("CommandParameter: invalid content!");
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void initByAttributes(Attributes attributes) throws SAXException {
        try {
            this.readElement(attributes);
        }
        catch (ValidationException ve) {
            throw new SAXException(ve);
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void putTextContent(String content) throws SAXException {
    }

    @Override
    public void doSerialize(OutputStream os) throws ValidationException {
        try {
            StringBuffer sb = new StringBuffer("<CommandParameter _d=\"");
            sb.append(this.getD()).append("\" _i=\"");
            sb.append(this.getI()).append("\" _t=\"");
            sb.append(this.getT()).append("\" _v=\"");
            sb.append(this.getV()).append("\">");
            os.write(sb.toString().getBytes("UTF-8"));
            if (this.content != null) {
                try {
                    AbstractSchema unknownSchema = AbstractSchema.readXML(this.content);
                    XMLHelper.serialize(os, unknownSchema, true);
                }
                catch (Exception ex) {
                    os.write(this.content);
                }
            }
            os.write("</CommandParameter>".getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Override
    public Object clone() {
        CommandParameter obj = (CommandParameter)super.clone();
        if (this.content != null) {
            obj.content = (byte[])this.content.clone();
        }
        return obj;
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CommandParameter) || !super.equals(obj)) {
            return false;
        }
        CommandParameter obj2 = (CommandParameter)obj;
        return Arrays.equals(this.content, obj2.content);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void readElement(String _ia, boolean _da, long _ta, long _va) {
        super.readElement(_ia, _da, _ta, _va);
    }
}

