/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CommandParameter;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Command
extends TopLevelObject
implements NamedObject {
    public static final Integer AV = 0;
    public static final Integer CMC = 1;
    public static final Integer LU = 2;
    public static final Integer FW = 3;
    public static final Integer ATPI = 4;
    public static final Integer LICENSE = 5;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private Long timeLimit;
    private String description;
    private String refId;
    private Integer feature;
    private Long seqNumber;

    public Command() {
        this(true);
    }

    public Command(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(2, new ChildGroup(0, 1));
        this.children.put(1, new ChildGroup(0, 1));
        this.children.put(284, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "Command";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    public Long getDefTimeLimit() {
        return 300L;
    }

    public Long getOptTimeLimit() {
        return this.timeLimit;
    }

    public void setOptTimeLimit(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.timeLimit = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Integer getFeature() {
        return this.feature;
    }

    public String getFeatureValue() throws ValidationException {
        if (this.feature == null) {
            return null;
        }
        String s = null;
        switch (this.feature) {
            case 0: {
                s = "AV";
                break;
            }
            case 1: {
                s = "CMC";
                break;
            }
            case 2: {
                s = "LU";
                break;
            }
            case 3: {
                s = "FW";
                break;
            }
            case 4: {
                s = "ATPI";
                break;
            }
            case 5: {
                s = "LICENSE";
                break;
            }
            default: {
                throw new ValidationException("Command/Feature: invalid attribute value:" + this.feature + "!");
            }
        }
        return s;
    }

    public void setFeature(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.feature = value;
    }

    public void setFeatureValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("AV".equals(value)) {
            this.feature = AV;
        } else if ("CMC".equals(value)) {
            this.feature = CMC;
        } else if ("LU".equals(value)) {
            this.feature = LU;
        } else if ("FW".equals(value)) {
            this.feature = FW;
        } else if ("ATPI".equals(value)) {
            this.feature = ATPI;
        } else if ("LICENSE".equals(value)) {
            this.feature = LICENSE;
        } else {
            throw new ValidationException("Command/Feature: invalid attribute value:" + value + "!");
        }
    }

    public Long getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.seqNumber = value;
    }

    public CommandParameter getOptCommandParameter() {
        ChildGroup childGroup = (ChildGroup)this.children.get(2);
        if (childGroup.size() > 0) {
            return (CommandParameter)childGroup.get(0);
        }
        return null;
    }

    public void setOptCommandParameter(CommandParameter value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CommandParameter obj = this.getOptCommandParameter();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public UnknownContent getOptUnknownContent() {
        ChildGroup childGroup = (ChildGroup)this.children.get(1);
        if (childGroup.size() > 0) {
            return (UnknownContent)childGroup.get(0);
        }
        return null;
    }

    public void setOptUnknownContent(UnknownContent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            UnknownContent obj = this.getOptUnknownContent();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public RebootOptions getOptRebootOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(284);
        if (childGroup.size() > 0) {
            return (RebootOptions)childGroup.get(0);
        }
        return null;
    }

    public void setOptRebootOptions(RebootOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            RebootOptions obj = this.getOptRebootOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 696;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("Command/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("Command/Name: attribute is required!");
        }
        if (this.feature == null) {
            throw new ValidationException("Command/Feature: attribute is required!");
        }
        if (this.seqNumber == null) {
            throw new ValidationException("Command/SeqNumber: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof CommandParameter) {
            try {
                this.setOptCommandParameter((CommandParameter)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof UnknownContent) {
            try {
                this.setOptUnknownContent((UnknownContent)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RebootOptions) {
            try {
                this.setOptRebootOptions((RebootOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("Command/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("Command/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("TimeLimit");
            if (value != null) {
                try {
                    this.timeLimit = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Command/TimeLimit: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Command/TimeLimit: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Description")) != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Feature")) == null) {
                throw new ValidationException("Command/Feature: attribute is required!");
            }
            this.setFeatureValue(value);
            value = attris.getValue("SeqNumber");
            if (value == null) {
                throw new ValidationException("Command/SeqNumber: attribute is required!");
            }
            try {
                this.seqNumber = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("Command/SeqNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("Command/SeqNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptCommandParameter() != null) {
            this.getOptCommandParameter().setReadonly();
        }
        if (this.getOptUnknownContent() != null) {
            this.getOptUnknownContent().setReadonly();
        }
        if (this.getOptRebootOptions() != null) {
            this.getOptRebootOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Command".equals(element.getNodeName())) {
            throw new ValidationException("Command: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("Command/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("Command/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "TimeLimit");
        if (value != null) {
            try {
                this.timeLimit = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Command/TimeLimit: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Description")) != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Feature")) == null) {
            throw new ValidationException("Command/Feature: attribute is required!");
        }
        this.setFeatureValue(value);
        value = XMLHelper.getAttribute(element, "SeqNumber");
        if (value == null) {
            throw new ValidationException("Command/SeqNumber: attribute is required!");
        }
        try {
            this.seqNumber = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Command/SeqNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("Command/SeqNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "CommandParameter");
        if (v.size() > 0) {
            CommandParameter commandParameterObj = new CommandParameter();
            commandParameterObj.importFromElement(v.get(0));
            this.setOptCommandParameter(commandParameterObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "UnknownContent")).size() > 0) {
            UnknownContent unknownContentObj = new UnknownContent();
            unknownContentObj.importFromElement(v.get(0));
            this.setOptUnknownContent(unknownContentObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "RebootOptions")).size() > 0) {
            RebootOptions rebootOptionsObj = new RebootOptions();
            rebootOptionsObj.importFromElement(v.get(0));
            this.setOptRebootOptions(rebootOptionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Command/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Command/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Command");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.timeLimit != null) {
            element.setAttribute("TimeLimit", this.timeLimit.toString());
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.feature != null) {
            element.setAttribute("Feature", this.getFeatureValue());
        }
        if (this.seqNumber != null) {
            element.setAttribute("SeqNumber", this.seqNumber.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Command ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.timeLimit != null) {
                strAttrs.append("TimeLimit=\"").append(this.timeLimit.toString()).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.feature != null) {
                strAttrs.append("Feature=\"").append(this.getFeatureValue()).append("\" ");
            }
            if (this.seqNumber != null) {
                strAttrs.append("SeqNumber=\"").append(this.seqNumber.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Command>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

