/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ClientInstallationSettings
extends TopLevelObject
implements NamedObject {
    public static final Integer WINDOWS = 0;
    public static final Integer MAC = 1;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private Long objAttributes;
    private Integer refCount;
    private String refId;
    private Integer platform;

    public ClientInstallationSettings() {
        this(true);
    }

    public ClientInstallationSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(179, new ChildGroup(1, 1));
        this.children.put(180, new ChildGroup(1, 1));
        this.children.put(284, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ClientInstallationSettings";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    public Long getDefObjAttributes() {
        return 0L;
    }

    public Long getOptObjAttributes() {
        return this.objAttributes;
    }

    public void setOptObjAttributes(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.objAttributes = value;
    }

    public Integer getDefRefCount() {
        return 0;
    }

    public Integer getOptRefCount() {
        return this.refCount;
    }

    public void setOptRefCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refCount = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Integer getDefPlatform() {
        return WINDOWS;
    }

    public Integer getOptPlatform() {
        return this.platform;
    }

    public String getOptPlatformValue() throws ValidationException {
        if (this.platform == null) {
            return null;
        }
        String s = null;
        switch (this.platform) {
            case 0: {
                s = "WINDOWS";
                break;
            }
            case 1: {
                s = "MAC";
                break;
            }
            default: {
                throw new ValidationException("ClientInstallationSettings/Platform: invalid attribute value:" + this.platform + "!");
            }
        }
        return s;
    }

    public void setOptPlatform(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.platform = value;
    }

    public void setOptPlatformValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.platform = null;
            return;
        }
        if ("WINDOWS".equals(value)) {
            this.platform = WINDOWS;
        } else if ("MAC".equals(value)) {
            this.platform = MAC;
        } else {
            throw new ValidationException("ClientInstallationSettings/Platform: invalid attribute value:" + value + "!");
        }
    }

    public InstallationOption getInstallationOption() {
        ChildGroup childGroup = (ChildGroup)this.children.get(179);
        if (childGroup.size() > 0) {
            return (InstallationOption)childGroup.get(0);
        }
        return null;
    }

    public void setInstallationOption(InstallationOption value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            InstallationOption obj = this.getInstallationOption();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public CommunicationOption getCommunicationOption() {
        ChildGroup childGroup = (ChildGroup)this.children.get(180);
        if (childGroup.size() > 0) {
            return (CommunicationOption)childGroup.get(0);
        }
        return null;
    }

    public void setCommunicationOption(CommunicationOption value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CommunicationOption obj = this.getCommunicationOption();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public RebootOptions getOptRebootOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(284);
        if (childGroup.size() > 0) {
            return (RebootOptions)childGroup.get(0);
        }
        return null;
    }

    public void setOptRebootOptions(RebootOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            RebootOptions obj = this.getOptRebootOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 774;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("ClientInstallationSettings/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("ClientInstallationSettings/Name: attribute is required!");
        }
        if (this.getInstallationOption() == null) {
            throw new ValidationException("ClientInstallationSettings/InstallationOption: attribute is required!");
        }
        if (this.getCommunicationOption() == null) {
            throw new ValidationException("ClientInstallationSettings/CommunicationOption: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof InstallationOption) {
            try {
                this.setInstallationOption((InstallationOption)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof CommunicationOption) {
            try {
                this.setCommunicationOption((CommunicationOption)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RebootOptions) {
            try {
                this.setOptRebootOptions((RebootOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("ClientInstallationSettings/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("ClientInstallationSettings/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("ObjAttributes")) != null) {
                try {
                    this.objAttributes = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientInstallationSettings/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientInstallationSettings/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RefCount")) != null) {
                try {
                    this.refCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientInstallationSettings/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientInstallationSettings/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Platform")) != null) {
                this.setOptPlatformValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getInstallationOption() != null) {
            this.getInstallationOption().setReadonly();
        }
        if (this.getCommunicationOption() != null) {
            this.getCommunicationOption().setReadonly();
        }
        if (this.getOptRebootOptions() != null) {
            this.getOptRebootOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(179)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ClientInstallationSettings: can't import element == InstallationOption!");
        }
        try {
            ((ChildGroup)this.children.get(180)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ClientInstallationSettings: can't import element == CommunicationOption!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ClientInstallationSettings".equals(element.getNodeName())) {
            throw new ValidationException("ClientInstallationSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("ClientInstallationSettings/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("ClientInstallationSettings/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ObjAttributes")) != null) {
            try {
                this.objAttributes = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ClientInstallationSettings/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RefCount")) != null) {
            try {
                this.refCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ClientInstallationSettings/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Platform")) != null) {
            this.setOptPlatformValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "InstallationOption")).size() != 1) {
            throw new ValidationException("ClientInstallationSettings/InstallationOption: element is require!");
        }
        InstallationOption installationOptionObj = new InstallationOption();
        installationOptionObj.importFromElement(v.get(0));
        this.setInstallationOption(installationOptionObj);
        v = XMLHelper.getChildElementByName(element, "CommunicationOption");
        if (v.size() != 1) {
            throw new ValidationException("ClientInstallationSettings/CommunicationOption: element is require!");
        }
        CommunicationOption communicationOptionObj = new CommunicationOption();
        communicationOptionObj.importFromElement(v.get(0));
        this.setCommunicationOption(communicationOptionObj);
        v = XMLHelper.getChildElementByName(element, "RebootOptions");
        if (v.size() > 0) {
            RebootOptions rebootOptionsObj = new RebootOptions();
            rebootOptionsObj.importFromElement(v.get(0));
            this.setOptRebootOptions(rebootOptionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ClientInstallationSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ClientInstallationSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ClientInstallationSettings");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.objAttributes != null) {
            element.setAttribute("ObjAttributes", this.objAttributes.toString());
        }
        if (this.refCount != null) {
            element.setAttribute("RefCount", this.refCount.toString());
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.platform != null) {
            element.setAttribute("Platform", this.getOptPlatformValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ClientInstallationSettings ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.objAttributes != null) {
                strAttrs.append("ObjAttributes=\"").append(this.objAttributes.toString()).append("\" ");
            }
            if (this.refCount != null) {
                strAttrs.append("RefCount=\"").append(this.refCount.toString()).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.platform != null) {
                strAttrs.append("Platform=\"").append(this.getOptPlatformValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ClientInstallationSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

