/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ClientInstallationFeatures
extends TopLevelObject
implements NamedObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String appType;
    private Long objAttributes;
    private Integer refCount;
    private String refId;

    public ClientInstallationFeatures() {
        this(true);
    }

    public ClientInstallationFeatures(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(776, new ChildGroup(1, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ClientInstallationFeatures";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.appType = value;
    }

    public Long getDefObjAttributes() {
        return 0L;
    }

    public Long getOptObjAttributes() {
        return this.objAttributes;
    }

    public void setOptObjAttributes(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.objAttributes = value;
    }

    public Integer getDefRefCount() {
        return 0;
    }

    public Integer getOptRefCount() {
        return this.refCount;
    }

    public void setOptRefCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refCount = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public void addEnabledClientFeatures(EnabledClientFeatures value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addEnabledClientFeatures(int index, EnabledClientFeatures value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<EnabledClientFeatures> getEnabledClientFeatures() {
        Vector<EnabledClientFeatures> v = new Vector<EnabledClientFeatures>();
        for (Transportable child : (ChildGroup)this.children.get(776)) {
            v.add((EnabledClientFeatures)child);
        }
        return v;
    }

    public int getEnabledClientFeaturesCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(776);
        return childGroup.size();
    }

    public EnabledClientFeatures getEnabledClientFeatures(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(776);
        return (EnabledClientFeatures)childGroup.get(index);
    }

    public void setEnabledClientFeatures(int index, EnabledClientFeatures value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeEnabledClientFeatures(EnabledClientFeatures value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 775;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("ClientInstallationFeatures/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("ClientInstallationFeatures/Name: attribute is required!");
        }
        if (this.appType == null) {
            throw new ValidationException("ClientInstallationFeatures/AppType: attribute is required!");
        }
        if (this.getEnabledClientFeaturesCount() < 1) {
            throw new ValidationException("ClientInstallationFeatures/EnabledClientFeatures: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof EnabledClientFeatures) {
            try {
                this.addEnabledClientFeatures((EnabledClientFeatures)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("ClientInstallationFeatures/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("ClientInstallationFeatures/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("AppType")) == null) {
                throw new ValidationException("ClientInstallationFeatures/AppType: attribute is required!");
            }
            this.appType = value;
            value = attris.getValue("ObjAttributes");
            if (value != null) {
                try {
                    this.objAttributes = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientInstallationFeatures/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientInstallationFeatures/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RefCount")) != null) {
                try {
                    this.refCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientInstallationFeatures/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientInstallationFeatures/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getEnabledClientFeaturesCount();
        for (i = 0; i < objCnt; ++i) {
            this.getEnabledClientFeatures(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(776)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ClientInstallationFeatures: can't import element == EnabledClientFeatures!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ClientInstallationFeatures".equals(element.getNodeName())) {
            throw new ValidationException("ClientInstallationFeatures: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("ClientInstallationFeatures/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("ClientInstallationFeatures/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AppType")) == null) {
            throw new ValidationException("ClientInstallationFeatures/AppType: attribute is required!");
        }
        this.appType = value;
        value = XMLHelper.getAttribute(element, "ObjAttributes");
        if (value != null) {
            try {
                this.objAttributes = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ClientInstallationFeatures/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RefCount")) != null) {
            try {
                this.refCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ClientInstallationFeatures/RefCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "EnabledClientFeatures")).size() < 1) {
            throw new ValidationException("ClientInstallationFeatures/EnabledClientFeatures: element is require!");
        }
        for (int i = 0; i < v.size(); ++i) {
            EnabledClientFeatures enabledClientFeaturesObj = new EnabledClientFeatures();
            enabledClientFeaturesObj.importFromElement(v.get(i));
            this.addEnabledClientFeatures(enabledClientFeaturesObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ClientInstallationFeatures/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ClientInstallationFeatures/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ClientInstallationFeatures");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.appType != null) {
            element.setAttribute("AppType", this.appType);
        }
        if (this.objAttributes != null) {
            element.setAttribute("ObjAttributes", this.objAttributes.toString());
        }
        if (this.refCount != null) {
            element.setAttribute("RefCount", this.refCount.toString());
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ClientInstallationFeatures ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.appType != null) {
                strAttrs.append("AppType=\"").append(AbstractSchema.checkXMLContent(this.appType)).append("\" ");
            }
            if (this.objAttributes != null) {
                strAttrs.append("ObjAttributes=\"").append(this.objAttributes.toString()).append("\" ");
            }
            if (this.refCount != null) {
                strAttrs.append("RefCount=\"").append(this.refCount.toString()).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ClientInstallationFeatures>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

