/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.DeltaOptions;
import com.sygate.scm.common.configobject.schema.DeltaParameters;
import com.sygate.scm.common.configobject.schema.DeltaParams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ClientDeltaSupport
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public ClientDeltaSupport() {
        this(true);
    }

    public ClientDeltaSupport(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(762, new ChildGroup(1, 1));
        this.children.put(763, new ChildGroup(1, 1));
        this.children.put(764, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ClientDeltaSupport";
    }

    public DeltaParameters getDeltaParameters() {
        ChildGroup childGroup = (ChildGroup)this.children.get(762);
        if (childGroup.size() > 0) {
            return (DeltaParameters)childGroup.get(0);
        }
        return null;
    }

    public void setDeltaParameters(DeltaParameters value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DeltaParameters obj = this.getDeltaParameters();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DeltaOptions getDeltaOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(763);
        if (childGroup.size() > 0) {
            return (DeltaOptions)childGroup.get(0);
        }
        return null;
    }

    public void setDeltaOptions(DeltaOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DeltaOptions obj = this.getDeltaOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addDeltaParams(DeltaParams value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDeltaParams(int index, DeltaParams value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DeltaParams> getDeltaParams() {
        Vector<DeltaParams> v = new Vector<DeltaParams>();
        for (Transportable child : (ChildGroup)this.children.get(764)) {
            v.add((DeltaParams)child);
        }
        return v;
    }

    public int getDeltaParamsCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(764);
        return childGroup.size();
    }

    public DeltaParams getDeltaParams(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(764);
        return (DeltaParams)childGroup.get(index);
    }

    public void setDeltaParams(int index, DeltaParams value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDeltaParams(DeltaParams value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 761;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getDeltaParameters() == null) {
            throw new ValidationException("ClientDeltaSupport/DeltaParameters: attribute is required!");
        }
        if (this.getDeltaOptions() == null) {
            throw new ValidationException("ClientDeltaSupport/DeltaOptions: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof DeltaParameters) {
            try {
                this.setDeltaParameters((DeltaParameters)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DeltaOptions) {
            try {
                this.setDeltaOptions((DeltaOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DeltaParams) {
            try {
                this.addDeltaParams((DeltaParams)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getDeltaParameters() != null) {
            this.getDeltaParameters().setReadonly();
        }
        if (this.getDeltaOptions() != null) {
            this.getDeltaOptions().setReadonly();
        }
        int objCnt = this.getDeltaParamsCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDeltaParams(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(762)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ClientDeltaSupport: can't import element == DeltaParameters!");
        }
        try {
            ((ChildGroup)this.children.get(763)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ClientDeltaSupport: can't import element == DeltaOptions!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ClientDeltaSupport".equals(element.getNodeName())) {
            throw new ValidationException("ClientDeltaSupport: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DeltaParameters");
        if (v.size() != 1) {
            throw new ValidationException("ClientDeltaSupport/DeltaParameters: element is require!");
        }
        DeltaParameters deltaParametersObj = new DeltaParameters();
        deltaParametersObj.importFromElement(v.get(0));
        this.setDeltaParameters(deltaParametersObj);
        v = XMLHelper.getChildElementByName(element, "DeltaOptions");
        if (v.size() != 1) {
            throw new ValidationException("ClientDeltaSupport/DeltaOptions: element is require!");
        }
        DeltaOptions deltaOptionsObj = new DeltaOptions();
        deltaOptionsObj.importFromElement(v.get(0));
        this.setDeltaOptions(deltaOptionsObj);
        v = XMLHelper.getChildElementByName(element, "DeltaParams");
        for (int i = 0; i < v.size(); ++i) {
            DeltaParams deltaParamsObj = new DeltaParams();
            deltaParamsObj.importFromElement(v.get(i));
            this.addDeltaParams(deltaParamsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ClientDeltaSupport/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ClientDeltaSupport/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ClientDeltaSupport");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ClientDeltaSupport ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ClientDeltaSupport>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

