/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CertificateOverride
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String thumbprint;
    private String thumbprintSHA2;
    private String signer;
    private String issuer;

    public CertificateOverride() {
        this(true);
    }

    public CertificateOverride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "CertificateOverride";
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.thumbprint = value;
    }

    public String getOptThumbprintSHA2() {
        return this.thumbprintSHA2;
    }

    public void setOptThumbprintSHA2(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.thumbprintSHA2 = value;
    }

    public String getOptSigner() {
        return this.signer;
    }

    public void setOptSigner(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.signer = value;
    }

    public String getOptIssuer() {
        return this.issuer;
    }

    public void setOptIssuer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.issuer = value;
    }

    @Override
    public int getObjectType() {
        return 684;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.thumbprint == null) {
            throw new ValidationException("CertificateOverride/Thumbprint: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Thumbprint");
            if (value == null) {
                throw new ValidationException("CertificateOverride/Thumbprint: attribute is required!");
            }
            this.thumbprint = value;
            value = attris.getValue("ThumbprintSHA2");
            if (value != null) {
                this.thumbprintSHA2 = value;
            }
            if ((value = attris.getValue("Signer")) != null) {
                this.signer = value;
            }
            if ((value = attris.getValue("Issuer")) != null) {
                this.issuer = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"CertificateOverride".equals(element.getNodeName())) {
            throw new ValidationException("CertificateOverride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Thumbprint");
        if (value == null) {
            throw new ValidationException("CertificateOverride/Thumbprint: attribute is required!");
        }
        this.thumbprint = value;
        value = XMLHelper.getAttribute(element, "ThumbprintSHA2");
        if (value != null) {
            this.thumbprintSHA2 = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Signer")) != null) {
            this.signer = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Issuer")) != null) {
            this.issuer = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("CertificateOverride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("CertificateOverride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("CertificateOverride");
        if (this.thumbprint != null) {
            element.setAttribute("Thumbprint", this.thumbprint);
        }
        if (this.thumbprintSHA2 != null) {
            element.setAttribute("ThumbprintSHA2", this.thumbprintSHA2);
        }
        if (this.signer != null) {
            element.setAttribute("Signer", this.signer);
        }
        if (this.issuer != null) {
            element.setAttribute("Issuer", this.issuer);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<CertificateOverride ");
            if (this.thumbprint != null) {
                strAttrs.append("Thumbprint=\"").append(AbstractSchema.checkXMLContent(this.thumbprint)).append("\" ");
            }
            if (this.thumbprintSHA2 != null) {
                strAttrs.append("ThumbprintSHA2=\"").append(AbstractSchema.checkXMLContent(this.thumbprintSHA2)).append("\" ");
            }
            if (this.signer != null) {
                strAttrs.append("Signer=\"").append(AbstractSchema.checkXMLContent(this.signer)).append("\" ");
            }
            if (this.issuer != null) {
                strAttrs.append("Issuer=\"").append(AbstractSchema.checkXMLContent(this.issuer)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</CertificateOverride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

