/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AppliedBufferOverrunAppComPackArray;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import com.sygate.scm.common.configobject.schema.OpAction;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BufferOverrunProtection
extends ConfigObject {
    public static final Integer ALL = 0;
    public static final Integer ONLY_SERVICE = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer processToBeProtected;

    public BufferOverrunProtection() {
        this(true);
    }

    public BufferOverrunProtection(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(447, new ChildGroup(1, 1));
        this.children.put(281, new ChildGroup(0, 1));
        this.children.put(298, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "BufferOverrunProtection";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefProcessToBeProtected() {
        return ONLY_SERVICE;
    }

    public Integer getOptProcessToBeProtected() {
        return this.processToBeProtected;
    }

    public String getOptProcessToBeProtectedValue() throws ValidationException {
        if (this.processToBeProtected == null) {
            return null;
        }
        String s = null;
        switch (this.processToBeProtected) {
            case 0: {
                s = "ALL";
                break;
            }
            case 1: {
                s = "ONLY_SERVICE";
                break;
            }
            default: {
                throw new ValidationException("BufferOverrunProtection/ProcessToBeProtected: invalid attribute value:" + this.processToBeProtected + "!");
            }
        }
        return s;
    }

    public void setOptProcessToBeProtected(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.processToBeProtected = value;
    }

    public void setOptProcessToBeProtectedValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.processToBeProtected = null;
            return;
        }
        if ("ALL".equals(value)) {
            this.processToBeProtected = ALL;
        } else if ("ONLY_SERVICE".equals(value)) {
            this.processToBeProtected = ONLY_SERVICE;
        } else {
            throw new ValidationException("BufferOverrunProtection/ProcessToBeProtected: invalid attribute value:" + value + "!");
        }
    }

    public OpAction getOpAction() {
        ChildGroup childGroup = (ChildGroup)this.children.get(447);
        if (childGroup.size() > 0) {
            return (OpAction)childGroup.get(0);
        }
        return null;
    }

    public void setOpAction(OpAction value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            OpAction obj = this.getOpAction();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ExcludedAppArray getOptExcludedAppArray() {
        ChildGroup childGroup = (ChildGroup)this.children.get(281);
        if (childGroup.size() > 0) {
            return (ExcludedAppArray)childGroup.get(0);
        }
        return null;
    }

    public void setOptExcludedAppArray(ExcludedAppArray value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ExcludedAppArray obj = this.getOptExcludedAppArray();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AppliedBufferOverrunAppComPackArray getOptAppliedBufferOverrunAppComPackArray() {
        ChildGroup childGroup = (ChildGroup)this.children.get(298);
        if (childGroup.size() > 0) {
            return (AppliedBufferOverrunAppComPackArray)childGroup.get(0);
        }
        return null;
    }

    public void setOptAppliedBufferOverrunAppComPackArray(AppliedBufferOverrunAppComPackArray value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AppliedBufferOverrunAppComPackArray obj = this.getOptAppliedBufferOverrunAppComPackArray();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 297;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getOpAction() == null) {
            throw new ValidationException("BufferOverrunProtection/OpAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof OpAction) {
            try {
                this.setOpAction((OpAction)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ExcludedAppArray) {
            try {
                this.setOptExcludedAppArray((ExcludedAppArray)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AppliedBufferOverrunAppComPackArray) {
            try {
                this.setOptAppliedBufferOverrunAppComPackArray((AppliedBufferOverrunAppComPackArray)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("ProcessToBeProtected")) != null) {
                this.setOptProcessToBeProtectedValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOpAction() != null) {
            this.getOpAction().setReadonly();
        }
        if (this.getOptExcludedAppArray() != null) {
            this.getOptExcludedAppArray().setReadonly();
        }
        if (this.getOptAppliedBufferOverrunAppComPackArray() != null) {
            this.getOptAppliedBufferOverrunAppComPackArray().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(447)).size();
        }
        catch (Throwable t) {
            throw new SAXException("BufferOverrunProtection: can't import element == OpAction!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"BufferOverrunProtection".equals(element.getNodeName())) {
            throw new ValidationException("BufferOverrunProtection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ProcessToBeProtected")) != null) {
            this.setOptProcessToBeProtectedValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "OpAction")).size() != 1) {
            throw new ValidationException("BufferOverrunProtection/OpAction: element is require!");
        }
        OpAction opActionObj = new OpAction();
        opActionObj.importFromElement(v.get(0));
        this.setOpAction(opActionObj);
        v = XMLHelper.getChildElementByName(element, "ExcludedAppArray");
        if (v.size() > 0) {
            ExcludedAppArray excludedAppArrayObj = new ExcludedAppArray();
            excludedAppArrayObj.importFromElement(v.get(0));
            this.setOptExcludedAppArray(excludedAppArrayObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AppliedBufferOverrunAppComPackArray")).size() > 0) {
            AppliedBufferOverrunAppComPackArray appliedBufferOverrunAppComPackArrayObj = new AppliedBufferOverrunAppComPackArray();
            appliedBufferOverrunAppComPackArrayObj.importFromElement(v.get(0));
            this.setOptAppliedBufferOverrunAppComPackArray(appliedBufferOverrunAppComPackArrayObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("BufferOverrunProtection/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("BufferOverrunProtection/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("BufferOverrunProtection");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.processToBeProtected != null) {
            element.setAttribute("ProcessToBeProtected", this.getOptProcessToBeProtectedValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<BufferOverrunProtection ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.processToBeProtected != null) {
                strAttrs.append("ProcessToBeProtected=\"").append(this.getOptProcessToBeProtectedValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</BufferOverrunProtection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

