/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.BackupContent;
import com.sygate.scm.common.configobject.schema.Schedule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Backup
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String comment;
    private String backupMasterServer;
    private Integer maxBackupHistory;

    public Backup() {
        this(true);
    }

    public Backup(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(86, new ChildGroup(1, 1));
        this.children.put(83, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "Backup";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getOptComment() {
        return this.comment;
    }

    public void setOptComment(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.comment = value;
    }

    public String getBackupMasterServer() {
        return this.backupMasterServer;
    }

    public void setBackupMasterServer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.backupMasterServer = value;
    }

    public Integer getOptMaxBackupHistory() {
        return this.maxBackupHistory;
    }

    public void setOptMaxBackupHistory(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.maxBackupHistory = value;
    }

    public BackupContent getBackupContent() {
        ChildGroup childGroup = (ChildGroup)this.children.get(86);
        if (childGroup.size() > 0) {
            return (BackupContent)childGroup.get(0);
        }
        return null;
    }

    public void setBackupContent(BackupContent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BackupContent obj = this.getBackupContent();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Schedule getSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(83);
        if (childGroup.size() > 0) {
            return (Schedule)childGroup.get(0);
        }
        return null;
    }

    public void setSchedule(Schedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Schedule obj = this.getSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 85;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.backupMasterServer == null) {
            throw new ValidationException("Backup/BackupMasterServer: attribute is required!");
        }
        if (this.getBackupContent() == null) {
            throw new ValidationException("Backup/BackupContent: attribute is required!");
        }
        if (this.getSchedule() == null) {
            throw new ValidationException("Backup/Schedule: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof BackupContent) {
            try {
                this.setBackupContent((BackupContent)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Schedule) {
            try {
                this.setSchedule((Schedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Comment")) != null) {
                this.comment = value;
            }
            if ((value = attris.getValue("BackupMasterServer")) == null) {
                throw new ValidationException("Backup/BackupMasterServer: attribute is required!");
            }
            this.backupMasterServer = value;
            value = attris.getValue("MaxBackupHistory");
            if (value != null) {
                try {
                    this.maxBackupHistory = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Backup/MaxBackupHistory: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Backup/MaxBackupHistory: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getBackupContent() != null) {
            this.getBackupContent().setReadonly();
        }
        if (this.getSchedule() != null) {
            this.getSchedule().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(86)).size();
        }
        catch (Throwable t) {
            throw new SAXException("Backup: can't import element == BackupContent!");
        }
        try {
            ((ChildGroup)this.children.get(83)).size();
        }
        catch (Throwable t) {
            throw new SAXException("Backup: can't import element == Schedule!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"Backup".equals(element.getNodeName())) {
            throw new ValidationException("Backup: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Comment")) != null) {
            this.comment = value;
        }
        if ((value = XMLHelper.getAttribute(element, "BackupMasterServer")) == null) {
            throw new ValidationException("Backup/BackupMasterServer: attribute is required!");
        }
        this.backupMasterServer = value;
        value = XMLHelper.getAttribute(element, "MaxBackupHistory");
        if (value != null) {
            try {
                this.maxBackupHistory = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Backup/MaxBackupHistory: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((v = XMLHelper.getChildElementByName(element, "BackupContent")).size() != 1) {
            throw new ValidationException("Backup/BackupContent: element is require!");
        }
        BackupContent backupContentObj = new BackupContent();
        backupContentObj.importFromElement(v.get(0));
        this.setBackupContent(backupContentObj);
        v = XMLHelper.getChildElementByName(element, "Schedule");
        if (v.size() != 1) {
            throw new ValidationException("Backup/Schedule: element is require!");
        }
        Schedule scheduleObj = new Schedule();
        scheduleObj.importFromElement(v.get(0));
        this.setSchedule(scheduleObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Backup/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Backup/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Backup");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.comment != null) {
            element.setAttribute("Comment", this.comment);
        }
        if (this.backupMasterServer != null) {
            element.setAttribute("BackupMasterServer", this.backupMasterServer);
        }
        if (this.maxBackupHistory != null) {
            element.setAttribute("MaxBackupHistory", this.maxBackupHistory.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Backup ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.comment != null) {
                strAttrs.append("Comment=\"").append(AbstractSchema.checkXMLContent(this.comment)).append("\" ");
            }
            if (this.backupMasterServer != null) {
                strAttrs.append("BackupMasterServer=\"").append(AbstractSchema.checkXMLContent(this.backupMasterServer)).append("\" ");
            }
            if (this.maxBackupHistory != null) {
                strAttrs.append("MaxBackupHistory=\"").append(this.maxBackupHistory.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Backup>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

