/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BASHSystemChanges
extends ConfigObject {
    public static final Integer IGNORE = 0;
    public static final Integer PROMPT = 1;
    public static final Integer BLOCK = 2;
    public static final Integer LOG = 3;
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Integer dNSChangeDetectAction;
    private Boolean lockDNSChangeDetectAction;
    private Integer hostFileChangeDetectAction;
    private Boolean lockHostFileChangeDetectAction;

    public BASHSystemChanges() {
        this(true);
    }

    public BASHSystemChanges(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "BASHSystemChanges";
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public Integer getDefDNSChangeDetectAction() {
        return IGNORE;
    }

    public Integer getDNSChangeDetectAction() {
        return this.dNSChangeDetectAction;
    }

    public String getDNSChangeDetectActionValue() throws ValidationException {
        if (this.dNSChangeDetectAction == null) {
            return null;
        }
        String s = null;
        switch (this.dNSChangeDetectAction) {
            case 0: {
                s = "IGNORE";
                break;
            }
            case 1: {
                s = "PROMPT";
                break;
            }
            case 2: {
                s = "BLOCK";
                break;
            }
            case 3: {
                s = "LOG";
                break;
            }
            default: {
                throw new ValidationException("BASHSystemChanges/DNSChangeDetectAction: invalid attribute value:" + this.dNSChangeDetectAction + "!");
            }
        }
        return s;
    }

    public void setDNSChangeDetectAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dNSChangeDetectAction = value;
    }

    public void setDNSChangeDetectActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("IGNORE".equals(value)) {
            this.dNSChangeDetectAction = IGNORE;
        } else if ("PROMPT".equals(value)) {
            this.dNSChangeDetectAction = PROMPT;
        } else if ("BLOCK".equals(value)) {
            this.dNSChangeDetectAction = BLOCK;
        } else if ("LOG".equals(value)) {
            this.dNSChangeDetectAction = LOG;
        } else {
            throw new ValidationException("BASHSystemChanges/DNSChangeDetectAction: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockDNSChangeDetectAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDNSChangeDetectAction() {
        return this.lockDNSChangeDetectAction;
    }

    public void setOptLockDNSChangeDetectAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDNSChangeDetectAction = value;
    }

    public Integer getDefHostFileChangeDetectAction() {
        return IGNORE;
    }

    public Integer getHostFileChangeDetectAction() {
        return this.hostFileChangeDetectAction;
    }

    public String getHostFileChangeDetectActionValue() throws ValidationException {
        if (this.hostFileChangeDetectAction == null) {
            return null;
        }
        String s = null;
        switch (this.hostFileChangeDetectAction) {
            case 0: {
                s = "IGNORE";
                break;
            }
            case 1: {
                s = "PROMPT";
                break;
            }
            case 2: {
                s = "BLOCK";
                break;
            }
            case 3: {
                s = "LOG";
                break;
            }
            default: {
                throw new ValidationException("BASHSystemChanges/HostFileChangeDetectAction: invalid attribute value:" + this.hostFileChangeDetectAction + "!");
            }
        }
        return s;
    }

    public void setHostFileChangeDetectAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hostFileChangeDetectAction = value;
    }

    public void setHostFileChangeDetectActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("IGNORE".equals(value)) {
            this.hostFileChangeDetectAction = IGNORE;
        } else if ("PROMPT".equals(value)) {
            this.hostFileChangeDetectAction = PROMPT;
        } else if ("BLOCK".equals(value)) {
            this.hostFileChangeDetectAction = BLOCK;
        } else if ("LOG".equals(value)) {
            this.hostFileChangeDetectAction = LOG;
        } else {
            throw new ValidationException("BASHSystemChanges/HostFileChangeDetectAction: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockHostFileChangeDetectAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockHostFileChangeDetectAction() {
        return this.lockHostFileChangeDetectAction;
    }

    public void setOptLockHostFileChangeDetectAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockHostFileChangeDetectAction = value;
    }

    @Override
    public int getObjectType() {
        return 652;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.dNSChangeDetectAction == null) {
            throw new ValidationException("BASHSystemChanges/DNSChangeDetectAction: attribute is required!");
        }
        if (this.hostFileChangeDetectAction == null) {
            throw new ValidationException("BASHSystemChanges/HostFileChangeDetectAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("DNSChangeDetectAction")) == null) {
                throw new ValidationException("BASHSystemChanges/DNSChangeDetectAction: attribute is required!");
            }
            this.setDNSChangeDetectActionValue(value);
            value = attris.getValue("LockDNSChangeDetectAction");
            if (value != null) {
                this.lockDNSChangeDetectAction = "1".equals(value);
            }
            if ((value = attris.getValue("HostFileChangeDetectAction")) == null) {
                throw new ValidationException("BASHSystemChanges/HostFileChangeDetectAction: attribute is required!");
            }
            this.setHostFileChangeDetectActionValue(value);
            value = attris.getValue("LockHostFileChangeDetectAction");
            if (value != null) {
                this.lockHostFileChangeDetectAction = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"BASHSystemChanges".equals(element.getNodeName())) {
            throw new ValidationException("BASHSystemChanges: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DNSChangeDetectAction")) == null) {
            throw new ValidationException("BASHSystemChanges/DNSChangeDetectAction: attribute is required!");
        }
        this.setDNSChangeDetectActionValue(value);
        value = XMLHelper.getAttribute(element, "LockDNSChangeDetectAction");
        if (value != null) {
            this.lockDNSChangeDetectAction = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HostFileChangeDetectAction")) == null) {
            throw new ValidationException("BASHSystemChanges/HostFileChangeDetectAction: attribute is required!");
        }
        this.setHostFileChangeDetectActionValue(value);
        value = XMLHelper.getAttribute(element, "LockHostFileChangeDetectAction");
        if (value != null) {
            this.lockHostFileChangeDetectAction = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("BASHSystemChanges/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("BASHSystemChanges/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("BASHSystemChanges");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.dNSChangeDetectAction != null) {
            element.setAttribute("DNSChangeDetectAction", this.getDNSChangeDetectActionValue());
        }
        if (this.lockDNSChangeDetectAction != null) {
            element.setAttribute("LockDNSChangeDetectAction", this.lockDNSChangeDetectAction != false ? "1" : "0");
        }
        if (this.hostFileChangeDetectAction != null) {
            element.setAttribute("HostFileChangeDetectAction", this.getHostFileChangeDetectActionValue());
        }
        if (this.lockHostFileChangeDetectAction != null) {
            element.setAttribute("LockHostFileChangeDetectAction", this.lockHostFileChangeDetectAction != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<BASHSystemChanges ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.dNSChangeDetectAction != null) {
                strAttrs.append("DNSChangeDetectAction=\"").append(this.getDNSChangeDetectActionValue()).append("\" ");
            }
            if (this.lockDNSChangeDetectAction != null) {
                strAttrs.append("LockDNSChangeDetectAction=").append(this.lockDNSChangeDetectAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.hostFileChangeDetectAction != null) {
                strAttrs.append("HostFileChangeDetectAction=\"").append(this.getHostFileChangeDetectActionValue()).append("\" ");
            }
            if (this.lockHostFileChangeDetectAction != null) {
                strAttrs.append("LockHostFileChangeDetectAction=").append(this.lockHostFileChangeDetectAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</BASHSystemChanges>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

