/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.BASHBPESettings;
import com.sygate.scm.common.configobject.schema.BASHConfidenceSettings;
import com.sygate.scm.common.configobject.schema.BASHNetworkSettings;
import com.sygate.scm.common.configobject.schema.BASHSystemChanges;
import com.sygate.scm.common.configobject.schema.HppNotifications;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BASHPolicy
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Boolean locked;

    public BASHPolicy() {
        this(true);
    }

    public BASHPolicy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(649, new ChildGroup(0, 1));
        this.children.put(647, new ChildGroup(0, 1));
        this.children.put(652, new ChildGroup(0, 1));
        this.children.put(653, new ChildGroup(0, 1));
        this.children.put(654, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "BASHPolicy";
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public Boolean getDefLocked() {
        return Boolean.FALSE;
    }

    public Boolean getOptLocked() {
        return this.locked;
    }

    public void setOptLocked(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.locked = value;
    }

    public BASHConfidenceSettings getOptBASHConfidenceSettings() {
        ChildGroup childGroup = (ChildGroup)this.children.get(649);
        if (childGroup.size() > 0) {
            return (BASHConfidenceSettings)childGroup.get(0);
        }
        return null;
    }

    public void setOptBASHConfidenceSettings(BASHConfidenceSettings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BASHConfidenceSettings obj = this.getOptBASHConfidenceSettings();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public HppNotifications getOptHppNotifications() {
        ChildGroup childGroup = (ChildGroup)this.children.get(647);
        if (childGroup.size() > 0) {
            return (HppNotifications)childGroup.get(0);
        }
        return null;
    }

    public void setOptHppNotifications(HppNotifications value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HppNotifications obj = this.getOptHppNotifications();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public BASHSystemChanges getOptBASHSystemChanges() {
        ChildGroup childGroup = (ChildGroup)this.children.get(652);
        if (childGroup.size() > 0) {
            return (BASHSystemChanges)childGroup.get(0);
        }
        return null;
    }

    public void setOptBASHSystemChanges(BASHSystemChanges value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BASHSystemChanges obj = this.getOptBASHSystemChanges();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public BASHBPESettings getOptBASHBPESettings() {
        ChildGroup childGroup = (ChildGroup)this.children.get(653);
        if (childGroup.size() > 0) {
            return (BASHBPESettings)childGroup.get(0);
        }
        return null;
    }

    public void setOptBASHBPESettings(BASHBPESettings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BASHBPESettings obj = this.getOptBASHBPESettings();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public BASHNetworkSettings getOptBASHNetworkSettings() {
        ChildGroup childGroup = (ChildGroup)this.children.get(654);
        if (childGroup.size() > 0) {
            return (BASHNetworkSettings)childGroup.get(0);
        }
        return null;
    }

    public void setOptBASHNetworkSettings(BASHNetworkSettings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BASHNetworkSettings obj = this.getOptBASHNetworkSettings();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 648;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof BASHConfidenceSettings) {
            try {
                this.setOptBASHConfidenceSettings((BASHConfidenceSettings)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof HppNotifications) {
            try {
                this.setOptHppNotifications((HppNotifications)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof BASHSystemChanges) {
            try {
                this.setOptBASHSystemChanges((BASHSystemChanges)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof BASHBPESettings) {
            try {
                this.setOptBASHBPESettings((BASHBPESettings)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof BASHNetworkSettings) {
            try {
                this.setOptBASHNetworkSettings((BASHNetworkSettings)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("Locked")) != null) {
                this.locked = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptBASHConfidenceSettings() != null) {
            this.getOptBASHConfidenceSettings().setReadonly();
        }
        if (this.getOptHppNotifications() != null) {
            this.getOptHppNotifications().setReadonly();
        }
        if (this.getOptBASHSystemChanges() != null) {
            this.getOptBASHSystemChanges().setReadonly();
        }
        if (this.getOptBASHBPESettings() != null) {
            this.getOptBASHBPESettings().setReadonly();
        }
        if (this.getOptBASHNetworkSettings() != null) {
            this.getOptBASHNetworkSettings().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"BASHPolicy".equals(element.getNodeName())) {
            throw new ValidationException("BASHPolicy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Locked")) != null) {
            this.locked = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "BASHConfidenceSettings")).size() > 0) {
            BASHConfidenceSettings bASHConfidenceSettingsObj = new BASHConfidenceSettings();
            bASHConfidenceSettingsObj.importFromElement(v.get(0));
            this.setOptBASHConfidenceSettings(bASHConfidenceSettingsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "HppNotifications")).size() > 0) {
            HppNotifications hppNotificationsObj = new HppNotifications();
            hppNotificationsObj.importFromElement(v.get(0));
            this.setOptHppNotifications(hppNotificationsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "BASHSystemChanges")).size() > 0) {
            BASHSystemChanges bASHSystemChangesObj = new BASHSystemChanges();
            bASHSystemChangesObj.importFromElement(v.get(0));
            this.setOptBASHSystemChanges(bASHSystemChangesObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "BASHBPESettings")).size() > 0) {
            BASHBPESettings bASHBPESettingsObj = new BASHBPESettings();
            bASHBPESettingsObj.importFromElement(v.get(0));
            this.setOptBASHBPESettings(bASHBPESettingsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "BASHNetworkSettings")).size() > 0) {
            BASHNetworkSettings bASHNetworkSettingsObj = new BASHNetworkSettings();
            bASHNetworkSettingsObj.importFromElement(v.get(0));
            this.setOptBASHNetworkSettings(bASHNetworkSettingsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("BASHPolicy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("BASHPolicy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("BASHPolicy");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.locked != null) {
            element.setAttribute("Locked", this.locked != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<BASHPolicy ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.locked != null) {
                strAttrs.append("Locked=").append(this.locked != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</BASHPolicy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

