/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BASHLowConfidence
extends ConfigObject {
    public static final Integer LOG = 0;
    public static final Integer QUARANTINE = 1;
    public static final Integer DELETE = 2;
    public static final Integer DISABLED = 3;
    private static final long serialVersionUID = 1L;
    private Integer lowConfidenceAction;
    private Boolean lockLowConfidenceAction;
    private Boolean enableAggressiveMode;
    private Boolean lockAggressiveMode;

    public BASHLowConfidence() {
        this(true);
    }

    public BASHLowConfidence(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "BASHLowConfidence";
    }

    public Integer getDefLowConfidenceAction() {
        String productType = System.getProperty("Spc.Product.Type", "");
        return "SEPSB".equals(productType) ? DISABLED : LOG;
    }

    public Integer getLowConfidenceAction() {
        return this.lowConfidenceAction;
    }

    public String getLowConfidenceActionValue() throws ValidationException {
        if (this.lowConfidenceAction == null) {
            return null;
        }
        String s = null;
        switch (this.lowConfidenceAction) {
            case 0: {
                s = "LOG";
                break;
            }
            case 1: {
                s = "QUARANTINE";
                break;
            }
            case 2: {
                s = "DELETE";
                break;
            }
            case 3: {
                s = "DISABLED";
                break;
            }
            default: {
                throw new ValidationException("BASHLowConfidence/LowConfidenceAction: invalid attribute value:" + this.lowConfidenceAction + "!");
            }
        }
        return s;
    }

    public void setLowConfidenceAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lowConfidenceAction = value;
    }

    public void setLowConfidenceActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("LOG".equals(value)) {
            this.lowConfidenceAction = LOG;
        } else if ("QUARANTINE".equals(value)) {
            this.lowConfidenceAction = QUARANTINE;
        } else if ("DELETE".equals(value)) {
            this.lowConfidenceAction = DELETE;
        } else if ("DISABLED".equals(value)) {
            this.lowConfidenceAction = DISABLED;
        } else {
            throw new ValidationException("BASHLowConfidence/LowConfidenceAction: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockLowConfidenceAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockLowConfidenceAction() {
        return this.lockLowConfidenceAction;
    }

    public void setOptLockLowConfidenceAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockLowConfidenceAction = value;
    }

    public Boolean getDefEnableAggressiveMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableAggressiveMode() {
        return this.enableAggressiveMode;
    }

    public void setOptEnableAggressiveMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableAggressiveMode = value;
    }

    public Boolean getDefLockAggressiveMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockAggressiveMode() {
        return this.lockAggressiveMode;
    }

    public void setOptLockAggressiveMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockAggressiveMode = value;
    }

    @Override
    public int getObjectType() {
        return 651;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.lowConfidenceAction == null) {
            throw new ValidationException("BASHLowConfidence/LowConfidenceAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("LowConfidenceAction");
            if (value == null) {
                throw new ValidationException("BASHLowConfidence/LowConfidenceAction: attribute is required!");
            }
            this.setLowConfidenceActionValue(value);
            value = attris.getValue("LockLowConfidenceAction");
            if (value != null) {
                this.lockLowConfidenceAction = "1".equals(value);
            }
            if ((value = attris.getValue("EnableAggressiveMode")) != null) {
                this.enableAggressiveMode = "1".equals(value);
            }
            if ((value = attris.getValue("LockAggressiveMode")) != null) {
                this.lockAggressiveMode = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"BASHLowConfidence".equals(element.getNodeName())) {
            throw new ValidationException("BASHLowConfidence: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "LowConfidenceAction");
        if (value == null) {
            throw new ValidationException("BASHLowConfidence/LowConfidenceAction: attribute is required!");
        }
        this.setLowConfidenceActionValue(value);
        value = XMLHelper.getAttribute(element, "LockLowConfidenceAction");
        if (value != null) {
            this.lockLowConfidenceAction = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableAggressiveMode")) != null) {
            this.enableAggressiveMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockAggressiveMode")) != null) {
            this.lockAggressiveMode = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("BASHLowConfidence/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("BASHLowConfidence/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("BASHLowConfidence");
        if (this.lowConfidenceAction != null) {
            element.setAttribute("LowConfidenceAction", this.getLowConfidenceActionValue());
        }
        if (this.lockLowConfidenceAction != null) {
            element.setAttribute("LockLowConfidenceAction", this.lockLowConfidenceAction != false ? "1" : "0");
        }
        if (this.enableAggressiveMode != null) {
            element.setAttribute("EnableAggressiveMode", this.enableAggressiveMode != false ? "1" : "0");
        }
        if (this.lockAggressiveMode != null) {
            element.setAttribute("LockAggressiveMode", this.lockAggressiveMode != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<BASHLowConfidence ");
            if (this.lowConfidenceAction != null) {
                strAttrs.append("LowConfidenceAction=\"").append(this.getLowConfidenceActionValue()).append("\" ");
            }
            if (this.lockLowConfidenceAction != null) {
                strAttrs.append("LockLowConfidenceAction=").append(this.lockLowConfidenceAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableAggressiveMode != null) {
                strAttrs.append("EnableAggressiveMode=").append(this.enableAggressiveMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockAggressiveMode != null) {
                strAttrs.append("LockAggressiveMode=").append(this.lockAggressiveMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</BASHLowConfidence>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

