/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BASHHighConfidence
extends ConfigObject {
    public static final Integer LOG = 0;
    public static final Integer QUARANTINE = 1;
    public static final Integer DELETE = 2;
    private static final long serialVersionUID = 1L;
    private Integer highConfidenceAction;
    private Boolean lockHighConfidenceAction;

    public BASHHighConfidence() {
        this(true);
    }

    public BASHHighConfidence(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "BASHHighConfidence";
    }

    public Integer getDefHighConfidenceAction() {
        return QUARANTINE;
    }

    public Integer getHighConfidenceAction() {
        return this.highConfidenceAction;
    }

    public String getHighConfidenceActionValue() throws ValidationException {
        if (this.highConfidenceAction == null) {
            return null;
        }
        String s = null;
        switch (this.highConfidenceAction) {
            case 0: {
                s = "LOG";
                break;
            }
            case 1: {
                s = "QUARANTINE";
                break;
            }
            case 2: {
                s = "DELETE ";
                break;
            }
            default: {
                throw new ValidationException("BASHHighConfidence/HighConfidenceAction: invalid attribute value:" + this.highConfidenceAction + "!");
            }
        }
        return s;
    }

    public void setHighConfidenceAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.highConfidenceAction = value;
    }

    public void setHighConfidenceActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("LOG".equals(value)) {
            this.highConfidenceAction = LOG;
        } else if ("QUARANTINE".equals(value)) {
            this.highConfidenceAction = QUARANTINE;
        } else if ("DELETE ".equals(value)) {
            this.highConfidenceAction = DELETE;
        } else {
            throw new ValidationException("BASHHighConfidence/HighConfidenceAction: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockHighConfidenceAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockHighConfidenceAction() {
        return this.lockHighConfidenceAction;
    }

    public void setOptLockHighConfidenceAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockHighConfidenceAction = value;
    }

    @Override
    public int getObjectType() {
        return 650;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.highConfidenceAction == null) {
            throw new ValidationException("BASHHighConfidence/HighConfidenceAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("HighConfidenceAction");
            if (value == null) {
                throw new ValidationException("BASHHighConfidence/HighConfidenceAction: attribute is required!");
            }
            this.setHighConfidenceActionValue(value);
            value = attris.getValue("LockHighConfidenceAction");
            if (value != null) {
                this.lockHighConfidenceAction = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"BASHHighConfidence".equals(element.getNodeName())) {
            throw new ValidationException("BASHHighConfidence: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "HighConfidenceAction");
        if (value == null) {
            throw new ValidationException("BASHHighConfidence/HighConfidenceAction: attribute is required!");
        }
        this.setHighConfidenceActionValue(value);
        value = XMLHelper.getAttribute(element, "LockHighConfidenceAction");
        if (value != null) {
            this.lockHighConfidenceAction = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("BASHHighConfidence/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("BASHHighConfidence/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("BASHHighConfidence");
        if (this.highConfidenceAction != null) {
            element.setAttribute("HighConfidenceAction", this.getHighConfidenceActionValue());
        }
        if (this.lockHighConfidenceAction != null) {
            element.setAttribute("LockHighConfidenceAction", this.lockHighConfidenceAction != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<BASHHighConfidence ");
            if (this.highConfidenceAction != null) {
                strAttrs.append("HighConfidenceAction=\"").append(this.getHighConfidenceActionValue()).append("\" ");
            }
            if (this.lockHighConfidenceAction != null) {
                strAttrs.append("LockHighConfidenceAction=").append(this.lockHighConfidenceAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</BASHHighConfidence>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

