/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ScanProgressOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AvScanSettings
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean delayScanWhenRunningOnBatteries;
    private Boolean allowScanWithoutLogin;
    private Boolean notificationWhenLoggedOff;
    private Boolean runStartupScanOnLogin;
    private Boolean allowUserModifyStartupScans;
    private Boolean runQuickScanOnNewDefs;

    public AvScanSettings() {
        this(true);
    }

    public AvScanSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(676, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AvScanSettings";
    }

    public Boolean getDefDelayScanWhenRunningOnBatteries() {
        return Boolean.TRUE;
    }

    public Boolean getOptDelayScanWhenRunningOnBatteries() {
        return this.delayScanWhenRunningOnBatteries;
    }

    public void setOptDelayScanWhenRunningOnBatteries(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.delayScanWhenRunningOnBatteries = value;
    }

    public Boolean getDefAllowScanWithoutLogin() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowScanWithoutLogin() {
        return this.allowScanWithoutLogin;
    }

    public void setOptAllowScanWithoutLogin(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowScanWithoutLogin = value;
    }

    public Boolean getDefNotificationWhenLoggedOff() {
        return Boolean.TRUE;
    }

    public Boolean getOptNotificationWhenLoggedOff() {
        return this.notificationWhenLoggedOff;
    }

    public void setOptNotificationWhenLoggedOff(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.notificationWhenLoggedOff = value;
    }

    public Boolean getDefRunStartupScanOnLogin() {
        return Boolean.FALSE;
    }

    public Boolean getOptRunStartupScanOnLogin() {
        return this.runStartupScanOnLogin;
    }

    public void setOptRunStartupScanOnLogin(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.runStartupScanOnLogin = value;
    }

    public Boolean getDefAllowUserModifyStartupScans() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowUserModifyStartupScans() {
        return this.allowUserModifyStartupScans;
    }

    public void setOptAllowUserModifyStartupScans(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowUserModifyStartupScans = value;
    }

    public Boolean getDefRunQuickScanOnNewDefs() {
        return Boolean.FALSE;
    }

    public Boolean getOptRunQuickScanOnNewDefs() {
        return this.runQuickScanOnNewDefs;
    }

    public void setOptRunQuickScanOnNewDefs(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.runQuickScanOnNewDefs = value;
    }

    public ScanProgressOptions getScanProgressOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(676);
        if (childGroup.size() > 0) {
            return (ScanProgressOptions)childGroup.get(0);
        }
        return null;
    }

    public void setScanProgressOptions(ScanProgressOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ScanProgressOptions obj = this.getScanProgressOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 675;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getScanProgressOptions() == null) {
            throw new ValidationException("AvScanSettings/ScanProgressOptions: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ScanProgressOptions) {
            try {
                this.setScanProgressOptions((ScanProgressOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DelayScanWhenRunningOnBatteries");
            if (value != null) {
                this.delayScanWhenRunningOnBatteries = "1".equals(value);
            }
            if ((value = attris.getValue("AllowScanWithoutLogin")) != null) {
                this.allowScanWithoutLogin = "1".equals(value);
            }
            if ((value = attris.getValue("NotificationWhenLoggedOff")) != null) {
                this.notificationWhenLoggedOff = "1".equals(value);
            }
            if ((value = attris.getValue("RunStartupScanOnLogin")) != null) {
                this.runStartupScanOnLogin = "1".equals(value);
            }
            if ((value = attris.getValue("AllowUserModifyStartupScans")) != null) {
                this.allowUserModifyStartupScans = "1".equals(value);
            }
            if ((value = attris.getValue("RunQuickScanOnNewDefs")) != null) {
                this.runQuickScanOnNewDefs = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getScanProgressOptions() != null) {
            this.getScanProgressOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(676)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AvScanSettings: can't import element == ScanProgressOptions!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AvScanSettings".equals(element.getNodeName())) {
            throw new ValidationException("AvScanSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DelayScanWhenRunningOnBatteries");
        if (value != null) {
            this.delayScanWhenRunningOnBatteries = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowScanWithoutLogin")) != null) {
            this.allowScanWithoutLogin = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NotificationWhenLoggedOff")) != null) {
            this.notificationWhenLoggedOff = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RunStartupScanOnLogin")) != null) {
            this.runStartupScanOnLogin = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowUserModifyStartupScans")) != null) {
            this.allowUserModifyStartupScans = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RunQuickScanOnNewDefs")) != null) {
            this.runQuickScanOnNewDefs = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ScanProgressOptions")).size() != 1) {
            throw new ValidationException("AvScanSettings/ScanProgressOptions: element is require!");
        }
        ScanProgressOptions scanProgressOptionsObj = new ScanProgressOptions();
        scanProgressOptionsObj.importFromElement(v.get(0));
        this.setScanProgressOptions(scanProgressOptionsObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AvScanSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AvScanSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AvScanSettings");
        if (this.delayScanWhenRunningOnBatteries != null) {
            element.setAttribute("DelayScanWhenRunningOnBatteries", this.delayScanWhenRunningOnBatteries != false ? "1" : "0");
        }
        if (this.allowScanWithoutLogin != null) {
            element.setAttribute("AllowScanWithoutLogin", this.allowScanWithoutLogin != false ? "1" : "0");
        }
        if (this.notificationWhenLoggedOff != null) {
            element.setAttribute("NotificationWhenLoggedOff", this.notificationWhenLoggedOff != false ? "1" : "0");
        }
        if (this.runStartupScanOnLogin != null) {
            element.setAttribute("RunStartupScanOnLogin", this.runStartupScanOnLogin != false ? "1" : "0");
        }
        if (this.allowUserModifyStartupScans != null) {
            element.setAttribute("AllowUserModifyStartupScans", this.allowUserModifyStartupScans != false ? "1" : "0");
        }
        if (this.runQuickScanOnNewDefs != null) {
            element.setAttribute("RunQuickScanOnNewDefs", this.runQuickScanOnNewDefs != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AvScanSettings ");
            if (this.delayScanWhenRunningOnBatteries != null) {
                strAttrs.append("DelayScanWhenRunningOnBatteries=").append(this.delayScanWhenRunningOnBatteries != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowScanWithoutLogin != null) {
                strAttrs.append("AllowScanWithoutLogin=").append(this.allowScanWithoutLogin != false ? "\"1\" " : "\"0\" ");
            }
            if (this.notificationWhenLoggedOff != null) {
                strAttrs.append("NotificationWhenLoggedOff=").append(this.notificationWhenLoggedOff != false ? "\"1\" " : "\"0\" ");
            }
            if (this.runStartupScanOnLogin != null) {
                strAttrs.append("RunStartupScanOnLogin=").append(this.runStartupScanOnLogin != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowUserModifyStartupScans != null) {
                strAttrs.append("AllowUserModifyStartupScans=").append(this.allowUserModifyStartupScans != false ? "\"1\" " : "\"0\" ");
            }
            if (this.runQuickScanOnNewDefs != null) {
                strAttrs.append("RunQuickScanOnNewDefs=").append(this.runQuickScanOnNewDefs != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AvScanSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

