/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AvVirusDefOptions;
import com.sygate.scm.common.configobject.schema.GeneralInfo;
import com.sygate.scm.common.configobject.schema.LogHandling;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AvGeneral
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public AvGeneral() {
        this(true);
    }

    public AvGeneral(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(587, new ChildGroup(1, 1));
        this.children.put(588, new ChildGroup(1, 1));
        this.children.put(590, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AvGeneral";
    }

    public GeneralInfo getGeneralInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(587);
        if (childGroup.size() > 0) {
            return (GeneralInfo)childGroup.get(0);
        }
        return null;
    }

    public void setGeneralInfo(GeneralInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            GeneralInfo obj = this.getGeneralInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LogHandling getLogHandling() {
        ChildGroup childGroup = (ChildGroup)this.children.get(588);
        if (childGroup.size() > 0) {
            return (LogHandling)childGroup.get(0);
        }
        return null;
    }

    public void setLogHandling(LogHandling value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LogHandling obj = this.getLogHandling();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AvVirusDefOptions getAvVirusDefOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(590);
        if (childGroup.size() > 0) {
            return (AvVirusDefOptions)childGroup.get(0);
        }
        return null;
    }

    public void setAvVirusDefOptions(AvVirusDefOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AvVirusDefOptions obj = this.getAvVirusDefOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 585;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getGeneralInfo() == null) {
            throw new ValidationException("AvGeneral/GeneralInfo: attribute is required!");
        }
        if (this.getLogHandling() == null) {
            throw new ValidationException("AvGeneral/LogHandling: attribute is required!");
        }
        if (this.getAvVirusDefOptions() == null) {
            throw new ValidationException("AvGeneral/AvVirusDefOptions: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof GeneralInfo) {
            try {
                this.setGeneralInfo((GeneralInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LogHandling) {
            try {
                this.setLogHandling((LogHandling)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AvVirusDefOptions) {
            try {
                this.setAvVirusDefOptions((AvVirusDefOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getGeneralInfo() != null) {
            this.getGeneralInfo().setReadonly();
        }
        if (this.getLogHandling() != null) {
            this.getLogHandling().setReadonly();
        }
        if (this.getAvVirusDefOptions() != null) {
            this.getAvVirusDefOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(587)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AvGeneral: can't import element == GeneralInfo!");
        }
        try {
            ((ChildGroup)this.children.get(588)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AvGeneral: can't import element == LogHandling!");
        }
        try {
            ((ChildGroup)this.children.get(590)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AvGeneral: can't import element == AvVirusDefOptions!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"AvGeneral".equals(element.getNodeName())) {
            throw new ValidationException("AvGeneral: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "GeneralInfo");
        if (v.size() != 1) {
            throw new ValidationException("AvGeneral/GeneralInfo: element is require!");
        }
        GeneralInfo generalInfoObj = new GeneralInfo();
        generalInfoObj.importFromElement(v.get(0));
        this.setGeneralInfo(generalInfoObj);
        v = XMLHelper.getChildElementByName(element, "LogHandling");
        if (v.size() != 1) {
            throw new ValidationException("AvGeneral/LogHandling: element is require!");
        }
        LogHandling logHandlingObj = new LogHandling();
        logHandlingObj.importFromElement(v.get(0));
        this.setLogHandling(logHandlingObj);
        v = XMLHelper.getChildElementByName(element, "AvVirusDefOptions");
        if (v.size() != 1) {
            throw new ValidationException("AvGeneral/AvVirusDefOptions: element is require!");
        }
        AvVirusDefOptions avVirusDefOptionsObj = new AvVirusDefOptions();
        avVirusDefOptionsObj.importFromElement(v.get(0));
        this.setAvVirusDefOptions(avVirusDefOptionsObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AvGeneral/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AvGeneral/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AvGeneral");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AvGeneral ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AvGeneral>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

