/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.EnableAutoLocationSwitching;
import com.sygate.scm.common.configobject.schema.LocationArray;
import com.sygate.scm.common.configobject.schema.LocationChangeNotification;
import com.sygate.scm.common.configobject.schema.RememberLastLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AutoLocation
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer locationCheckFrequency;
    private String commandToRun;

    public AutoLocation() {
        this(true);
    }

    public AutoLocation(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(245, new ChildGroup(1, 1));
        this.children.put(243, new ChildGroup(0, 1));
        this.children.put(244, new ChildGroup(0, 1));
        this.children.put(242, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AutoLocation";
    }

    public Integer getDefLocationCheckFrequency() {
        return 30;
    }

    public Integer getOptLocationCheckFrequency() {
        return this.locationCheckFrequency;
    }

    public void setOptLocationCheckFrequency(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.locationCheckFrequency = value;
    }

    public String getOptCommandToRun() {
        return this.commandToRun;
    }

    public void setOptCommandToRun(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.commandToRun = value;
    }

    public LocationArray getLocationArray() {
        ChildGroup childGroup = (ChildGroup)this.children.get(245);
        if (childGroup.size() > 0) {
            return (LocationArray)childGroup.get(0);
        }
        return null;
    }

    public void setLocationArray(LocationArray value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LocationArray obj = this.getLocationArray();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public EnableAutoLocationSwitching getOptEnableAutoLocationSwitching() {
        ChildGroup childGroup = (ChildGroup)this.children.get(243);
        if (childGroup.size() > 0) {
            return (EnableAutoLocationSwitching)childGroup.get(0);
        }
        return null;
    }

    public void setOptEnableAutoLocationSwitching(EnableAutoLocationSwitching value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            EnableAutoLocationSwitching obj = this.getOptEnableAutoLocationSwitching();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public RememberLastLocation getOptRememberLastLocation() {
        ChildGroup childGroup = (ChildGroup)this.children.get(244);
        if (childGroup.size() > 0) {
            return (RememberLastLocation)childGroup.get(0);
        }
        return null;
    }

    public void setOptRememberLastLocation(RememberLastLocation value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            RememberLastLocation obj = this.getOptRememberLastLocation();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LocationChangeNotification getOptLocationChangeNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(242);
        if (childGroup.size() > 0) {
            return (LocationChangeNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptLocationChangeNotification(LocationChangeNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LocationChangeNotification obj = this.getOptLocationChangeNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 241;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getLocationArray() == null) {
            throw new ValidationException("AutoLocation/LocationArray: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LocationArray) {
            try {
                this.setLocationArray((LocationArray)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof EnableAutoLocationSwitching) {
            try {
                this.setOptEnableAutoLocationSwitching((EnableAutoLocationSwitching)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RememberLastLocation) {
            try {
                this.setOptRememberLastLocation((RememberLastLocation)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LocationChangeNotification) {
            try {
                this.setOptLocationChangeNotification((LocationChangeNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("LocationCheckFrequency");
            if (value != null) {
                try {
                    this.locationCheckFrequency = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AutoLocation/LocationCheckFrequency: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AutoLocation/LocationCheckFrequency: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("CommandToRun")) != null) {
                this.commandToRun = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getLocationArray() != null) {
            this.getLocationArray().setReadonly();
        }
        if (this.getOptEnableAutoLocationSwitching() != null) {
            this.getOptEnableAutoLocationSwitching().setReadonly();
        }
        if (this.getOptRememberLastLocation() != null) {
            this.getOptRememberLastLocation().setReadonly();
        }
        if (this.getOptLocationChangeNotification() != null) {
            this.getOptLocationChangeNotification().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(245)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AutoLocation: can't import element == LocationArray!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AutoLocation".equals(element.getNodeName())) {
            throw new ValidationException("AutoLocation: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "LocationCheckFrequency");
        if (value != null) {
            try {
                this.locationCheckFrequency = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AutoLocation/LocationCheckFrequency: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "CommandToRun")) != null) {
            this.commandToRun = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "LocationArray")).size() != 1) {
            throw new ValidationException("AutoLocation/LocationArray: element is require!");
        }
        LocationArray locationArrayObj = new LocationArray();
        locationArrayObj.importFromElement(v.get(0));
        this.setLocationArray(locationArrayObj);
        v = XMLHelper.getChildElementByName(element, "EnableAutoLocationSwitching");
        if (v.size() > 0) {
            EnableAutoLocationSwitching enableAutoLocationSwitchingObj = new EnableAutoLocationSwitching();
            enableAutoLocationSwitchingObj.importFromElement(v.get(0));
            this.setOptEnableAutoLocationSwitching(enableAutoLocationSwitchingObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "RememberLastLocation")).size() > 0) {
            RememberLastLocation rememberLastLocationObj = new RememberLastLocation();
            rememberLastLocationObj.importFromElement(v.get(0));
            this.setOptRememberLastLocation(rememberLastLocationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LocationChangeNotification")).size() > 0) {
            LocationChangeNotification locationChangeNotificationObj = new LocationChangeNotification();
            locationChangeNotificationObj.importFromElement(v.get(0));
            this.setOptLocationChangeNotification(locationChangeNotificationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AutoLocation/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AutoLocation/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AutoLocation");
        if (this.locationCheckFrequency != null) {
            element.setAttribute("LocationCheckFrequency", this.locationCheckFrequency.toString());
        }
        if (this.commandToRun != null) {
            element.setAttribute("CommandToRun", this.commandToRun);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AutoLocation ");
            if (this.locationCheckFrequency != null) {
                strAttrs.append("LocationCheckFrequency=\"").append(this.locationCheckFrequency.toString()).append("\" ");
            }
            if (this.commandToRun != null) {
                strAttrs.append("CommandToRun=\"").append(AbstractSchema.checkXMLContent(this.commandToRun)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AutoLocation>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

