/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.Event;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ApplicationEventFilter
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String filterName;
    private Long filterDate;
    private Boolean anyApplication;
    private Boolean includeApplication;
    private String applicationPrefixVariable;
    private String applicationName;
    private Boolean anyTarget;
    private Boolean includeTarget;
    private String targetPrefixVariable;
    private String targetName;
    private Boolean anyEvent;

    public ApplicationEventFilter() {
        this(true);
    }

    public ApplicationEventFilter(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(695, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ApplicationEventFilter";
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.filterName = value;
    }

    public Long getOptFilterDate() {
        return this.filterDate;
    }

    public void setOptFilterDate(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.filterDate = value;
    }

    public Boolean getDefAnyApplication() {
        return Boolean.FALSE;
    }

    public Boolean getAnyApplication() {
        return this.anyApplication;
    }

    public void setAnyApplication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.anyApplication = value;
    }

    public Boolean getDefIncludeApplication() {
        return Boolean.FALSE;
    }

    public Boolean getOptIncludeApplication() {
        return this.includeApplication;
    }

    public void setOptIncludeApplication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.includeApplication = value;
    }

    public String getOptApplicationPrefixVariable() {
        return this.applicationPrefixVariable;
    }

    public void setOptApplicationPrefixVariable(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.applicationPrefixVariable = value;
    }

    public String getOptApplicationName() {
        return this.applicationName;
    }

    public void setOptApplicationName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.applicationName = value;
    }

    public Boolean getDefAnyTarget() {
        return Boolean.FALSE;
    }

    public Boolean getAnyTarget() {
        return this.anyTarget;
    }

    public void setAnyTarget(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.anyTarget = value;
    }

    public Boolean getDefIncludeTarget() {
        return Boolean.FALSE;
    }

    public Boolean getOptIncludeTarget() {
        return this.includeTarget;
    }

    public void setOptIncludeTarget(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.includeTarget = value;
    }

    public String getOptTargetPrefixVariable() {
        return this.targetPrefixVariable;
    }

    public void setOptTargetPrefixVariable(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetPrefixVariable = value;
    }

    public String getOptTargetName() {
        return this.targetName;
    }

    public void setOptTargetName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetName = value;
    }

    public Boolean getDefAnyEvent() {
        return Boolean.FALSE;
    }

    public Boolean getAnyEvent() {
        return this.anyEvent;
    }

    public void setAnyEvent(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.anyEvent = value;
    }

    public void addEvent(Event value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addEvent(int index, Event value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Event> getEvent() {
        Vector<Event> v = new Vector<Event>();
        for (Transportable child : (ChildGroup)this.children.get(695)) {
            v.add((Event)child);
        }
        return v;
    }

    public int getEventCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(695);
        return childGroup.size();
    }

    public Event getEvent(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(695);
        return (Event)childGroup.get(index);
    }

    public void setEvent(int index, Event value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeEvent(Event value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 693;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.filterName == null) {
            throw new ValidationException("ApplicationEventFilter/FilterName: attribute is required!");
        }
        if (this.anyApplication == null) {
            throw new ValidationException("ApplicationEventFilter/AnyApplication: attribute is required!");
        }
        if (this.anyTarget == null) {
            throw new ValidationException("ApplicationEventFilter/AnyTarget: attribute is required!");
        }
        if (this.anyEvent == null) {
            throw new ValidationException("ApplicationEventFilter/AnyEvent: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof Event) {
            try {
                this.addEvent((Event)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("FilterName");
            if (value == null) {
                throw new ValidationException("ApplicationEventFilter/FilterName: attribute is required!");
            }
            this.filterName = value;
            value = attris.getValue("FilterDate");
            if (value != null) {
                try {
                    this.filterDate = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ApplicationEventFilter/FilterDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ApplicationEventFilter/FilterDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("AnyApplication")) == null) {
                throw new ValidationException("ApplicationEventFilter/AnyApplication: attribute is required!");
            }
            this.anyApplication = "1".equals(value);
            value = attris.getValue("IncludeApplication");
            if (value != null) {
                this.includeApplication = "1".equals(value);
            }
            if ((value = attris.getValue("ApplicationPrefixVariable")) != null) {
                this.applicationPrefixVariable = value;
            }
            if ((value = attris.getValue("ApplicationName")) != null) {
                this.applicationName = value;
            }
            if ((value = attris.getValue("AnyTarget")) == null) {
                throw new ValidationException("ApplicationEventFilter/AnyTarget: attribute is required!");
            }
            this.anyTarget = "1".equals(value);
            value = attris.getValue("IncludeTarget");
            if (value != null) {
                this.includeTarget = "1".equals(value);
            }
            if ((value = attris.getValue("TargetPrefixVariable")) != null) {
                this.targetPrefixVariable = value;
            }
            if ((value = attris.getValue("TargetName")) != null) {
                this.targetName = value;
            }
            if ((value = attris.getValue("AnyEvent")) == null) {
                throw new ValidationException("ApplicationEventFilter/AnyEvent: attribute is required!");
            }
            this.anyEvent = "1".equals(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getEventCount();
        for (i = 0; i < objCnt; ++i) {
            this.getEvent(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ApplicationEventFilter".equals(element.getNodeName())) {
            throw new ValidationException("ApplicationEventFilter: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "FilterName");
        if (value == null) {
            throw new ValidationException("ApplicationEventFilter/FilterName: attribute is required!");
        }
        this.filterName = value;
        value = XMLHelper.getAttribute(element, "FilterDate");
        if (value != null) {
            try {
                this.filterDate = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ApplicationEventFilter/FilterDate: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AnyApplication")) == null) {
            throw new ValidationException("ApplicationEventFilter/AnyApplication: attribute is required!");
        }
        this.anyApplication = "1".equals(value);
        value = XMLHelper.getAttribute(element, "IncludeApplication");
        if (value != null) {
            this.includeApplication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ApplicationPrefixVariable")) != null) {
            this.applicationPrefixVariable = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ApplicationName")) != null) {
            this.applicationName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AnyTarget")) == null) {
            throw new ValidationException("ApplicationEventFilter/AnyTarget: attribute is required!");
        }
        this.anyTarget = "1".equals(value);
        value = XMLHelper.getAttribute(element, "IncludeTarget");
        if (value != null) {
            this.includeTarget = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TargetPrefixVariable")) != null) {
            this.targetPrefixVariable = value;
        }
        if ((value = XMLHelper.getAttribute(element, "TargetName")) != null) {
            this.targetName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AnyEvent")) == null) {
            throw new ValidationException("ApplicationEventFilter/AnyEvent: attribute is required!");
        }
        this.anyEvent = "1".equals(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "Event");
        for (int i = 0; i < v.size(); ++i) {
            Event eventObj = new Event();
            eventObj.importFromElement(v.get(i));
            this.addEvent(eventObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ApplicationEventFilter/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ApplicationEventFilter/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ApplicationEventFilter");
        if (this.filterName != null) {
            element.setAttribute("FilterName", this.filterName);
        }
        if (this.filterDate != null) {
            element.setAttribute("FilterDate", this.filterDate.toString());
        }
        if (this.anyApplication != null) {
            element.setAttribute("AnyApplication", this.anyApplication != false ? "1" : "0");
        }
        if (this.includeApplication != null) {
            element.setAttribute("IncludeApplication", this.includeApplication != false ? "1" : "0");
        }
        if (this.applicationPrefixVariable != null) {
            element.setAttribute("ApplicationPrefixVariable", this.applicationPrefixVariable);
        }
        if (this.applicationName != null) {
            element.setAttribute("ApplicationName", this.applicationName);
        }
        if (this.anyTarget != null) {
            element.setAttribute("AnyTarget", this.anyTarget != false ? "1" : "0");
        }
        if (this.includeTarget != null) {
            element.setAttribute("IncludeTarget", this.includeTarget != false ? "1" : "0");
        }
        if (this.targetPrefixVariable != null) {
            element.setAttribute("TargetPrefixVariable", this.targetPrefixVariable);
        }
        if (this.targetName != null) {
            element.setAttribute("TargetName", this.targetName);
        }
        if (this.anyEvent != null) {
            element.setAttribute("AnyEvent", this.anyEvent != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ApplicationEventFilter ");
            if (this.filterName != null) {
                strAttrs.append("FilterName=\"").append(AbstractSchema.checkXMLContent(this.filterName)).append("\" ");
            }
            if (this.filterDate != null) {
                strAttrs.append("FilterDate=\"").append(this.filterDate.toString()).append("\" ");
            }
            if (this.anyApplication != null) {
                strAttrs.append("AnyApplication=").append(this.anyApplication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.includeApplication != null) {
                strAttrs.append("IncludeApplication=").append(this.includeApplication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.applicationPrefixVariable != null) {
                strAttrs.append("ApplicationPrefixVariable=\"").append(AbstractSchema.checkXMLContent(this.applicationPrefixVariable)).append("\" ");
            }
            if (this.applicationName != null) {
                strAttrs.append("ApplicationName=\"").append(AbstractSchema.checkXMLContent(this.applicationName)).append("\" ");
            }
            if (this.anyTarget != null) {
                strAttrs.append("AnyTarget=").append(this.anyTarget != false ? "\"1\" " : "\"0\" ");
            }
            if (this.includeTarget != null) {
                strAttrs.append("IncludeTarget=").append(this.includeTarget != false ? "\"1\" " : "\"0\" ");
            }
            if (this.targetPrefixVariable != null) {
                strAttrs.append("TargetPrefixVariable=\"").append(AbstractSchema.checkXMLContent(this.targetPrefixVariable)).append("\" ");
            }
            if (this.targetName != null) {
                strAttrs.append("TargetName=\"").append(AbstractSchema.checkXMLContent(this.targetName)).append("\" ");
            }
            if (this.anyEvent != null) {
                strAttrs.append("AnyEvent=").append(this.anyEvent != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ApplicationEventFilter>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

