/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AppAuthenticationProtection
extends ConfigObject {
    public static final Integer ALLOW = 0;
    public static final Integer ASK = 1;
    public static final Integer DISALLOW = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean enableDllAuthentication;
    private Integer action;
    private String additionalText;
    private Boolean allowNewDll;
    private Boolean allowDllChange;
    private Boolean allowKnownNewDll;

    public AppAuthenticationProtection() {
        this(true);
    }

    public AppAuthenticationProtection(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(281, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AppAuthenticationProtection";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefEnableDllAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableDllAuthentication() {
        return this.enableDllAuthentication;
    }

    public void setOptEnableDllAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableDllAuthentication = value;
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "ALLOW";
                break;
            }
            case 1: {
                s = "ASK";
                break;
            }
            case 2: {
                s = "DISALLOW";
                break;
            }
            default: {
                throw new ValidationException("AppAuthenticationProtection/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ALLOW".equals(value)) {
            this.action = ALLOW;
        } else if ("ASK".equals(value)) {
            this.action = ASK;
        } else if ("DISALLOW".equals(value)) {
            this.action = DISALLOW;
        } else {
            throw new ValidationException("AppAuthenticationProtection/Action: invalid attribute value:" + value + "!");
        }
    }

    public String getOptAdditionalText() {
        return this.additionalText;
    }

    public void setOptAdditionalText(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.additionalText = value;
    }

    public Boolean getDefAllowNewDll() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowNewDll() {
        return this.allowNewDll;
    }

    public void setOptAllowNewDll(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowNewDll = value;
    }

    public Boolean getDefAllowDllChange() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowDllChange() {
        return this.allowDllChange;
    }

    public void setOptAllowDllChange(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowDllChange = value;
    }

    public Boolean getDefAllowKnownNewDll() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowKnownNewDll() {
        return this.allowKnownNewDll;
    }

    public void setOptAllowKnownNewDll(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowKnownNewDll = value;
    }

    public ExcludedAppArray getExcludedAppArray() {
        ChildGroup childGroup = (ChildGroup)this.children.get(281);
        if (childGroup.size() > 0) {
            return (ExcludedAppArray)childGroup.get(0);
        }
        return null;
    }

    public void setExcludedAppArray(ExcludedAppArray value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ExcludedAppArray obj = this.getExcludedAppArray();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 280;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
        }
        if (this.getExcludedAppArray() == null) {
            throw new ValidationException("AppAuthenticationProtection/ExcludedAppArray: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ExcludedAppArray) {
            try {
                this.setExcludedAppArray((ExcludedAppArray)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("EnableDllAuthentication")) != null) {
                this.enableDllAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("Action")) == null) {
                throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("AdditionalText");
            if (value != null) {
                this.additionalText = value;
            }
            if ((value = attris.getValue("AllowNewDll")) != null) {
                this.allowNewDll = "1".equals(value);
            }
            if ((value = attris.getValue("AllowDllChange")) != null) {
                this.allowDllChange = "1".equals(value);
            }
            if ((value = attris.getValue("AllowKnownNewDll")) != null) {
                this.allowKnownNewDll = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getExcludedAppArray() != null) {
            this.getExcludedAppArray().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(281)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AppAuthenticationProtection: can't import element == ExcludedAppArray!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AppAuthenticationProtection".equals(element.getNodeName())) {
            throw new ValidationException("AppAuthenticationProtection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableDllAuthentication")) != null) {
            this.enableDllAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) == null) {
            throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "AdditionalText");
        if (value != null) {
            this.additionalText = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowNewDll")) != null) {
            this.allowNewDll = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowDllChange")) != null) {
            this.allowDllChange = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowKnownNewDll")) != null) {
            this.allowKnownNewDll = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ExcludedAppArray")).size() != 1) {
            throw new ValidationException("AppAuthenticationProtection/ExcludedAppArray: element is require!");
        }
        ExcludedAppArray excludedAppArrayObj = new ExcludedAppArray();
        excludedAppArrayObj.importFromElement(v.get(0));
        this.setExcludedAppArray(excludedAppArrayObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AppAuthenticationProtection/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AppAuthenticationProtection/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AppAuthenticationProtection");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.enableDllAuthentication != null) {
            element.setAttribute("EnableDllAuthentication", this.enableDllAuthentication != false ? "1" : "0");
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.additionalText != null) {
            element.setAttribute("AdditionalText", this.additionalText);
        }
        if (this.allowNewDll != null) {
            element.setAttribute("AllowNewDll", this.allowNewDll != false ? "1" : "0");
        }
        if (this.allowDllChange != null) {
            element.setAttribute("AllowDllChange", this.allowDllChange != false ? "1" : "0");
        }
        if (this.allowKnownNewDll != null) {
            element.setAttribute("AllowKnownNewDll", this.allowKnownNewDll != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AppAuthenticationProtection ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableDllAuthentication != null) {
                strAttrs.append("EnableDllAuthentication=").append(this.enableDllAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.additionalText != null) {
                strAttrs.append("AdditionalText=\"").append(AbstractSchema.checkXMLContent(this.additionalText)).append("\" ");
            }
            if (this.allowNewDll != null) {
                strAttrs.append("AllowNewDll=").append(this.allowNewDll != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowDllChange != null) {
                strAttrs.append("AllowDllChange=").append(this.allowDllChange != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowKnownNewDll != null) {
                strAttrs.append("AllowKnownNewDll=").append(this.allowKnownNewDll != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AppAuthenticationProtection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

