/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.WebMailHeuristics;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ApWebMailAdvancedOptions
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer pop3Port;
    private Integer smtpPort;
    private Boolean allowEncryptedPop3Connections;
    private Boolean allowEncryptedSMTPConnections;
    private Boolean lockMailServerPorts;
    private Boolean lockAllowEncryptedPop3Connections;
    private Boolean lockAllowEncryptedSMTPConnections;

    public ApWebMailAdvancedOptions() {
        this(true);
    }

    public ApWebMailAdvancedOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(636, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ApWebMailAdvancedOptions";
    }

    public Integer getDefPop3Port() {
        return 110;
    }

    public Integer getOptPop3Port() {
        return this.pop3Port;
    }

    public void setOptPop3Port(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pop3Port = value;
    }

    public Integer getDefSmtpPort() {
        return 25;
    }

    public Integer getOptSmtpPort() {
        return this.smtpPort;
    }

    public void setOptSmtpPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smtpPort = value;
    }

    public Boolean getDefAllowEncryptedPop3Connections() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowEncryptedPop3Connections() {
        return this.allowEncryptedPop3Connections;
    }

    public void setOptAllowEncryptedPop3Connections(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowEncryptedPop3Connections = value;
    }

    public Boolean getDefAllowEncryptedSMTPConnections() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowEncryptedSMTPConnections() {
        return this.allowEncryptedSMTPConnections;
    }

    public void setOptAllowEncryptedSMTPConnections(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowEncryptedSMTPConnections = value;
    }

    public Boolean getDefLockMailServerPorts() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockMailServerPorts() {
        return this.lockMailServerPorts;
    }

    public void setOptLockMailServerPorts(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockMailServerPorts = value;
    }

    public Boolean getDefLockAllowEncryptedPop3Connections() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockAllowEncryptedPop3Connections() {
        return this.lockAllowEncryptedPop3Connections;
    }

    public void setOptLockAllowEncryptedPop3Connections(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockAllowEncryptedPop3Connections = value;
    }

    public Boolean getDefLockAllowEncryptedSMTPConnections() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockAllowEncryptedSMTPConnections() {
        return this.lockAllowEncryptedSMTPConnections;
    }

    public void setOptLockAllowEncryptedSMTPConnections(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockAllowEncryptedSMTPConnections = value;
    }

    public WebMailHeuristics getOptWebMailHeuristics() {
        ChildGroup childGroup = (ChildGroup)this.children.get(636);
        if (childGroup.size() > 0) {
            return (WebMailHeuristics)childGroup.get(0);
        }
        return null;
    }

    public void setOptWebMailHeuristics(WebMailHeuristics value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            WebMailHeuristics obj = this.getOptWebMailHeuristics();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 635;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof WebMailHeuristics) {
            try {
                this.setOptWebMailHeuristics((WebMailHeuristics)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Pop3Port");
            if (value != null) {
                try {
                    this.pop3Port = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ApWebMailAdvancedOptions/Pop3Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ApWebMailAdvancedOptions/Pop3Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SmtpPort")) != null) {
                try {
                    this.smtpPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ApWebMailAdvancedOptions/SmtpPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ApWebMailAdvancedOptions/SmtpPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("AllowEncryptedPop3Connections")) != null) {
                this.allowEncryptedPop3Connections = "1".equals(value);
            }
            if ((value = attris.getValue("AllowEncryptedSMTPConnections")) != null) {
                this.allowEncryptedSMTPConnections = "1".equals(value);
            }
            if ((value = attris.getValue("LockMailServerPorts")) != null) {
                this.lockMailServerPorts = "1".equals(value);
            }
            if ((value = attris.getValue("LockAllowEncryptedPop3Connections")) != null) {
                this.lockAllowEncryptedPop3Connections = "1".equals(value);
            }
            if ((value = attris.getValue("LockAllowEncryptedSMTPConnections")) != null) {
                this.lockAllowEncryptedSMTPConnections = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptWebMailHeuristics() != null) {
            this.getOptWebMailHeuristics().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ApWebMailAdvancedOptions".equals(element.getNodeName())) {
            throw new ValidationException("ApWebMailAdvancedOptions: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Pop3Port");
        if (value != null) {
            try {
                this.pop3Port = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ApWebMailAdvancedOptions/Pop3Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SmtpPort")) != null) {
            try {
                this.smtpPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ApWebMailAdvancedOptions/SmtpPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AllowEncryptedPop3Connections")) != null) {
            this.allowEncryptedPop3Connections = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowEncryptedSMTPConnections")) != null) {
            this.allowEncryptedSMTPConnections = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockMailServerPorts")) != null) {
            this.lockMailServerPorts = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockAllowEncryptedPop3Connections")) != null) {
            this.lockAllowEncryptedPop3Connections = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockAllowEncryptedSMTPConnections")) != null) {
            this.lockAllowEncryptedSMTPConnections = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "WebMailHeuristics")).size() > 0) {
            WebMailHeuristics webMailHeuristicsObj = new WebMailHeuristics();
            webMailHeuristicsObj.importFromElement(v.get(0));
            this.setOptWebMailHeuristics(webMailHeuristicsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ApWebMailAdvancedOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ApWebMailAdvancedOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ApWebMailAdvancedOptions");
        if (this.pop3Port != null) {
            element.setAttribute("Pop3Port", this.pop3Port.toString());
        }
        if (this.smtpPort != null) {
            element.setAttribute("SmtpPort", this.smtpPort.toString());
        }
        if (this.allowEncryptedPop3Connections != null) {
            element.setAttribute("AllowEncryptedPop3Connections", this.allowEncryptedPop3Connections != false ? "1" : "0");
        }
        if (this.allowEncryptedSMTPConnections != null) {
            element.setAttribute("AllowEncryptedSMTPConnections", this.allowEncryptedSMTPConnections != false ? "1" : "0");
        }
        if (this.lockMailServerPorts != null) {
            element.setAttribute("LockMailServerPorts", this.lockMailServerPorts != false ? "1" : "0");
        }
        if (this.lockAllowEncryptedPop3Connections != null) {
            element.setAttribute("LockAllowEncryptedPop3Connections", this.lockAllowEncryptedPop3Connections != false ? "1" : "0");
        }
        if (this.lockAllowEncryptedSMTPConnections != null) {
            element.setAttribute("LockAllowEncryptedSMTPConnections", this.lockAllowEncryptedSMTPConnections != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ApWebMailAdvancedOptions ");
            if (this.pop3Port != null) {
                strAttrs.append("Pop3Port=\"").append(this.pop3Port.toString()).append("\" ");
            }
            if (this.smtpPort != null) {
                strAttrs.append("SmtpPort=\"").append(this.smtpPort.toString()).append("\" ");
            }
            if (this.allowEncryptedPop3Connections != null) {
                strAttrs.append("AllowEncryptedPop3Connections=").append(this.allowEncryptedPop3Connections != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowEncryptedSMTPConnections != null) {
                strAttrs.append("AllowEncryptedSMTPConnections=").append(this.allowEncryptedSMTPConnections != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockMailServerPorts != null) {
                strAttrs.append("LockMailServerPorts=").append(this.lockMailServerPorts != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockAllowEncryptedPop3Connections != null) {
                strAttrs.append("LockAllowEncryptedPop3Connections=").append(this.lockAllowEncryptedPop3Connections != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockAllowEncryptedSMTPConnections != null) {
                strAttrs.append("LockAllowEncryptedSMTPConnections=").append(this.lockAllowEncryptedSMTPConnections != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ApWebMailAdvancedOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

