/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.FileListingDetails;
import com.sygate.scm.common.configobject.schema.FolderListingDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ApScanOptions
extends ConfigObject {
    public static final Integer DO_NOT_SCAN = 0;
    public static final Integer SCAN_EVERYWHERE = 1;
    public static final Integer SCAN_ONLY_IN = 2;
    public static final Integer SCAN_EXCEPT_IN = 3;
    private static final long serialVersionUID = 1L;
    private Integer whereToScanFiles;

    public ApScanOptions() {
        this(true);
    }

    public ApScanOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(598, new ChildGroup(0, 1));
        this.children.put(599, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ApScanOptions";
    }

    public Integer getDefWhereToScanFiles() {
        return SCAN_EVERYWHERE;
    }

    public Integer getWhereToScanFiles() {
        return this.whereToScanFiles;
    }

    public String getWhereToScanFilesValue() throws ValidationException {
        if (this.whereToScanFiles == null) {
            return null;
        }
        String s = null;
        switch (this.whereToScanFiles) {
            case 0: {
                s = "DO_NOT_SCAN";
                break;
            }
            case 1: {
                s = "SCAN_EVERYWHERE";
                break;
            }
            case 2: {
                s = "SCAN_ONLY_IN";
                break;
            }
            case 3: {
                s = "SCAN_EXCEPT_IN";
                break;
            }
            default: {
                throw new ValidationException("ApScanOptions/WhereToScanFiles: invalid attribute value:" + this.whereToScanFiles + "!");
            }
        }
        return s;
    }

    public void setWhereToScanFiles(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.whereToScanFiles = value;
    }

    public void setWhereToScanFilesValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("DO_NOT_SCAN".equals(value)) {
            this.whereToScanFiles = DO_NOT_SCAN;
        } else if ("SCAN_EVERYWHERE".equals(value)) {
            this.whereToScanFiles = SCAN_EVERYWHERE;
        } else if ("SCAN_ONLY_IN".equals(value)) {
            this.whereToScanFiles = SCAN_ONLY_IN;
        } else if ("SCAN_EXCEPT_IN".equals(value)) {
            this.whereToScanFiles = SCAN_EXCEPT_IN;
        } else {
            throw new ValidationException("ApScanOptions/WhereToScanFiles: invalid attribute value:" + value + "!");
        }
    }

    public FileListingDetails getOptFileListingDetails() {
        ChildGroup childGroup = (ChildGroup)this.children.get(598);
        if (childGroup.size() > 0) {
            return (FileListingDetails)childGroup.get(0);
        }
        return null;
    }

    public void setOptFileListingDetails(FileListingDetails value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FileListingDetails obj = this.getOptFileListingDetails();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public FolderListingDetails getOptFolderListingDetails() {
        ChildGroup childGroup = (ChildGroup)this.children.get(599);
        if (childGroup.size() > 0) {
            return (FolderListingDetails)childGroup.get(0);
        }
        return null;
    }

    public void setOptFolderListingDetails(FolderListingDetails value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FolderListingDetails obj = this.getOptFolderListingDetails();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 597;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.whereToScanFiles == null) {
            throw new ValidationException("ApScanOptions/WhereToScanFiles: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof FileListingDetails) {
            try {
                this.setOptFileListingDetails((FileListingDetails)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof FolderListingDetails) {
            try {
                this.setOptFolderListingDetails((FolderListingDetails)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("WhereToScanFiles");
            if (value == null) {
                throw new ValidationException("ApScanOptions/WhereToScanFiles: attribute is required!");
            }
            this.setWhereToScanFilesValue(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptFileListingDetails() != null) {
            this.getOptFileListingDetails().setReadonly();
        }
        if (this.getOptFolderListingDetails() != null) {
            this.getOptFolderListingDetails().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ApScanOptions".equals(element.getNodeName())) {
            throw new ValidationException("ApScanOptions: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "WhereToScanFiles");
        if (value == null) {
            throw new ValidationException("ApScanOptions/WhereToScanFiles: attribute is required!");
        }
        this.setWhereToScanFilesValue(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "FileListingDetails");
        if (v.size() > 0) {
            FileListingDetails fileListingDetailsObj = new FileListingDetails();
            fileListingDetailsObj.importFromElement(v.get(0));
            this.setOptFileListingDetails(fileListingDetailsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "FolderListingDetails")).size() > 0) {
            FolderListingDetails folderListingDetailsObj = new FolderListingDetails();
            folderListingDetailsObj.importFromElement(v.get(0));
            this.setOptFolderListingDetails(folderListingDetailsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ApScanOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ApScanOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ApScanOptions");
        if (this.whereToScanFiles != null) {
            element.setAttribute("WhereToScanFiles", this.getWhereToScanFilesValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ApScanOptions ");
            if (this.whereToScanFiles != null) {
                strAttrs.append("WhereToScanFiles=\"").append(this.getWhereToScanFilesValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ApScanOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

