/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.NotificationMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ApFileNotifications
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean displayNotification;
    private Boolean displayApResults;
    private Boolean lockDisplayNotification;
    private Boolean lockDisplayApResults;

    public ApFileNotifications() {
        this(true);
    }

    public ApFileNotifications(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(621, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ApFileNotifications";
    }

    public Boolean getDefDisplayNotification() {
        return Boolean.TRUE;
    }

    public Boolean getOptDisplayNotification() {
        return this.displayNotification;
    }

    public void setOptDisplayNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayNotification = value;
    }

    public Boolean getDefDisplayApResults() {
        return Boolean.TRUE;
    }

    public Boolean getOptDisplayApResults() {
        return this.displayApResults;
    }

    public void setOptDisplayApResults(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayApResults = value;
    }

    public Boolean getDefLockDisplayNotification() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDisplayNotification() {
        return this.lockDisplayNotification;
    }

    public void setOptLockDisplayNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDisplayNotification = value;
    }

    public Boolean getDefLockDisplayApResults() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDisplayApResults() {
        return this.lockDisplayApResults;
    }

    public void setOptLockDisplayApResults(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDisplayApResults = value;
    }

    public NotificationMessage getOptNotificationMessage() {
        ChildGroup childGroup = (ChildGroup)this.children.get(621);
        if (childGroup.size() > 0) {
            return (NotificationMessage)childGroup.get(0);
        }
        return null;
    }

    public void setOptNotificationMessage(NotificationMessage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NotificationMessage obj = this.getOptNotificationMessage();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 620;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof NotificationMessage) {
            try {
                this.setOptNotificationMessage((NotificationMessage)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DisplayNotification");
            if (value != null) {
                this.displayNotification = "1".equals(value);
            }
            if ((value = attris.getValue("DisplayApResults")) != null) {
                this.displayApResults = "1".equals(value);
            }
            if ((value = attris.getValue("LockDisplayNotification")) != null) {
                this.lockDisplayNotification = "1".equals(value);
            }
            if ((value = attris.getValue("LockDisplayApResults")) != null) {
                this.lockDisplayApResults = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptNotificationMessage() != null) {
            this.getOptNotificationMessage().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ApFileNotifications".equals(element.getNodeName())) {
            throw new ValidationException("ApFileNotifications: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DisplayNotification");
        if (value != null) {
            this.displayNotification = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayApResults")) != null) {
            this.displayApResults = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockDisplayNotification")) != null) {
            this.lockDisplayNotification = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockDisplayApResults")) != null) {
            this.lockDisplayApResults = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NotificationMessage")).size() > 0) {
            NotificationMessage notificationMessageObj = new NotificationMessage();
            notificationMessageObj.importFromElement(v.get(0));
            this.setOptNotificationMessage(notificationMessageObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ApFileNotifications/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ApFileNotifications/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ApFileNotifications");
        if (this.displayNotification != null) {
            element.setAttribute("DisplayNotification", this.displayNotification != false ? "1" : "0");
        }
        if (this.displayApResults != null) {
            element.setAttribute("DisplayApResults", this.displayApResults != false ? "1" : "0");
        }
        if (this.lockDisplayNotification != null) {
            element.setAttribute("LockDisplayNotification", this.lockDisplayNotification != false ? "1" : "0");
        }
        if (this.lockDisplayApResults != null) {
            element.setAttribute("LockDisplayApResults", this.lockDisplayApResults != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ApFileNotifications ");
            if (this.displayNotification != null) {
                strAttrs.append("DisplayNotification=").append(this.displayNotification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.displayApResults != null) {
                strAttrs.append("DisplayApResults=").append(this.displayApResults != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockDisplayNotification != null) {
                strAttrs.append("LockDisplayNotification=").append(this.lockDisplayNotification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockDisplayApResults != null) {
                strAttrs.append("LockDisplayApResults=").append(this.lockDisplayApResults != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ApFileNotifications>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

