/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ApAction
extends ConfigObject {
    public static final Integer QUARANTINE = 0;
    public static final Integer DELETE = 1;
    public static final Integer LOG_ONLY = 2;
    public static final Integer CLEAN = 3;
    private static final long serialVersionUID = 1L;
    private Integer firstAction;
    private Integer secondAction;
    private Boolean lockFirstAction;
    private Boolean lockSecondAction;

    public ApAction() {
        this(true);
    }

    public ApAction(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ApAction";
    }

    public Integer getFirstAction() {
        return this.firstAction;
    }

    public String getFirstActionValue() throws ValidationException {
        if (this.firstAction == null) {
            return null;
        }
        String s = null;
        switch (this.firstAction) {
            case 0: {
                s = "QUARANTINE";
                break;
            }
            case 1: {
                s = "DELETE";
                break;
            }
            case 2: {
                s = "LOG_ONLY";
                break;
            }
            case 3: {
                s = "CLEAN";
                break;
            }
            default: {
                throw new ValidationException("ApAction/FirstAction: invalid attribute value:" + this.firstAction + "!");
            }
        }
        return s;
    }

    public void setFirstAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.firstAction = value;
    }

    public void setFirstActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("QUARANTINE".equals(value)) {
            this.firstAction = QUARANTINE;
        } else if ("DELETE".equals(value)) {
            this.firstAction = DELETE;
        } else if ("LOG_ONLY".equals(value)) {
            this.firstAction = LOG_ONLY;
        } else if ("CLEAN".equals(value)) {
            this.firstAction = CLEAN;
        } else {
            throw new ValidationException("ApAction/FirstAction: invalid attribute value:" + value + "!");
        }
    }

    public Integer getSecondAction() {
        return this.secondAction;
    }

    public String getSecondActionValue() throws ValidationException {
        if (this.secondAction == null) {
            return null;
        }
        String s = null;
        switch (this.secondAction) {
            case 0: {
                s = "QUARANTINE";
                break;
            }
            case 1: {
                s = "DELETE";
                break;
            }
            case 2: {
                s = "LOG_ONLY";
                break;
            }
            case 3: {
                s = "CLEAN";
                break;
            }
            default: {
                throw new ValidationException("ApAction/SecondAction: invalid attribute value:" + this.secondAction + "!");
            }
        }
        return s;
    }

    public void setSecondAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.secondAction = value;
    }

    public void setSecondActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("QUARANTINE".equals(value)) {
            this.secondAction = QUARANTINE;
        } else if ("DELETE".equals(value)) {
            this.secondAction = DELETE;
        } else if ("LOG_ONLY".equals(value)) {
            this.secondAction = LOG_ONLY;
        } else if ("CLEAN".equals(value)) {
            this.secondAction = CLEAN;
        } else {
            throw new ValidationException("ApAction/SecondAction: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockFirstAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockFirstAction() {
        return this.lockFirstAction;
    }

    public void setOptLockFirstAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockFirstAction = value;
    }

    public Boolean getDefLockSecondAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockSecondAction() {
        return this.lockSecondAction;
    }

    public void setOptLockSecondAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockSecondAction = value;
    }

    @Override
    public int getObjectType() {
        return 619;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.firstAction == null) {
            throw new ValidationException("ApAction/FirstAction: attribute is required!");
        }
        if (this.secondAction == null) {
            throw new ValidationException("ApAction/SecondAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("FirstAction");
            if (value == null) {
                throw new ValidationException("ApAction/FirstAction: attribute is required!");
            }
            this.setFirstActionValue(value);
            value = attris.getValue("SecondAction");
            if (value == null) {
                throw new ValidationException("ApAction/SecondAction: attribute is required!");
            }
            this.setSecondActionValue(value);
            value = attris.getValue("LockFirstAction");
            if (value != null) {
                this.lockFirstAction = "1".equals(value);
            }
            if ((value = attris.getValue("LockSecondAction")) != null) {
                this.lockSecondAction = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ApAction".equals(element.getNodeName())) {
            throw new ValidationException("ApAction: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "FirstAction");
        if (value == null) {
            throw new ValidationException("ApAction/FirstAction: attribute is required!");
        }
        this.setFirstActionValue(value);
        value = XMLHelper.getAttribute(element, "SecondAction");
        if (value == null) {
            throw new ValidationException("ApAction/SecondAction: attribute is required!");
        }
        this.setSecondActionValue(value);
        value = XMLHelper.getAttribute(element, "LockFirstAction");
        if (value != null) {
            this.lockFirstAction = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockSecondAction")) != null) {
            this.lockSecondAction = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ApAction/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ApAction/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ApAction");
        if (this.firstAction != null) {
            element.setAttribute("FirstAction", this.getFirstActionValue());
        }
        if (this.secondAction != null) {
            element.setAttribute("SecondAction", this.getSecondActionValue());
        }
        if (this.lockFirstAction != null) {
            element.setAttribute("LockFirstAction", this.lockFirstAction != false ? "1" : "0");
        }
        if (this.lockSecondAction != null) {
            element.setAttribute("LockSecondAction", this.lockSecondAction != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ApAction ");
            if (this.firstAction != null) {
                strAttrs.append("FirstAction=\"").append(this.getFirstActionValue()).append("\" ");
            }
            if (this.secondAction != null) {
                strAttrs.append("SecondAction=\"").append(this.getSecondActionValue()).append("\" ");
            }
            if (this.lockFirstAction != null) {
                strAttrs.append("LockFirstAction=").append(this.lockFirstAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockSecondAction != null) {
                strAttrs.append("LockSecondAction=").append(this.lockSecondAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ApAction>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

