/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import com.sygate.scm.common.configobject.schema.StorageMigration;
import com.sygate.scm.common.configobject.schema.Throttling;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdvancedScanOptions
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public AdvancedScanOptions() {
        this(true);
    }

    public AdvancedScanOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(627, new ChildGroup(1, 1));
        this.children.put(672, new ChildGroup(1, 1));
        this.children.put(673, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdvancedScanOptions";
    }

    public CompressedFiles getCompressedFiles() {
        ChildGroup childGroup = (ChildGroup)this.children.get(627);
        if (childGroup.size() > 0) {
            return (CompressedFiles)childGroup.get(0);
        }
        return null;
    }

    public void setCompressedFiles(CompressedFiles value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CompressedFiles obj = this.getCompressedFiles();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public StorageMigration getStorageMigration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(672);
        if (childGroup.size() > 0) {
            return (StorageMigration)childGroup.get(0);
        }
        return null;
    }

    public void setStorageMigration(StorageMigration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            StorageMigration obj = this.getStorageMigration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Throttling getThrottling() {
        ChildGroup childGroup = (ChildGroup)this.children.get(673);
        if (childGroup.size() > 0) {
            return (Throttling)childGroup.get(0);
        }
        return null;
    }

    public void setThrottling(Throttling value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Throttling obj = this.getThrottling();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 671;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getCompressedFiles() == null) {
            throw new ValidationException("AdvancedScanOptions/CompressedFiles: attribute is required!");
        }
        if (this.getStorageMigration() == null) {
            throw new ValidationException("AdvancedScanOptions/StorageMigration: attribute is required!");
        }
        if (this.getThrottling() == null) {
            throw new ValidationException("AdvancedScanOptions/Throttling: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof CompressedFiles) {
            try {
                this.setCompressedFiles((CompressedFiles)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof StorageMigration) {
            try {
                this.setStorageMigration((StorageMigration)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Throttling) {
            try {
                this.setThrottling((Throttling)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getCompressedFiles() != null) {
            this.getCompressedFiles().setReadonly();
        }
        if (this.getStorageMigration() != null) {
            this.getStorageMigration().setReadonly();
        }
        if (this.getThrottling() != null) {
            this.getThrottling().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(627)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AdvancedScanOptions: can't import element == CompressedFiles!");
        }
        try {
            ((ChildGroup)this.children.get(672)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AdvancedScanOptions: can't import element == StorageMigration!");
        }
        try {
            ((ChildGroup)this.children.get(673)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AdvancedScanOptions: can't import element == Throttling!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"AdvancedScanOptions".equals(element.getNodeName())) {
            throw new ValidationException("AdvancedScanOptions: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "CompressedFiles");
        if (v.size() != 1) {
            throw new ValidationException("AdvancedScanOptions/CompressedFiles: element is require!");
        }
        CompressedFiles compressedFilesObj = new CompressedFiles();
        compressedFilesObj.importFromElement(v.get(0));
        this.setCompressedFiles(compressedFilesObj);
        v = XMLHelper.getChildElementByName(element, "StorageMigration");
        if (v.size() != 1) {
            throw new ValidationException("AdvancedScanOptions/StorageMigration: element is require!");
        }
        StorageMigration storageMigrationObj = new StorageMigration();
        storageMigrationObj.importFromElement(v.get(0));
        this.setStorageMigration(storageMigrationObj);
        v = XMLHelper.getChildElementByName(element, "Throttling");
        if (v.size() != 1) {
            throw new ValidationException("AdvancedScanOptions/Throttling: element is require!");
        }
        Throttling throttlingObj = new Throttling();
        throttlingObj.importFromElement(v.get(0));
        this.setThrottling(throttlingObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdvancedScanOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdvancedScanOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdvancedScanOptions");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdvancedScanOptions ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdvancedScanOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

