/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.NotificationState;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdministratorState
extends TopLevelObject {
    public static final Integer UNLOCKED = 0;
    public static final Integer LOCKED = 1;
    public static final Integer INACTIVE = 0;
    public static final Integer ACTIVE = 1;
    public static final Integer OFFLINE = 0;
    public static final Integer ONLINE = 1;
    public static final Integer NOT_READ = 0;
    public static final Integer READ = 1;
    public static final Integer DISMISSED = 2;
    private static final long serialVersionUID = 1L;
    private String id;
    private String ownerId;
    private Integer lockStatus;
    private Integer randomPasswordStatus;
    private Integer passwordStatus;
    private String resetPasswordTransactionID;
    private Long lockTime;
    private String lastLoginIpAddress;
    private Long lastLoginTime;
    private String lastLoginDomain;
    private Long lastLogoffTime;
    private Long lastCheckpointTime;
    private Integer onlineStatus;
    private Integer failedLoginAttemptNumber;
    private Integer failedPasswordVerificationAttemptNumber;
    private Long lastPasswordChangeTime;
    private Long consoleUsageCountThick;
    private Long consoleUsageCountPortal1;
    private Long consoleUsageCountPortal2;
    private Long consoleUsageCountSSO;
    private Long consoleUsageCountReporting;
    private Long consoleUsageCountElse;
    private Long riskWindowStartTime;
    private Integer lockDurationInMinutes;
    private Integer lockCountWithinRiskWindow;
    private Integer notifyLatestSepNews;

    public AdministratorState() {
        this(true);
    }

    public AdministratorState(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(204, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdministratorState";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.ownerId = value;
    }

    public Integer getOptLockStatus() {
        return this.lockStatus;
    }

    public String getOptLockStatusValue() throws ValidationException {
        if (this.lockStatus == null) {
            return null;
        }
        String s = null;
        switch (this.lockStatus) {
            case 0: {
                s = "UNLOCKED";
                break;
            }
            case 1: {
                s = "LOCKED";
                break;
            }
            default: {
                throw new ValidationException("AdministratorState/LockStatus: invalid attribute value:" + this.lockStatus + "!");
            }
        }
        return s;
    }

    public void setOptLockStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockStatus = value;
    }

    public void setOptLockStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.lockStatus = null;
            return;
        }
        if ("UNLOCKED".equals(value)) {
            this.lockStatus = UNLOCKED;
        } else if ("LOCKED".equals(value)) {
            this.lockStatus = LOCKED;
        } else {
            throw new ValidationException("AdministratorState/LockStatus: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRandomPasswordStatus() {
        return INACTIVE;
    }

    public Integer getOptRandomPasswordStatus() {
        return this.randomPasswordStatus;
    }

    public String getOptRandomPasswordStatusValue() throws ValidationException {
        if (this.randomPasswordStatus == null) {
            return null;
        }
        String s = null;
        switch (this.randomPasswordStatus) {
            case 0: {
                s = "INACTIVE";
                break;
            }
            case 1: {
                s = "ACTIVE";
                break;
            }
            default: {
                throw new ValidationException("AdministratorState/RandomPasswordStatus: invalid attribute value:" + this.randomPasswordStatus + "!");
            }
        }
        return s;
    }

    public void setOptRandomPasswordStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomPasswordStatus = value;
    }

    public void setOptRandomPasswordStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.randomPasswordStatus = null;
            return;
        }
        if ("INACTIVE".equals(value)) {
            this.randomPasswordStatus = INACTIVE;
        } else if ("ACTIVE".equals(value)) {
            this.randomPasswordStatus = ACTIVE;
        } else {
            throw new ValidationException("AdministratorState/RandomPasswordStatus: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefPasswordStatus() {
        return ACTIVE;
    }

    public Integer getOptPasswordStatus() {
        return this.passwordStatus;
    }

    public String getOptPasswordStatusValue() throws ValidationException {
        if (this.passwordStatus == null) {
            return null;
        }
        String s = null;
        switch (this.passwordStatus) {
            case 0: {
                s = "INACTIVE";
                break;
            }
            case 1: {
                s = "ACTIVE";
                break;
            }
            default: {
                throw new ValidationException("AdministratorState/PasswordStatus: invalid attribute value:" + this.passwordStatus + "!");
            }
        }
        return s;
    }

    public void setOptPasswordStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.passwordStatus = value;
    }

    public void setOptPasswordStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.passwordStatus = null;
            return;
        }
        if ("INACTIVE".equals(value)) {
            this.passwordStatus = INACTIVE;
        } else if ("ACTIVE".equals(value)) {
            this.passwordStatus = ACTIVE;
        } else {
            throw new ValidationException("AdministratorState/PasswordStatus: invalid attribute value:" + value + "!");
        }
    }

    public String getOptResetPasswordTransactionID() {
        return this.resetPasswordTransactionID;
    }

    public void setOptResetPasswordTransactionID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.resetPasswordTransactionID = value;
    }

    public Long getOptLockTime() {
        return this.lockTime;
    }

    public void setOptLockTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockTime = value;
    }

    public String getOptLastLoginIpAddress() {
        return this.lastLoginIpAddress;
    }

    public void setOptLastLoginIpAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastLoginIpAddress = value;
    }

    public Long getOptLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setOptLastLoginTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastLoginTime = value;
    }

    public String getOptLastLoginDomain() {
        return this.lastLoginDomain;
    }

    public void setOptLastLoginDomain(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastLoginDomain = value;
    }

    public Long getOptLastLogoffTime() {
        return this.lastLogoffTime;
    }

    public void setOptLastLogoffTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastLogoffTime = value;
    }

    public Long getOptLastCheckpointTime() {
        return this.lastCheckpointTime;
    }

    public void setOptLastCheckpointTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastCheckpointTime = value;
    }

    public Integer getDefOnlineStatus() {
        return OFFLINE;
    }

    public Integer getOptOnlineStatus() {
        return this.onlineStatus;
    }

    public String getOptOnlineStatusValue() throws ValidationException {
        if (this.onlineStatus == null) {
            return null;
        }
        String s = null;
        switch (this.onlineStatus) {
            case 0: {
                s = "OFFLINE";
                break;
            }
            case 1: {
                s = "ONLINE";
                break;
            }
            default: {
                throw new ValidationException("AdministratorState/OnlineStatus: invalid attribute value:" + this.onlineStatus + "!");
            }
        }
        return s;
    }

    public void setOptOnlineStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.onlineStatus = value;
    }

    public void setOptOnlineStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.onlineStatus = null;
            return;
        }
        if ("OFFLINE".equals(value)) {
            this.onlineStatus = OFFLINE;
        } else if ("ONLINE".equals(value)) {
            this.onlineStatus = ONLINE;
        } else {
            throw new ValidationException("AdministratorState/OnlineStatus: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptFailedLoginAttemptNumber() {
        return this.failedLoginAttemptNumber;
    }

    public void setOptFailedLoginAttemptNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.failedLoginAttemptNumber = value;
    }

    public Integer getDefFailedPasswordVerificationAttemptNumber() {
        return 0;
    }

    public Integer getOptFailedPasswordVerificationAttemptNumber() {
        return this.failedPasswordVerificationAttemptNumber;
    }

    public void setOptFailedPasswordVerificationAttemptNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.failedPasswordVerificationAttemptNumber = value;
    }

    public Long getOptLastPasswordChangeTime() {
        return this.lastPasswordChangeTime;
    }

    public void setOptLastPasswordChangeTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastPasswordChangeTime = value;
    }

    public Long getOptConsoleUsageCountThick() {
        return this.consoleUsageCountThick;
    }

    public void setOptConsoleUsageCountThick(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountThick = value;
    }

    public Long getOptConsoleUsageCountPortal1() {
        return this.consoleUsageCountPortal1;
    }

    public void setOptConsoleUsageCountPortal1(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountPortal1 = value;
    }

    public Long getOptConsoleUsageCountPortal2() {
        return this.consoleUsageCountPortal2;
    }

    public void setOptConsoleUsageCountPortal2(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountPortal2 = value;
    }

    public Long getOptConsoleUsageCountSSO() {
        return this.consoleUsageCountSSO;
    }

    public void setOptConsoleUsageCountSSO(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountSSO = value;
    }

    public Long getOptConsoleUsageCountReporting() {
        return this.consoleUsageCountReporting;
    }

    public void setOptConsoleUsageCountReporting(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountReporting = value;
    }

    public Long getOptConsoleUsageCountElse() {
        return this.consoleUsageCountElse;
    }

    public void setOptConsoleUsageCountElse(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.consoleUsageCountElse = value;
    }

    public Long getOptRiskWindowStartTime() {
        return this.riskWindowStartTime;
    }

    public void setOptRiskWindowStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.riskWindowStartTime = value;
    }

    public Integer getOptLockDurationInMinutes() {
        return this.lockDurationInMinutes;
    }

    public void setOptLockDurationInMinutes(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDurationInMinutes = value;
    }

    public Integer getOptLockCountWithinRiskWindow() {
        return this.lockCountWithinRiskWindow;
    }

    public void setOptLockCountWithinRiskWindow(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockCountWithinRiskWindow = value;
    }

    public Integer getDefNotifyLatestSepNews() {
        return NOT_READ;
    }

    public Integer getOptNotifyLatestSepNews() {
        return this.notifyLatestSepNews;
    }

    public String getOptNotifyLatestSepNewsValue() throws ValidationException {
        if (this.notifyLatestSepNews == null) {
            return null;
        }
        String s = null;
        switch (this.notifyLatestSepNews) {
            case 0: {
                s = "NOT_READ";
                break;
            }
            case 1: {
                s = "READ";
                break;
            }
            case 2: {
                s = "DISMISSED";
                break;
            }
            default: {
                throw new ValidationException("AdministratorState/NotifyLatestSepNews: invalid attribute value:" + this.notifyLatestSepNews + "!");
            }
        }
        return s;
    }

    public void setOptNotifyLatestSepNews(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.notifyLatestSepNews = value;
    }

    public void setOptNotifyLatestSepNewsValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.notifyLatestSepNews = null;
            return;
        }
        if ("NOT_READ".equals(value)) {
            this.notifyLatestSepNews = NOT_READ;
        } else if ("READ".equals(value)) {
            this.notifyLatestSepNews = READ;
        } else if ("DISMISSED".equals(value)) {
            this.notifyLatestSepNews = DISMISSED;
        } else {
            throw new ValidationException("AdministratorState/NotifyLatestSepNews: invalid attribute value:" + value + "!");
        }
    }

    public NotificationState getOptNotificationState() {
        ChildGroup childGroup = (ChildGroup)this.children.get(204);
        if (childGroup.size() > 0) {
            return (NotificationState)childGroup.get(0);
        }
        return null;
    }

    public void setOptNotificationState(NotificationState value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NotificationState obj = this.getOptNotificationState();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 203;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("AdministratorState/Id: attribute is required!");
        }
        if (this.ownerId == null) {
            throw new ValidationException("AdministratorState/OwnerId: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof NotificationState) {
            try {
                this.setOptNotificationState((NotificationState)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("AdministratorState/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("OwnerId");
            if (value == null) {
                throw new ValidationException("AdministratorState/OwnerId: attribute is required!");
            }
            this.ownerId = value;
            value = attris.getValue("LockStatus");
            if (value != null) {
                this.setOptLockStatusValue(value);
            }
            if ((value = attris.getValue("RandomPasswordStatus")) != null) {
                this.setOptRandomPasswordStatusValue(value);
            }
            if ((value = attris.getValue("PasswordStatus")) != null) {
                this.setOptPasswordStatusValue(value);
            }
            if ((value = attris.getValue("ResetPasswordTransactionID")) != null) {
                this.resetPasswordTransactionID = value;
            }
            if ((value = attris.getValue("LockTime")) != null) {
                try {
                    this.lockTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LockTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LockTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LastLoginIpAddress")) != null) {
                this.lastLoginIpAddress = value;
            }
            if ((value = attris.getValue("LastLoginTime")) != null) {
                try {
                    this.lastLoginTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LastLoginTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LastLoginTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LastLoginDomain")) != null) {
                this.lastLoginDomain = value;
            }
            if ((value = attris.getValue("LastLogoffTime")) != null) {
                try {
                    this.lastLogoffTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LastLogoffTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LastLogoffTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LastCheckpointTime")) != null) {
                try {
                    this.lastCheckpointTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LastCheckpointTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LastCheckpointTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("OnlineStatus")) != null) {
                this.setOptOnlineStatusValue(value);
            }
            if ((value = attris.getValue("FailedLoginAttemptNumber")) != null) {
                try {
                    this.failedLoginAttemptNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/FailedLoginAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/FailedLoginAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FailedPasswordVerificationAttemptNumber")) != null) {
                try {
                    this.failedPasswordVerificationAttemptNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/FailedPasswordVerificationAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/FailedPasswordVerificationAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LastPasswordChangeTime")) != null) {
                try {
                    this.lastPasswordChangeTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LastPasswordChangeTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LastPasswordChangeTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountThick")) != null) {
                try {
                    this.consoleUsageCountThick = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountThick: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountThick: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountPortal1")) != null) {
                try {
                    this.consoleUsageCountPortal1 = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountPortal1: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountPortal1: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountPortal2")) != null) {
                try {
                    this.consoleUsageCountPortal2 = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountPortal2: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountPortal2: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountSSO")) != null) {
                try {
                    this.consoleUsageCountSSO = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountSSO: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountSSO: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountReporting")) != null) {
                try {
                    this.consoleUsageCountReporting = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountReporting: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountReporting: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ConsoleUsageCountElse")) != null) {
                try {
                    this.consoleUsageCountElse = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountElse: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/ConsoleUsageCountElse: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RiskWindowStartTime")) != null) {
                try {
                    this.riskWindowStartTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/RiskWindowStartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/RiskWindowStartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LockDurationInMinutes")) != null) {
                try {
                    this.lockDurationInMinutes = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LockDurationInMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LockDurationInMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LockCountWithinRiskWindow")) != null) {
                try {
                    this.lockCountWithinRiskWindow = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("AdministratorState/LockCountWithinRiskWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("AdministratorState/LockCountWithinRiskWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("NotifyLatestSepNews")) != null) {
                this.setOptNotifyLatestSepNewsValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptNotificationState() != null) {
            this.getOptNotificationState().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AdministratorState".equals(element.getNodeName())) {
            throw new ValidationException("AdministratorState: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("AdministratorState/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "OwnerId");
        if (value == null) {
            throw new ValidationException("AdministratorState/OwnerId: attribute is required!");
        }
        this.ownerId = value;
        value = XMLHelper.getAttribute(element, "LockStatus");
        if (value != null) {
            this.setOptLockStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RandomPasswordStatus")) != null) {
            this.setOptRandomPasswordStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PasswordStatus")) != null) {
            this.setOptPasswordStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ResetPasswordTransactionID")) != null) {
            this.resetPasswordTransactionID = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockTime")) != null) {
            try {
                this.lockTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LockTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LastLoginIpAddress")) != null) {
            this.lastLoginIpAddress = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LastLoginTime")) != null) {
            try {
                this.lastLoginTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LastLoginTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LastLoginDomain")) != null) {
            this.lastLoginDomain = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LastLogoffTime")) != null) {
            try {
                this.lastLogoffTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LastLogoffTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LastCheckpointTime")) != null) {
            try {
                this.lastCheckpointTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LastCheckpointTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "OnlineStatus")) != null) {
            this.setOptOnlineStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "FailedLoginAttemptNumber")) != null) {
            try {
                this.failedLoginAttemptNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/FailedLoginAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FailedPasswordVerificationAttemptNumber")) != null) {
            try {
                this.failedPasswordVerificationAttemptNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/FailedPasswordVerificationAttemptNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LastPasswordChangeTime")) != null) {
            try {
                this.lastPasswordChangeTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LastPasswordChangeTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountThick")) != null) {
            try {
                this.consoleUsageCountThick = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountThick: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountPortal1")) != null) {
            try {
                this.consoleUsageCountPortal1 = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountPortal1: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountPortal2")) != null) {
            try {
                this.consoleUsageCountPortal2 = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountPortal2: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountSSO")) != null) {
            try {
                this.consoleUsageCountSSO = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountSSO: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountReporting")) != null) {
            try {
                this.consoleUsageCountReporting = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountReporting: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ConsoleUsageCountElse")) != null) {
            try {
                this.consoleUsageCountElse = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/ConsoleUsageCountElse: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RiskWindowStartTime")) != null) {
            try {
                this.riskWindowStartTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/RiskWindowStartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LockDurationInMinutes")) != null) {
            try {
                this.lockDurationInMinutes = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LockDurationInMinutes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LockCountWithinRiskWindow")) != null) {
            try {
                this.lockCountWithinRiskWindow = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("AdministratorState/LockCountWithinRiskWindow: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "NotifyLatestSepNews")) != null) {
            this.setOptNotifyLatestSepNewsValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NotificationState")).size() > 0) {
            NotificationState notificationStateObj = new NotificationState();
            notificationStateObj.importFromElement(v.get(0));
            this.setOptNotificationState(notificationStateObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdministratorState/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdministratorState/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdministratorState");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.ownerId != null) {
            element.setAttribute("OwnerId", this.ownerId);
        }
        if (this.lockStatus != null) {
            element.setAttribute("LockStatus", this.getOptLockStatusValue());
        }
        if (this.randomPasswordStatus != null) {
            element.setAttribute("RandomPasswordStatus", this.getOptRandomPasswordStatusValue());
        }
        if (this.passwordStatus != null) {
            element.setAttribute("PasswordStatus", this.getOptPasswordStatusValue());
        }
        if (this.resetPasswordTransactionID != null) {
            element.setAttribute("ResetPasswordTransactionID", this.resetPasswordTransactionID);
        }
        if (this.lockTime != null) {
            element.setAttribute("LockTime", this.lockTime.toString());
        }
        if (this.lastLoginIpAddress != null) {
            element.setAttribute("LastLoginIpAddress", this.lastLoginIpAddress);
        }
        if (this.lastLoginTime != null) {
            element.setAttribute("LastLoginTime", this.lastLoginTime.toString());
        }
        if (this.lastLoginDomain != null) {
            element.setAttribute("LastLoginDomain", this.lastLoginDomain);
        }
        if (this.lastLogoffTime != null) {
            element.setAttribute("LastLogoffTime", this.lastLogoffTime.toString());
        }
        if (this.lastCheckpointTime != null) {
            element.setAttribute("LastCheckpointTime", this.lastCheckpointTime.toString());
        }
        if (this.onlineStatus != null) {
            element.setAttribute("OnlineStatus", this.getOptOnlineStatusValue());
        }
        if (this.failedLoginAttemptNumber != null) {
            element.setAttribute("FailedLoginAttemptNumber", this.failedLoginAttemptNumber.toString());
        }
        if (this.failedPasswordVerificationAttemptNumber != null) {
            element.setAttribute("FailedPasswordVerificationAttemptNumber", this.failedPasswordVerificationAttemptNumber.toString());
        }
        if (this.lastPasswordChangeTime != null) {
            element.setAttribute("LastPasswordChangeTime", this.lastPasswordChangeTime.toString());
        }
        if (this.consoleUsageCountThick != null) {
            element.setAttribute("ConsoleUsageCountThick", this.consoleUsageCountThick.toString());
        }
        if (this.consoleUsageCountPortal1 != null) {
            element.setAttribute("ConsoleUsageCountPortal1", this.consoleUsageCountPortal1.toString());
        }
        if (this.consoleUsageCountPortal2 != null) {
            element.setAttribute("ConsoleUsageCountPortal2", this.consoleUsageCountPortal2.toString());
        }
        if (this.consoleUsageCountSSO != null) {
            element.setAttribute("ConsoleUsageCountSSO", this.consoleUsageCountSSO.toString());
        }
        if (this.consoleUsageCountReporting != null) {
            element.setAttribute("ConsoleUsageCountReporting", this.consoleUsageCountReporting.toString());
        }
        if (this.consoleUsageCountElse != null) {
            element.setAttribute("ConsoleUsageCountElse", this.consoleUsageCountElse.toString());
        }
        if (this.riskWindowStartTime != null) {
            element.setAttribute("RiskWindowStartTime", this.riskWindowStartTime.toString());
        }
        if (this.lockDurationInMinutes != null) {
            element.setAttribute("LockDurationInMinutes", this.lockDurationInMinutes.toString());
        }
        if (this.lockCountWithinRiskWindow != null) {
            element.setAttribute("LockCountWithinRiskWindow", this.lockCountWithinRiskWindow.toString());
        }
        if (this.notifyLatestSepNews != null) {
            element.setAttribute("NotifyLatestSepNews", this.getOptNotifyLatestSepNewsValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdministratorState ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.ownerId != null) {
                strAttrs.append("OwnerId=\"").append(AbstractSchema.checkXMLContent(this.ownerId)).append("\" ");
            }
            if (this.lockStatus != null) {
                strAttrs.append("LockStatus=\"").append(this.getOptLockStatusValue()).append("\" ");
            }
            if (this.randomPasswordStatus != null) {
                strAttrs.append("RandomPasswordStatus=\"").append(this.getOptRandomPasswordStatusValue()).append("\" ");
            }
            if (this.passwordStatus != null) {
                strAttrs.append("PasswordStatus=\"").append(this.getOptPasswordStatusValue()).append("\" ");
            }
            if (this.resetPasswordTransactionID != null) {
                strAttrs.append("ResetPasswordTransactionID=\"").append(AbstractSchema.checkXMLContent(this.resetPasswordTransactionID)).append("\" ");
            }
            if (this.lockTime != null) {
                strAttrs.append("LockTime=\"").append(this.lockTime.toString()).append("\" ");
            }
            if (this.lastLoginIpAddress != null) {
                strAttrs.append("LastLoginIpAddress=\"").append(AbstractSchema.checkXMLContent(this.lastLoginIpAddress)).append("\" ");
            }
            if (this.lastLoginTime != null) {
                strAttrs.append("LastLoginTime=\"").append(this.lastLoginTime.toString()).append("\" ");
            }
            if (this.lastLoginDomain != null) {
                strAttrs.append("LastLoginDomain=\"").append(AbstractSchema.checkXMLContent(this.lastLoginDomain)).append("\" ");
            }
            if (this.lastLogoffTime != null) {
                strAttrs.append("LastLogoffTime=\"").append(this.lastLogoffTime.toString()).append("\" ");
            }
            if (this.lastCheckpointTime != null) {
                strAttrs.append("LastCheckpointTime=\"").append(this.lastCheckpointTime.toString()).append("\" ");
            }
            if (this.onlineStatus != null) {
                strAttrs.append("OnlineStatus=\"").append(this.getOptOnlineStatusValue()).append("\" ");
            }
            if (this.failedLoginAttemptNumber != null) {
                strAttrs.append("FailedLoginAttemptNumber=\"").append(this.failedLoginAttemptNumber.toString()).append("\" ");
            }
            if (this.failedPasswordVerificationAttemptNumber != null) {
                strAttrs.append("FailedPasswordVerificationAttemptNumber=\"").append(this.failedPasswordVerificationAttemptNumber.toString()).append("\" ");
            }
            if (this.lastPasswordChangeTime != null) {
                strAttrs.append("LastPasswordChangeTime=\"").append(this.lastPasswordChangeTime.toString()).append("\" ");
            }
            if (this.consoleUsageCountThick != null) {
                strAttrs.append("ConsoleUsageCountThick=\"").append(this.consoleUsageCountThick.toString()).append("\" ");
            }
            if (this.consoleUsageCountPortal1 != null) {
                strAttrs.append("ConsoleUsageCountPortal1=\"").append(this.consoleUsageCountPortal1.toString()).append("\" ");
            }
            if (this.consoleUsageCountPortal2 != null) {
                strAttrs.append("ConsoleUsageCountPortal2=\"").append(this.consoleUsageCountPortal2.toString()).append("\" ");
            }
            if (this.consoleUsageCountSSO != null) {
                strAttrs.append("ConsoleUsageCountSSO=\"").append(this.consoleUsageCountSSO.toString()).append("\" ");
            }
            if (this.consoleUsageCountReporting != null) {
                strAttrs.append("ConsoleUsageCountReporting=\"").append(this.consoleUsageCountReporting.toString()).append("\" ");
            }
            if (this.consoleUsageCountElse != null) {
                strAttrs.append("ConsoleUsageCountElse=\"").append(this.consoleUsageCountElse.toString()).append("\" ");
            }
            if (this.riskWindowStartTime != null) {
                strAttrs.append("RiskWindowStartTime=\"").append(this.riskWindowStartTime.toString()).append("\" ");
            }
            if (this.lockDurationInMinutes != null) {
                strAttrs.append("LockDurationInMinutes=\"").append(this.lockDurationInMinutes.toString()).append("\" ");
            }
            if (this.lockCountWithinRiskWindow != null) {
                strAttrs.append("LockCountWithinRiskWindow=\"").append(this.lockCountWithinRiskWindow.toString()).append("\" ");
            }
            if (this.notifyLatestSepNews != null) {
                strAttrs.append("NotifyLatestSepNews=\"").append(this.getOptNotifyLatestSepNewsValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdministratorState>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

