/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdditionalAllowedFile
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer TEST_FOR_REMOVE = 1;
    private static final long serialVersionUID = 1L;
    private Integer mode;

    public AdditionalAllowedFile() {
        this(true);
    }

    public AdditionalAllowedFile(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(434, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdditionalAllowedFile";
    }

    public Integer getDefMode() {
        return NORMAL;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "TEST_FOR_REMOVE";
                break;
            }
            default: {
                throw new ValidationException("AdditionalAllowedFile/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.mode = NORMAL;
        } else if ("TEST_FOR_REMOVE".equals(value)) {
            this.mode = TEST_FOR_REMOVE;
        } else {
            throw new ValidationException("AdditionalAllowedFile/Mode: invalid attribute value:" + value + "!");
        }
    }

    public OpFileNameMatchEntity getOpFileNameMatchEntity() {
        ChildGroup childGroup = (ChildGroup)this.children.get(434);
        if (childGroup.size() > 0) {
            return (OpFileNameMatchEntity)childGroup.get(0);
        }
        return null;
    }

    public void setOpFileNameMatchEntity(OpFileNameMatchEntity value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            OpFileNameMatchEntity obj = this.getOpFileNameMatchEntity();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 296;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getOpFileNameMatchEntity() == null) {
            throw new ValidationException("AdditionalAllowedFile/OpFileNameMatchEntity: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof OpFileNameMatchEntity) {
            try {
                this.setOpFileNameMatchEntity((OpFileNameMatchEntity)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value != null) {
                this.setOptModeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOpFileNameMatchEntity() != null) {
            this.getOpFileNameMatchEntity().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(434)).size();
        }
        catch (Throwable t) {
            throw new SAXException("AdditionalAllowedFile: can't import element == OpFileNameMatchEntity!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AdditionalAllowedFile".equals(element.getNodeName())) {
            throw new ValidationException("AdditionalAllowedFile: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value != null) {
            this.setOptModeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "OpFileNameMatchEntity")).size() != 1) {
            throw new ValidationException("AdditionalAllowedFile/OpFileNameMatchEntity: element is require!");
        }
        OpFileNameMatchEntity opFileNameMatchEntityObj = new OpFileNameMatchEntity();
        opFileNameMatchEntityObj.importFromElement(v.get(0));
        this.setOpFileNameMatchEntity(opFileNameMatchEntityObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdditionalAllowedFile/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdditionalAllowedFile/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdditionalAllowedFile");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdditionalAllowedFile ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdditionalAllowedFile>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

