/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.PrevalenceRulesList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdaptivePrevalenceRules
extends TopLevelObject
implements NamedObject {
    public static final Integer LEARNING = 0;
    public static final Integer DAYS_90 = 1;
    public static final Integer DAYS_180 = 2;
    public static final Integer DAYS_365 = 3;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Boolean isLightRegistered;
    private Integer prevalenceAge;

    public AdaptivePrevalenceRules() {
        this(true);
    }

    public AdaptivePrevalenceRules(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(844, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdaptivePrevalenceRules";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Boolean getDefIsLightRegistered() {
        return Boolean.FALSE;
    }

    public Boolean getOptIsLightRegistered() {
        return this.isLightRegistered;
    }

    public void setOptIsLightRegistered(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.isLightRegistered = value;
    }

    public Integer getDefPrevalenceAge() {
        return LEARNING;
    }

    public Integer getOptPrevalenceAge() {
        return this.prevalenceAge;
    }

    public String getOptPrevalenceAgeValue() throws ValidationException {
        if (this.prevalenceAge == null) {
            return null;
        }
        String s = null;
        switch (this.prevalenceAge) {
            case 0: {
                s = "LEARNING";
                break;
            }
            case 1: {
                s = "DAYS_90";
                break;
            }
            case 2: {
                s = "DAYS_180";
                break;
            }
            case 3: {
                s = "DAYS_365";
                break;
            }
            default: {
                throw new ValidationException("AdaptivePrevalenceRules/PrevalenceAge: invalid attribute value:" + this.prevalenceAge + "!");
            }
        }
        return s;
    }

    public void setOptPrevalenceAge(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.prevalenceAge = value;
    }

    public void setOptPrevalenceAgeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.prevalenceAge = null;
            return;
        }
        if ("LEARNING".equals(value)) {
            this.prevalenceAge = LEARNING;
        } else if ("DAYS_90".equals(value)) {
            this.prevalenceAge = DAYS_90;
        } else if ("DAYS_180".equals(value)) {
            this.prevalenceAge = DAYS_180;
        } else if ("DAYS_365".equals(value)) {
            this.prevalenceAge = DAYS_365;
        } else {
            throw new ValidationException("AdaptivePrevalenceRules/PrevalenceAge: invalid attribute value:" + value + "!");
        }
    }

    public PrevalenceRulesList getOptPrevalenceRulesList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(844);
        if (childGroup.size() > 0) {
            return (PrevalenceRulesList)childGroup.get(0);
        }
        return null;
    }

    public void setOptPrevalenceRulesList(PrevalenceRulesList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PrevalenceRulesList obj = this.getOptPrevalenceRulesList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 838;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("AdaptivePrevalenceRules/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("AdaptivePrevalenceRules/Name: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof PrevalenceRulesList) {
            try {
                this.setOptPrevalenceRulesList((PrevalenceRulesList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("AdaptivePrevalenceRules/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("AdaptivePrevalenceRules/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("IsLightRegistered")) != null) {
                this.isLightRegistered = "1".equals(value);
            }
            if ((value = attris.getValue("PrevalenceAge")) != null) {
                this.setOptPrevalenceAgeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptPrevalenceRulesList() != null) {
            this.getOptPrevalenceRulesList().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AdaptivePrevalenceRules".equals(element.getNodeName())) {
            throw new ValidationException("AdaptivePrevalenceRules: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("AdaptivePrevalenceRules/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("AdaptivePrevalenceRules/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "IsLightRegistered")) != null) {
            this.isLightRegistered = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PrevalenceAge")) != null) {
            this.setOptPrevalenceAgeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PrevalenceRulesList")).size() > 0) {
            PrevalenceRulesList prevalenceRulesListObj = new PrevalenceRulesList();
            prevalenceRulesListObj.importFromElement(v.get(0));
            this.setOptPrevalenceRulesList(prevalenceRulesListObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdaptivePrevalenceRules/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdaptivePrevalenceRules/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdaptivePrevalenceRules");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.isLightRegistered != null) {
            element.setAttribute("IsLightRegistered", this.isLightRegistered != false ? "1" : "0");
        }
        if (this.prevalenceAge != null) {
            element.setAttribute("PrevalenceAge", this.getOptPrevalenceAgeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdaptivePrevalenceRules ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.isLightRegistered != null) {
                strAttrs.append("IsLightRegistered=").append(this.isLightRegistered != false ? "\"1\" " : "\"0\" ");
            }
            if (this.prevalenceAge != null) {
                strAttrs.append("PrevalenceAge=\"").append(this.getOptPrevalenceAgeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdaptivePrevalenceRules>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

