/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRulesList;
import com.sygate.scm.common.configobject.schema.EndpointNotification;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdaptiveConfiguration
extends ConfigObject {
    public static final Integer BLOCK = 0;
    public static final Integer ALLOW = 1;
    public static final Integer LOG = 2;
    private static final long serialVersionUID = 1L;
    private Integer bPEEnhancementsAction;

    public AdaptiveConfiguration() {
        this(true);
    }

    public AdaptiveConfiguration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(841, new ChildGroup(0, 1));
        this.children.put(843, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdaptiveConfiguration";
    }

    public Integer getDefBPEEnhancementsAction() {
        return BLOCK;
    }

    public Integer getOptBPEEnhancementsAction() {
        return this.bPEEnhancementsAction;
    }

    public String getOptBPEEnhancementsActionValue() throws ValidationException {
        if (this.bPEEnhancementsAction == null) {
            return null;
        }
        String s = null;
        switch (this.bPEEnhancementsAction) {
            case 0: {
                s = "BLOCK";
                break;
            }
            case 1: {
                s = "ALLOW";
                break;
            }
            case 2: {
                s = "LOG";
                break;
            }
            default: {
                throw new ValidationException("AdaptiveConfiguration/BPEEnhancementsAction: invalid attribute value:" + this.bPEEnhancementsAction + "!");
            }
        }
        return s;
    }

    public void setOptBPEEnhancementsAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.bPEEnhancementsAction = value;
    }

    public void setOptBPEEnhancementsActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.bPEEnhancementsAction = null;
            return;
        }
        if ("BLOCK".equals(value)) {
            this.bPEEnhancementsAction = BLOCK;
        } else if ("ALLOW".equals(value)) {
            this.bPEEnhancementsAction = ALLOW;
        } else if ("LOG".equals(value)) {
            this.bPEEnhancementsAction = LOG;
        } else {
            throw new ValidationException("AdaptiveConfiguration/BPEEnhancementsAction: invalid attribute value:" + value + "!");
        }
    }

    public BPEEnhancementsRulesList getOptBPEEnhancementsRulesList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(841);
        if (childGroup.size() > 0) {
            return (BPEEnhancementsRulesList)childGroup.get(0);
        }
        return null;
    }

    public void setOptBPEEnhancementsRulesList(BPEEnhancementsRulesList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            BPEEnhancementsRulesList obj = this.getOptBPEEnhancementsRulesList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public EndpointNotification getOptEndpointNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(843);
        if (childGroup.size() > 0) {
            return (EndpointNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptEndpointNotification(EndpointNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            EndpointNotification obj = this.getOptEndpointNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 840;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof BPEEnhancementsRulesList) {
            try {
                this.setOptBPEEnhancementsRulesList((BPEEnhancementsRulesList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof EndpointNotification) {
            try {
                this.setOptEndpointNotification((EndpointNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("BPEEnhancementsAction");
            if (value != null) {
                this.setOptBPEEnhancementsActionValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptBPEEnhancementsRulesList() != null) {
            this.getOptBPEEnhancementsRulesList().setReadonly();
        }
        if (this.getOptEndpointNotification() != null) {
            this.getOptEndpointNotification().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"AdaptiveConfiguration".equals(element.getNodeName())) {
            throw new ValidationException("AdaptiveConfiguration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "BPEEnhancementsAction");
        if (value != null) {
            this.setOptBPEEnhancementsActionValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "BPEEnhancementsRulesList")).size() > 0) {
            BPEEnhancementsRulesList bPEEnhancementsRulesListObj = new BPEEnhancementsRulesList();
            bPEEnhancementsRulesListObj.importFromElement(v.get(0));
            this.setOptBPEEnhancementsRulesList(bPEEnhancementsRulesListObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "EndpointNotification")).size() > 0) {
            EndpointNotification endpointNotificationObj = new EndpointNotification();
            endpointNotificationObj.importFromElement(v.get(0));
            this.setOptEndpointNotification(endpointNotificationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdaptiveConfiguration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdaptiveConfiguration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdaptiveConfiguration");
        if (this.bPEEnhancementsAction != null) {
            element.setAttribute("BPEEnhancementsAction", this.getOptBPEEnhancementsActionValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdaptiveConfiguration ");
            if (this.bPEEnhancementsAction != null) {
                strAttrs.append("BPEEnhancementsAction=\"").append(this.getOptBPEEnhancementsActionValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdaptiveConfiguration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

