/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AdCredentials;
import com.sygate.scm.common.configobject.schema.MaskData;
import com.sygate.scm.common.configobject.schema.WhitelistData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdDomainPolicy
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String adDomainUid;
    private String policyUid;

    public AdDomainPolicy() {
        this(true);
    }

    public AdDomainPolicy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(32, new ChildGroup(0, 1));
        this.children.put(33, new ChildGroup(0, 1));
        this.children.put(34, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "AdDomainPolicy";
    }

    public String getAdDomainUid() {
        return this.adDomainUid;
    }

    public void setAdDomainUid(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.adDomainUid = value;
    }

    public String getPolicyUid() {
        return this.policyUid;
    }

    public void setPolicyUid(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.policyUid = value;
    }

    public AdCredentials getOptAdCredentials() {
        ChildGroup childGroup = (ChildGroup)this.children.get(32);
        if (childGroup.size() > 0) {
            return (AdCredentials)childGroup.get(0);
        }
        return null;
    }

    public void setOptAdCredentials(AdCredentials value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AdCredentials obj = this.getOptAdCredentials();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public WhitelistData getOptWhitelistData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(33);
        if (childGroup.size() > 0) {
            return (WhitelistData)childGroup.get(0);
        }
        return null;
    }

    public void setOptWhitelistData(WhitelistData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            WhitelistData obj = this.getOptWhitelistData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public MaskData getOptMaskData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(34);
        if (childGroup.size() > 0) {
            return (MaskData)childGroup.get(0);
        }
        return null;
    }

    public void setOptMaskData(MaskData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MaskData obj = this.getOptMaskData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 31;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.adDomainUid == null) {
            throw new ValidationException("AdDomainPolicy/AdDomainUid: attribute is required!");
        }
        if (this.policyUid == null) {
            throw new ValidationException("AdDomainPolicy/PolicyUid: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AdCredentials) {
            try {
                this.setOptAdCredentials((AdCredentials)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof WhitelistData) {
            try {
                this.setOptWhitelistData((WhitelistData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof MaskData) {
            try {
                this.setOptMaskData((MaskData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AdDomainUid");
            if (value == null) {
                throw new ValidationException("AdDomainPolicy/AdDomainUid: attribute is required!");
            }
            this.adDomainUid = value;
            value = attris.getValue("PolicyUid");
            if (value == null) {
                throw new ValidationException("AdDomainPolicy/PolicyUid: attribute is required!");
            }
            this.policyUid = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptAdCredentials() != null) {
            this.getOptAdCredentials().setReadonly();
        }
        if (this.getOptWhitelistData() != null) {
            this.getOptWhitelistData().setReadonly();
        }
        if (this.getOptMaskData() != null) {
            this.getOptMaskData().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"AdDomainPolicy".equals(element.getNodeName())) {
            throw new ValidationException("AdDomainPolicy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AdDomainUid");
        if (value == null) {
            throw new ValidationException("AdDomainPolicy/AdDomainUid: attribute is required!");
        }
        this.adDomainUid = value;
        value = XMLHelper.getAttribute(element, "PolicyUid");
        if (value == null) {
            throw new ValidationException("AdDomainPolicy/PolicyUid: attribute is required!");
        }
        this.policyUid = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "AdCredentials");
        if (v.size() > 0) {
            AdCredentials adCredentialsObj = new AdCredentials();
            adCredentialsObj.importFromElement(v.get(0));
            this.setOptAdCredentials(adCredentialsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "WhitelistData")).size() > 0) {
            WhitelistData whitelistDataObj = new WhitelistData();
            whitelistDataObj.importFromElement(v.get(0));
            this.setOptWhitelistData(whitelistDataObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "MaskData")).size() > 0) {
            MaskData maskDataObj = new MaskData();
            maskDataObj.importFromElement(v.get(0));
            this.setOptMaskData(maskDataObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("AdDomainPolicy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("AdDomainPolicy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("AdDomainPolicy");
        if (this.adDomainUid != null) {
            element.setAttribute("AdDomainUid", this.adDomainUid);
        }
        if (this.policyUid != null) {
            element.setAttribute("PolicyUid", this.policyUid);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AdDomainPolicy ");
            if (this.adDomainUid != null) {
                strAttrs.append("AdDomainUid=\"").append(AbstractSchema.checkXMLContent(this.adDomainUid)).append("\" ");
            }
            if (this.policyUid != null) {
                strAttrs.append("PolicyUid=\"").append(AbstractSchema.checkXMLContent(this.policyUid)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AdDomainPolicy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

