/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SqlParameter
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer type;
    private String tableColumnName;
    private String opeartor;
    private String value;

    public SqlParameter() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "SqlParameter";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.type = value;
    }

    public String getOptTableColumnName() {
        return this.tableColumnName;
    }

    public void setOptTableColumnName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.tableColumnName = value;
    }

    public String getOptOpeartor() {
        return this.opeartor;
    }

    public void setOptOpeartor(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.opeartor = value;
    }

    public String getOptValue() {
        return this.value;
    }

    public void setOptValue(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.value = value;
    }

    @Override
    public int getObjectType() {
        return 262188;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("SqlParameter/Name: attribute is required!");
        }
        if (this.type == null) {
            throw new ValidationException("SqlParameter/Type: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("SqlParameter/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Type");
            if (value == null) {
                throw new ValidationException("SqlParameter/Type: attribute is required!");
            }
            try {
                this.type = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SqlParameter/Type: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SqlParameter/Type: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("TableColumnName");
            if (value != null) {
                this.tableColumnName = value;
            }
            if ((value = attris.getValue("Opeartor")) != null) {
                this.opeartor = value;
            }
            if ((value = attris.getValue("Value")) != null) {
                this.value = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SqlParameter".equals(element.getNodeName())) {
            throw new ValidationException("SqlParameter: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("SqlParameter/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Type");
        if (value == null) {
            throw new ValidationException("SqlParameter/Type: attribute is required!");
        }
        try {
            this.type = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SqlParameter/Type: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SqlParameter/Type: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "TableColumnName");
        if (value != null) {
            this.tableColumnName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Opeartor")) != null) {
            this.opeartor = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Value")) != null) {
            this.value = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SqlParameter");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.type.toString());
        }
        if (this.tableColumnName != null) {
            element.setAttribute("TableColumnName", this.tableColumnName);
        }
        if (this.opeartor != null) {
            element.setAttribute("Opeartor", this.opeartor);
        }
        if (this.value != null) {
            element.setAttribute("Value", this.value);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SqlParameter ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.type.toString()).append("\" ");
            }
            if (this.tableColumnName != null) {
                strAttrs.append("TableColumnName=\"").append(AbstractSchema.checkXMLContent(this.tableColumnName)).append("\" ");
            }
            if (this.opeartor != null) {
                strAttrs.append("Opeartor=\"").append(AbstractSchema.checkXMLContent(this.opeartor)).append("\" ");
            }
            if (this.value != null) {
                strAttrs.append("Value=\"").append(AbstractSchema.checkXMLContent(this.value)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SqlParameter>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

