/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Server
extends AbstractSchema {
    public static final Integer HTTP = 0;
    public static final Integer HTTPS = 1;
    private static final long serialVersionUID = 1L;
    private String address;
    private String addressIpv6;
    private Integer httpPort;
    private Integer httpsPort;
    private Integer protocol;
    private Boolean httpsVerifyCA;
    private Boolean verifySignatures;
    private Boolean signingAlgorithm;
    private String certName;

    public Server() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "Server";
    }

    public String getOptAddress() {
        return this.address;
    }

    public void setOptAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.address = value;
    }

    public String getOptAddressIpv6() {
        return this.addressIpv6;
    }

    public void setOptAddressIpv6(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addressIpv6 = value;
    }

    public Integer getDefHttpPort() {
        return 80;
    }

    public Integer getOptHttpPort() {
        return this.httpPort;
    }

    public void setOptHttpPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpPort = value;
    }

    public Integer getDefHttpsPort() {
        return 443;
    }

    public Integer getOptHttpsPort() {
        return this.httpsPort;
    }

    public void setOptHttpsPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpsPort = value;
    }

    public Integer getDefProtocol() {
        return HTTP;
    }

    public Integer getOptProtocol() {
        return this.protocol;
    }

    public String getOptProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "HTTP";
                break;
            }
            case 1: {
                s = "HTTPS";
                break;
            }
            default: {
                throw new ValidationException("Server/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setOptProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.protocol = value;
    }

    public void setOptProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protocol = null;
            return;
        }
        if ("HTTP".equals(value)) {
            this.protocol = HTTP;
        } else if ("HTTPS".equals(value)) {
            this.protocol = HTTPS;
        } else {
            throw new ValidationException("Server/Protocol: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefHttpsVerifyCA() {
        return Boolean.FALSE;
    }

    public Boolean getOptHttpsVerifyCA() {
        return this.httpsVerifyCA;
    }

    public void setOptHttpsVerifyCA(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpsVerifyCA = value;
    }

    public Boolean getDefVerifySignatures() {
        return Boolean.TRUE;
    }

    public Boolean getOptVerifySignatures() {
        return this.verifySignatures;
    }

    public void setOptVerifySignatures(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.verifySignatures = value;
    }

    public Boolean getDefSigningAlgorithm() {
        return Boolean.FALSE;
    }

    public Boolean getOptSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setOptSigningAlgorithm(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.signingAlgorithm = value;
    }

    public String getOptCertName() {
        return this.certName;
    }

    public void setOptCertName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.certName = value;
    }

    @Override
    public int getObjectType() {
        return 262212;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Address");
            if (value != null) {
                this.address = value;
            }
            if ((value = attris.getValue("AddressIpv6")) != null) {
                this.addressIpv6 = value;
            }
            if ((value = attris.getValue("HttpPort")) != null) {
                try {
                    this.httpPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Server/HttpPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Server/HttpPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("HttpsPort")) != null) {
                try {
                    this.httpsPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Server/HttpsPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Server/HttpsPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Protocol")) != null) {
                this.setOptProtocolValue(value);
            }
            if ((value = attris.getValue("HttpsVerifyCA")) != null) {
                this.httpsVerifyCA = "1".equals(value);
            }
            if ((value = attris.getValue("VerifySignatures")) != null) {
                this.verifySignatures = "1".equals(value);
            }
            if ((value = attris.getValue("SigningAlgorithm")) != null) {
                this.signingAlgorithm = "1".equals(value);
            }
            if ((value = attris.getValue("CertName")) != null) {
                this.certName = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Server".equals(element.getNodeName())) {
            throw new ValidationException("Server: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Address");
        if (value != null) {
            this.address = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AddressIpv6")) != null) {
            this.addressIpv6 = value;
        }
        if ((value = XMLHelper.getAttribute(element, "HttpPort")) != null) {
            try {
                this.httpPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Server/HttpPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsPort")) != null) {
            try {
                this.httpsPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Server/HttpsPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Protocol")) != null) {
            this.setOptProtocolValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsVerifyCA")) != null) {
            this.httpsVerifyCA = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "VerifySignatures")) != null) {
            this.verifySignatures = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SigningAlgorithm")) != null) {
            this.signingAlgorithm = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CertName")) != null) {
            this.certName = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Server");
        if (this.address != null) {
            element.setAttribute("Address", this.address);
        }
        if (this.addressIpv6 != null) {
            element.setAttribute("AddressIpv6", this.addressIpv6);
        }
        if (this.httpPort != null) {
            element.setAttribute("HttpPort", this.httpPort.toString());
        }
        if (this.httpsPort != null) {
            element.setAttribute("HttpsPort", this.httpsPort.toString());
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getOptProtocolValue());
        }
        if (this.httpsVerifyCA != null) {
            element.setAttribute("HttpsVerifyCA", this.httpsVerifyCA != false ? "1" : "0");
        }
        if (this.verifySignatures != null) {
            element.setAttribute("VerifySignatures", this.verifySignatures != false ? "1" : "0");
        }
        if (this.signingAlgorithm != null) {
            element.setAttribute("SigningAlgorithm", this.signingAlgorithm != false ? "1" : "0");
        }
        if (this.certName != null) {
            element.setAttribute("CertName", this.certName);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Server ");
            if (this.address != null) {
                strAttrs.append("Address=\"").append(AbstractSchema.checkXMLContent(this.address)).append("\" ");
            }
            if (this.addressIpv6 != null) {
                strAttrs.append("AddressIpv6=\"").append(AbstractSchema.checkXMLContent(this.addressIpv6)).append("\" ");
            }
            if (this.httpPort != null) {
                strAttrs.append("HttpPort=\"").append(this.httpPort.toString()).append("\" ");
            }
            if (this.httpsPort != null) {
                strAttrs.append("HttpsPort=\"").append(this.httpsPort.toString()).append("\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getOptProtocolValue()).append("\" ");
            }
            if (this.httpsVerifyCA != null) {
                strAttrs.append("HttpsVerifyCA=").append(this.httpsVerifyCA != false ? "\"1\" " : "\"0\" ");
            }
            if (this.verifySignatures != null) {
                strAttrs.append("VerifySignatures=").append(this.verifySignatures != false ? "\"1\" " : "\"0\" ");
            }
            if (this.signingAlgorithm != null) {
                strAttrs.append("SigningAlgorithm=").append(this.signingAlgorithm != false ? "\"1\" " : "\"0\" ");
            }
            if (this.certName != null) {
                strAttrs.append("CertName=\"").append(AbstractSchema.checkXMLContent(this.certName)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Server>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

