/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.DataHandlerList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SSAServerVersionInfo
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String productVersion;

    public SSAServerVersionInfo() {
        this.nameSpace = "rpc";
        this.children.put(262252, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SSAServerVersionInfo";
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.productVersion = value;
    }

    public DataHandlerList getDataHandlerList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262252);
        if (childGroup.size() > 0) {
            return (DataHandlerList)childGroup.get(0);
        }
        return null;
    }

    public void setDataHandlerList(DataHandlerList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DataHandlerList obj = this.getDataHandlerList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 262251;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.productVersion == null) {
            throw new ValidationException("SSAServerVersionInfo/ProductVersion: attribute is required!");
        }
        if (this.getDataHandlerList() == null) {
            throw new ValidationException("SSAServerVersionInfo/DataHandlerList: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof DataHandlerList) {
            try {
                this.setDataHandlerList((DataHandlerList)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ProductVersion");
            if (value == null) {
                throw new ValidationException("SSAServerVersionInfo/ProductVersion: attribute is required!");
            }
            this.productVersion = value;
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getDataHandlerList() != null) {
            this.getDataHandlerList().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(262252)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SSAServerVersionInfo: can't import element == DataHandlerList!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SSAServerVersionInfo".equals(element.getNodeName())) {
            throw new ValidationException("SSAServerVersionInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ProductVersion");
        if (value == null) {
            throw new ValidationException("SSAServerVersionInfo/ProductVersion: attribute is required!");
        }
        this.productVersion = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DataHandlerList");
        if (v.size() != 1) {
            throw new ValidationException("SSAServerVersionInfo/DataHandlerList: element is require!");
        }
        DataHandlerList dataHandlerListObj = new DataHandlerList();
        dataHandlerListObj.importFromElement(v.get(0));
        this.setDataHandlerList(dataHandlerListObj);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SSAServerVersionInfo");
        if (this.productVersion != null) {
            element.setAttribute("ProductVersion", this.productVersion);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SSAServerVersionInfo ");
            if (this.productVersion != null) {
                strAttrs.append("ProductVersion=\"").append(AbstractSchema.checkXMLContent(this.productVersion)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SSAServerVersionInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

