/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SSANIC
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String ip;
    private String mac;
    private String gateway;
    private String subnetMask;

    public SSANIC() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "SSANIC";
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ip = value;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mac = value;
    }

    public String getOptGateway() {
        return this.gateway;
    }

    public void setOptGateway(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.gateway = value;
    }

    public String getOptSubnetMask() {
        return this.subnetMask;
    }

    public void setOptSubnetMask(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.subnetMask = value;
    }

    @Override
    public int getObjectType() {
        return 262175;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.ip == null) {
            throw new ValidationException("SSANIC/Ip: attribute is required!");
        }
        if (this.mac == null) {
            throw new ValidationException("SSANIC/Mac: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Ip");
            if (value == null) {
                throw new ValidationException("SSANIC/Ip: attribute is required!");
            }
            this.ip = value;
            value = attris.getValue("Mac");
            if (value == null) {
                throw new ValidationException("SSANIC/Mac: attribute is required!");
            }
            this.mac = value;
            value = attris.getValue("Gateway");
            if (value != null) {
                this.gateway = value;
            }
            if ((value = attris.getValue("SubnetMask")) != null) {
                this.subnetMask = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SSANIC".equals(element.getNodeName())) {
            throw new ValidationException("SSANIC: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Ip");
        if (value == null) {
            throw new ValidationException("SSANIC/Ip: attribute is required!");
        }
        this.ip = value;
        value = XMLHelper.getAttribute(element, "Mac");
        if (value == null) {
            throw new ValidationException("SSANIC/Mac: attribute is required!");
        }
        this.mac = value;
        value = XMLHelper.getAttribute(element, "Gateway");
        if (value != null) {
            this.gateway = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SubnetMask")) != null) {
            this.subnetMask = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SSANIC");
        if (this.ip != null) {
            element.setAttribute("Ip", this.ip);
        }
        if (this.mac != null) {
            element.setAttribute("Mac", this.mac);
        }
        if (this.gateway != null) {
            element.setAttribute("Gateway", this.gateway);
        }
        if (this.subnetMask != null) {
            element.setAttribute("SubnetMask", this.subnetMask);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SSANIC ");
            if (this.ip != null) {
                strAttrs.append("Ip=\"").append(AbstractSchema.checkXMLContent(this.ip)).append("\" ");
            }
            if (this.mac != null) {
                strAttrs.append("Mac=\"").append(AbstractSchema.checkXMLContent(this.mac)).append("\" ");
            }
            if (this.gateway != null) {
                strAttrs.append("Gateway=\"").append(AbstractSchema.checkXMLContent(this.gateway)).append("\" ");
            }
            if (this.subnetMask != null) {
                strAttrs.append("SubnetMask=\"").append(AbstractSchema.checkXMLContent(this.subnetMask)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SSANIC>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

