/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SSAIDS
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String version;
    private String serialNumber;
    private String checksum;

    public SSAIDS() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "SSAIDS";
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.version = value;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.serialNumber = value;
    }

    public String getOptChecksum() {
        return this.checksum;
    }

    public void setOptChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.checksum = value;
    }

    @Override
    public int getObjectType() {
        return 262172;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.version == null) {
            throw new ValidationException("SSAIDS/Version: attribute is required!");
        }
        if (this.serialNumber == null) {
            throw new ValidationException("SSAIDS/SerialNumber: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Version");
            if (value == null) {
                throw new ValidationException("SSAIDS/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("SerialNumber");
            if (value == null) {
                throw new ValidationException("SSAIDS/SerialNumber: attribute is required!");
            }
            this.serialNumber = value;
            value = attris.getValue("Checksum");
            if (value != null) {
                this.checksum = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SSAIDS".equals(element.getNodeName())) {
            throw new ValidationException("SSAIDS: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Version");
        if (value == null) {
            throw new ValidationException("SSAIDS/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "SerialNumber");
        if (value == null) {
            throw new ValidationException("SSAIDS/SerialNumber: attribute is required!");
        }
        this.serialNumber = value;
        value = XMLHelper.getAttribute(element, "Checksum");
        if (value != null) {
            this.checksum = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SSAIDS");
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.serialNumber != null) {
            element.setAttribute("SerialNumber", this.serialNumber);
        }
        if (this.checksum != null) {
            element.setAttribute("Checksum", this.checksum);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SSAIDS ");
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.serialNumber != null) {
                strAttrs.append("SerialNumber=\"").append(AbstractSchema.checkXMLContent(this.serialNumber)).append("\" ");
            }
            if (this.checksum != null) {
                strAttrs.append("Checksum=\"").append(AbstractSchema.checkXMLContent(this.checksum)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SSAIDS>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

