/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Memory
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private Long size;
    private Long free;

    public Memory() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "Memory";
    }

    public Long getOptSize() {
        return this.size;
    }

    public void setOptSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.size = value;
    }

    public Long getOptFree() {
        return this.free;
    }

    public void setOptFree(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.free = value;
    }

    @Override
    public int getObjectType() {
        return 262162;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block10: {
            try {
                String value = attris.getValue("Size");
                if (value != null) {
                    try {
                        this.size = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("Memory/Size: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("Memory/Size: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("Free")) == null) break block10;
                try {
                    this.free = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("Memory/Free: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("Memory/Free: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Memory".equals(element.getNodeName())) {
            throw new ValidationException("Memory: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Size");
        if (value != null) {
            try {
                this.size = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Memory/Size: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Free")) != null) {
            try {
                this.free = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Memory/Free: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Memory");
        if (this.size != null) {
            element.setAttribute("Size", this.size.toString());
        }
        if (this.free != null) {
            element.setAttribute("Free", this.free.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Memory ");
            if (this.size != null) {
                strAttrs.append("Size=\"").append(this.size.toString()).append("\" ");
            }
            if (this.free != null) {
                strAttrs.append("Free=\"").append(this.free.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Memory>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

