/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LdapSetting
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String ldapServer;
    private Integer portNumber;
    private String searchBase;
    private String authAccount;
    private String password;
    private String filter;
    private Boolean useSSL;

    public LdapSetting() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "LdapSetting";
    }

    public String getLdapServer() {
        return this.ldapServer;
    }

    public void setLdapServer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ldapServer = value;
    }

    public Integer getDefPortNumber() {
        return 389;
    }

    public Integer getOptPortNumber() {
        return this.portNumber;
    }

    public void setOptPortNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.portNumber = value;
    }

    public String getOptSearchBase() {
        return this.searchBase;
    }

    public void setOptSearchBase(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.searchBase = value;
    }

    public String getOptAuthAccount() {
        return this.authAccount;
    }

    public void setOptAuthAccount(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.authAccount = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public String getOptFilter() {
        return this.filter;
    }

    public void setOptFilter(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.filter = value;
    }

    public Boolean getDefUseSSL() {
        return Boolean.TRUE;
    }

    public Boolean getOptUseSSL() {
        return this.useSSL;
    }

    public void setOptUseSSL(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.useSSL = value;
    }

    @Override
    public int getObjectType() {
        return 262192;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.ldapServer == null) {
            throw new ValidationException("LdapSetting/LdapServer: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("LdapServer");
            if (value == null) {
                throw new ValidationException("LdapSetting/LdapServer: attribute is required!");
            }
            this.ldapServer = value;
            value = attris.getValue("PortNumber");
            if (value != null) {
                try {
                    this.portNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LdapSetting/PortNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LdapSetting/PortNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SearchBase")) != null) {
                this.searchBase = value;
            }
            if ((value = attris.getValue("AuthAccount")) != null) {
                this.authAccount = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("Filter")) != null) {
                this.filter = value;
            }
            if ((value = attris.getValue("UseSSL")) != null) {
                this.useSSL = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LdapSetting".equals(element.getNodeName())) {
            throw new ValidationException("LdapSetting: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "LdapServer");
        if (value == null) {
            throw new ValidationException("LdapSetting/LdapServer: attribute is required!");
        }
        this.ldapServer = value;
        value = XMLHelper.getAttribute(element, "PortNumber");
        if (value != null) {
            try {
                this.portNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LdapSetting/PortNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SearchBase")) != null) {
            this.searchBase = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AuthAccount")) != null) {
            this.authAccount = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Filter")) != null) {
            this.filter = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UseSSL")) != null) {
            this.useSSL = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("LdapSetting");
        if (this.ldapServer != null) {
            element.setAttribute("LdapServer", this.ldapServer);
        }
        if (this.portNumber != null) {
            element.setAttribute("PortNumber", this.portNumber.toString());
        }
        if (this.searchBase != null) {
            element.setAttribute("SearchBase", this.searchBase);
        }
        if (this.authAccount != null) {
            element.setAttribute("AuthAccount", this.authAccount);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.filter != null) {
            element.setAttribute("Filter", this.filter);
        }
        if (this.useSSL != null) {
            element.setAttribute("UseSSL", this.useSSL != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LdapSetting ");
            if (this.ldapServer != null) {
                strAttrs.append("LdapServer=\"").append(AbstractSchema.checkXMLContent(this.ldapServer)).append("\" ");
            }
            if (this.portNumber != null) {
                strAttrs.append("PortNumber=\"").append(this.portNumber.toString()).append("\" ");
            }
            if (this.searchBase != null) {
                strAttrs.append("SearchBase=\"").append(AbstractSchema.checkXMLContent(this.searchBase)).append("\" ");
            }
            if (this.authAccount != null) {
                strAttrs.append("AuthAccount=\"").append(AbstractSchema.checkXMLContent(this.authAccount)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.filter != null) {
                strAttrs.append("Filter=\"").append(AbstractSchema.checkXMLContent(this.filter)).append("\" ");
            }
            if (this.useSSL != null) {
                strAttrs.append("UseSSL=").append(this.useSSL != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LdapSetting>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

