/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.IPLEntitlement;
import com.sygate.scm.common.configobject.rpc.IPLFulfillmentError;
import com.sygate.scm.common.configobject.rpc.IPLGeneralError;
import com.sygate.scm.common.configobject.rpc.IPLUserInputError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IPLResponse
extends AbstractSchema {
    public static final Integer IPL_ENTITLEMENT = 0;
    public static final Integer IPL_FULFILLMENTERROR = 1;
    public static final Integer IPL_GENERALERROR = 2;
    public static final Integer IPL_USERINPUTERROR = 3;
    private static final long serialVersionUID = 1L;
    private Integer responseType;

    public IPLResponse() {
        this.nameSpace = "rpc";
        this.children.put(262257, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(262258, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(262259, new ChildGroup(0, 1));
        this.children.put(262260, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "IPLResponse";
    }

    public Integer getOptResponseType() {
        return this.responseType;
    }

    public String getOptResponseTypeValue() throws ValidationException {
        if (this.responseType == null) {
            return null;
        }
        String s = null;
        switch (this.responseType) {
            case 0: {
                s = "IPL_ENTITLEMENT";
                break;
            }
            case 1: {
                s = "IPL_FULFILLMENTERROR";
                break;
            }
            case 2: {
                s = "IPL_GENERALERROR";
                break;
            }
            case 3: {
                s = "IPL_USERINPUTERROR";
                break;
            }
            default: {
                throw new ValidationException("IPLResponse/ResponseType: invalid attribute value:" + this.responseType + "!");
            }
        }
        return s;
    }

    public void setOptResponseType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.responseType = value;
    }

    public void setOptResponseTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.responseType = null;
            return;
        }
        if ("IPL_ENTITLEMENT".equals(value)) {
            this.responseType = IPL_ENTITLEMENT;
        } else if ("IPL_FULFILLMENTERROR".equals(value)) {
            this.responseType = IPL_FULFILLMENTERROR;
        } else if ("IPL_GENERALERROR".equals(value)) {
            this.responseType = IPL_GENERALERROR;
        } else if ("IPL_USERINPUTERROR".equals(value)) {
            this.responseType = IPL_USERINPUTERROR;
        } else {
            throw new ValidationException("IPLResponse/ResponseType: invalid attribute value:" + value + "!");
        }
    }

    public void addIPLEntitlement(IPLEntitlement value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIPLEntitlement(int index, IPLEntitlement value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IPLEntitlement> getIPLEntitlement() {
        Vector<IPLEntitlement> v = new Vector<IPLEntitlement>();
        for (Transportable child : (ChildGroup)this.children.get(262257)) {
            v.add((IPLEntitlement)child);
        }
        return v;
    }

    public int getIPLEntitlementCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262257);
        return childGroup.size();
    }

    public IPLEntitlement getIPLEntitlement(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262257);
        return (IPLEntitlement)childGroup.get(index);
    }

    public void setIPLEntitlement(int index, IPLEntitlement value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIPLEntitlement(IPLEntitlement value) {
        this.removeChild(value);
    }

    public void addIPLFulfillmentError(IPLFulfillmentError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIPLFulfillmentError(int index, IPLFulfillmentError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IPLFulfillmentError> getIPLFulfillmentError() {
        Vector<IPLFulfillmentError> v = new Vector<IPLFulfillmentError>();
        for (Transportable child : (ChildGroup)this.children.get(262258)) {
            v.add((IPLFulfillmentError)child);
        }
        return v;
    }

    public int getIPLFulfillmentErrorCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262258);
        return childGroup.size();
    }

    public IPLFulfillmentError getIPLFulfillmentError(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262258);
        return (IPLFulfillmentError)childGroup.get(index);
    }

    public void setIPLFulfillmentError(int index, IPLFulfillmentError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIPLFulfillmentError(IPLFulfillmentError value) {
        this.removeChild(value);
    }

    public IPLGeneralError getOptIPLGeneralError() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262259);
        if (childGroup.size() > 0) {
            return (IPLGeneralError)childGroup.get(0);
        }
        return null;
    }

    public void setOptIPLGeneralError(IPLGeneralError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IPLGeneralError obj = this.getOptIPLGeneralError();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addIPLUserInputError(IPLUserInputError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIPLUserInputError(int index, IPLUserInputError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IPLUserInputError> getIPLUserInputError() {
        Vector<IPLUserInputError> v = new Vector<IPLUserInputError>();
        for (Transportable child : (ChildGroup)this.children.get(262260)) {
            v.add((IPLUserInputError)child);
        }
        return v;
    }

    public int getIPLUserInputErrorCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262260);
        return childGroup.size();
    }

    public IPLUserInputError getIPLUserInputError(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262260);
        return (IPLUserInputError)childGroup.get(index);
    }

    public void setIPLUserInputError(int index, IPLUserInputError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIPLUserInputError(IPLUserInputError value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 262256;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IPLEntitlement) {
            try {
                this.addIPLEntitlement((IPLEntitlement)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IPLFulfillmentError) {
            try {
                this.addIPLFulfillmentError((IPLFulfillmentError)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IPLGeneralError) {
            try {
                this.setOptIPLGeneralError((IPLGeneralError)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IPLUserInputError) {
            try {
                this.addIPLUserInputError((IPLUserInputError)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ResponseType");
            if (value != null) {
                this.setOptResponseTypeValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getIPLEntitlementCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIPLEntitlement(i).setReadonly();
        }
        objCnt = this.getIPLFulfillmentErrorCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIPLFulfillmentError(i).setReadonly();
        }
        if (this.getOptIPLGeneralError() != null) {
            this.getOptIPLGeneralError().setReadonly();
        }
        objCnt = this.getIPLUserInputErrorCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIPLUserInputError(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"IPLResponse".equals(element.getNodeName())) {
            throw new ValidationException("IPLResponse: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ResponseType");
        if (value != null) {
            this.setOptResponseTypeValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IPLEntitlement");
        for (i = 0; i < v.size(); ++i) {
            IPLEntitlement iPLEntitlementObj = new IPLEntitlement();
            iPLEntitlementObj.importFromElement(v.get(i));
            this.addIPLEntitlement(iPLEntitlementObj);
        }
        v = XMLHelper.getChildElementByName(element, "IPLFulfillmentError");
        for (i = 0; i < v.size(); ++i) {
            IPLFulfillmentError iPLFulfillmentErrorObj = new IPLFulfillmentError();
            iPLFulfillmentErrorObj.importFromElement(v.get(i));
            this.addIPLFulfillmentError(iPLFulfillmentErrorObj);
        }
        v = XMLHelper.getChildElementByName(element, "IPLGeneralError");
        if (v.size() > 0) {
            IPLGeneralError iPLGeneralErrorObj = new IPLGeneralError();
            iPLGeneralErrorObj.importFromElement(v.get(0));
            this.setOptIPLGeneralError(iPLGeneralErrorObj);
        }
        v = XMLHelper.getChildElementByName(element, "IPLUserInputError");
        for (int i2 = 0; i2 < v.size(); ++i2) {
            IPLUserInputError iPLUserInputErrorObj = new IPLUserInputError();
            iPLUserInputErrorObj.importFromElement(v.get(i2));
            this.addIPLUserInputError(iPLUserInputErrorObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("IPLResponse");
        if (this.responseType != null) {
            element.setAttribute("ResponseType", this.getOptResponseTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IPLResponse ");
            if (this.responseType != null) {
                strAttrs.append("ResponseType=\"").append(this.getOptResponseTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IPLResponse>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

