/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.IPLSerialNumber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IPLRequest
extends AbstractSchema {
    public static final Integer NO_INFO_REQUIRED = 0;
    public static final Integer COMPANY_INFO_REQUIRED = 1;
    public static final Integer TECHNICAL_CONTACT_INFO_REQUIRED = 2;
    public static final Integer BOTH_INFO_REQUIRED = 3;
    private static final long serialVersionUID = 1L;
    private Integer infoRequired;

    public IPLRequest() {
        this.nameSpace = "rpc";
        this.children.put(262274, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "IPLRequest";
    }

    public Integer getOptInfoRequired() {
        return this.infoRequired;
    }

    public String getOptInfoRequiredValue() throws ValidationException {
        if (this.infoRequired == null) {
            return null;
        }
        String s = null;
        switch (this.infoRequired) {
            case 0: {
                s = "NO_INFO_REQUIRED";
                break;
            }
            case 1: {
                s = "COMPANY_INFO_REQUIRED";
                break;
            }
            case 2: {
                s = "TECHNICAL_CONTACT_INFO_REQUIRED";
                break;
            }
            case 3: {
                s = "BOTH_INFO_REQUIRED";
                break;
            }
            default: {
                throw new ValidationException("IPLRequest/InfoRequired: invalid attribute value:" + this.infoRequired + "!");
            }
        }
        return s;
    }

    public void setOptInfoRequired(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.infoRequired = value;
    }

    public void setOptInfoRequiredValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.infoRequired = null;
            return;
        }
        if ("NO_INFO_REQUIRED".equals(value)) {
            this.infoRequired = NO_INFO_REQUIRED;
        } else if ("COMPANY_INFO_REQUIRED".equals(value)) {
            this.infoRequired = COMPANY_INFO_REQUIRED;
        } else if ("TECHNICAL_CONTACT_INFO_REQUIRED".equals(value)) {
            this.infoRequired = TECHNICAL_CONTACT_INFO_REQUIRED;
        } else if ("BOTH_INFO_REQUIRED".equals(value)) {
            this.infoRequired = BOTH_INFO_REQUIRED;
        } else {
            throw new ValidationException("IPLRequest/InfoRequired: invalid attribute value:" + value + "!");
        }
    }

    public void addIPLSerialNumber(IPLSerialNumber value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIPLSerialNumber(int index, IPLSerialNumber value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IPLSerialNumber> getIPLSerialNumber() {
        Vector<IPLSerialNumber> v = new Vector<IPLSerialNumber>();
        for (Transportable child : (ChildGroup)this.children.get(262274)) {
            v.add((IPLSerialNumber)child);
        }
        return v;
    }

    public int getIPLSerialNumberCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262274);
        return childGroup.size();
    }

    public IPLSerialNumber getIPLSerialNumber(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262274);
        return (IPLSerialNumber)childGroup.get(index);
    }

    public void setIPLSerialNumber(int index, IPLSerialNumber value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIPLSerialNumber(IPLSerialNumber value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 262273;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IPLSerialNumber) {
            try {
                this.addIPLSerialNumber((IPLSerialNumber)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("InfoRequired");
            if (value != null) {
                this.setOptInfoRequiredValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getIPLSerialNumberCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getIPLSerialNumber(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"IPLRequest".equals(element.getNodeName())) {
            throw new ValidationException("IPLRequest: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "InfoRequired");
        if (value != null) {
            this.setOptInfoRequiredValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IPLSerialNumber");
        for (int i = 0; i < v.size(); ++i) {
            IPLSerialNumber iPLSerialNumberObj = new IPLSerialNumber();
            iPLSerialNumberObj.importFromElement(v.get(i));
            this.addIPLSerialNumber(iPLSerialNumberObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("IPLRequest");
        if (this.infoRequired != null) {
            element.setAttribute("InfoRequired", this.getOptInfoRequiredValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IPLRequest ");
            if (this.infoRequired != null) {
                strAttrs.append("InfoRequired=\"").append(this.getOptInfoRequiredValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IPLRequest>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

